/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.BoundingBoxSet;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class MultiBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<MultiBlockPosition> MULTIPOS = EnumProperty.m_61587_((String)"multipos", MultiBlockPosition.class);
    private static final Map<Block, BoundingBoxSet> BOUNDING_BOXES = new HashMap<Block, BoundingBoxSet>();
    protected int width;
    protected int length;
    protected double height;
    protected boolean jsonOffset;

    protected MultiBlock(BlockBehaviour.Properties builder, int width, double height, int length) {
        this(builder, width, height, length, false);
    }

    protected MultiBlock(BlockBehaviour.Properties builder, int width, double height, int length, boolean jsonOffset) {
        super(builder);
        this.width = width;
        this.height = height;
        this.length = length;
        this.jsonOffset = jsonOffset;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, MULTIPOS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        AABB aabb = this.getMultiBlockBoundingBox(worldIn, pos, (MultiBlockPosition)((Object)state.m_61143_(MULTIPOS)), (Direction)state.m_61143_((Property)FACING));
        return Shapes.m_83064_((AABB)(aabb == null ? new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0) : aabb));
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    protected AABB getMultiBlockBoundingBox(BlockGetter worldIn, BlockPos pos, MultiBlockPosition multiPos, Direction facing) {
        BoundingBoxSet boundingBoxSet = BOUNDING_BOXES.computeIfAbsent((Block)this, block -> new BoundingBoxSet(this.getWidth(), this.getHeight(), this.getLength(), this.getJsonOffset()));
        if (worldIn.m_8055_(pos).m_60734_() != this) {
            return new AABB((double)this.getWidthOffset(), 0.0, (double)this.getLengthOffset(), (double)(this.getWidth() + this.getWidthOffset()), this.getHeight(), (double)(this.getLength() + this.getLengthOffset()));
        }
        if (multiPos == MultiBlockPosition.BASE) {
            if (facing == Direction.SOUTH) {
                return boundingBoxSet.AABBBaseSouth;
            }
            if (facing == Direction.NORTH) {
                return boundingBoxSet.AABBBaseNorth;
            }
            if (facing == Direction.EAST) {
                return boundingBoxSet.AABBBaseEast;
            }
            return boundingBoxSet.AABBBaseWest;
        }
        BlockPos base = this.findBaseBlock(worldIn, pos.m_122032_(), worldIn.m_8055_(pos));
        return this.getMultiBlockBoundingBox(worldIn, base, MultiBlockPosition.BASE, (Direction)worldIn.m_8055_(base).m_61143_((Property)FACING)).m_82386_((double)(base.m_123341_() - pos.m_123341_()), (double)(base.m_123342_() - pos.m_123342_()), (double)(base.m_123343_() - pos.m_123343_()));
    }

    int getWidthOffset() {
        if (this.jsonOffset && this.width > 2) {
            return -1;
        }
        return 0;
    }

    int getLengthOffset() {
        if (this.jsonOffset && this.length > 2) {
            return -1;
        }
        return 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(MULTIPOS) == MultiBlockPosition.BASE) {
            return this.getTileEntity(pos, state).orElse(null);
        }
        return null;
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
    }

    protected abstract Optional<BlockEntity> getTileEntity(BlockPos var1, BlockState var2);

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        MultiBlockPosition multiPos = (MultiBlockPosition)((Object)state.m_61143_(MULTIPOS));
        BlockPos location = this.findBaseBlock((BlockGetter)world, pos.m_122032_(), state);
        if (location.m_121878_() != pos.m_121878_()) {
            state = world.m_8055_(location);
            try {
                multiPos = (MultiBlockPosition)((Object)state.m_61143_(MULTIPOS));
            }
            catch (Exception e) {
                return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
        }
        this.setMultiBlocksWidth(location, world, state);
        if (!player.m_7500_() && !world.f_46443_) {
            List<ItemStack> drops = this.m_49635_(state, new LootParams.Builder((ServerLevel)world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)player.m_21120_(InteractionHand.MAIN_HAND)));
            for (ItemStack drop : drops) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), drop);
                world.m_7967_((Entity)itemEntity);
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder context) {
        MultiBlockPosition multiPos = (MultiBlockPosition)((Object)state.m_61143_(MULTIPOS));
        if (multiPos != MultiBlockPosition.BASE) {
            return Collections.emptyList();
        }
        return super.m_49635_(state, context);
    }

    public BlockPos findBaseBlock(BlockGetter world, BlockPos.MutableBlockPos pos, BlockState state) {
        if (state.m_60734_() != this) {
            return pos;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        MultiBlockPosition multipos = (MultiBlockPosition)((Object)state.m_61143_(MULTIPOS));
        if (multipos == MultiBlockPosition.TOP && world.m_8055_(pos.m_121945_(Direction.DOWN)).m_60734_() == this) {
            pos.m_122173_(Direction.DOWN);
        } else if (multipos == MultiBlockPosition.BOTTOM && world.m_8055_(pos.m_121945_(facing.m_122424_())).m_60734_() == this) {
            pos.m_122175_(facing, -1);
        } else {
            return new BlockPos((Vec3i)pos);
        }
        return this.findBaseBlock(world, pos, world.m_8055_((BlockPos)pos));
    }

    private void setMultiBlocksWidth(BlockPos pos, Level world, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.EAST) {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, 0, l, state, world);
            }
        } else if (facing == Direction.NORTH) {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, l, 0, state, world);
            }
        } else if (facing == Direction.WEST) {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, 0, -1 * l, state, world);
            }
        } else {
            for (int l = this.getWidthOffset(); l < this.getWidth() + this.getWidthOffset(); ++l) {
                this.setMultiBlocksLength(pos, -1 * l, 0, state, world);
            }
        }
    }

    private void setMultiBlocksLength(BlockPos pos, int xd, int zd, BlockState state, Level world) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.EAST) {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd + w, zd, state, world);
            }
        } else if (facing == Direction.NORTH) {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd, zd - w, state, world);
            }
        } else if (facing == Direction.WEST) {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd - w, zd, state, world);
            }
        } else {
            for (int w = this.getLengthOffset(); w < this.getLength() + this.getLengthOffset(); ++w) {
                this.setMultiBlocksHeight(pos, xd, zd + w, state, world);
            }
        }
    }

    private void setMultiBlocksHeight(BlockPos pos, int xd, int zd, BlockState state, Level world) {
        int h = 0;
        while ((double)h < this.getHeight()) {
            BlockPos p = new BlockPos(pos.m_123341_() + xd, pos.m_123342_() + h, pos.m_123343_() + zd);
            world.m_7471_(p, false);
            ++h;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean getJsonOffset() {
        return this.jsonOffset;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }
}

