/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.GenericRotatableBlock;
import com.pixelmonmod.pixelmon.blocks.StickPlateBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovementPlateBlock
extends GenericRotatableBlock {
    private static final int MAX_LOOP_LENGTH = 100;
    private static final AABB AABB = new AABB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public MovementPlateBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.5f).m_284180_(MapColor.f_283812_));
    }

    public Boolean isLoop(Level level, BlockPos posOriginal, int maxLength) {
        BlockPos posCurrent = new BlockPos((Vec3i)posOriginal);
        for (int iteration = 1; iteration < maxLength; ++iteration) {
            Direction direction = (Direction)level.m_8055_(posCurrent).m_61143_(GenericRotatableBlock.FACING);
            switch (direction) {
                case NORTH: {
                    posCurrent = posCurrent.m_122012_();
                    break;
                }
                case SOUTH: {
                    posCurrent = posCurrent.m_122019_();
                    break;
                }
                case EAST: {
                    posCurrent = posCurrent.m_122029_();
                    break;
                }
                case WEST: {
                    posCurrent = posCurrent.m_122024_();
                    break;
                }
                default: {
                    return false;
                }
            }
            if (!(level.m_8055_(posCurrent).m_60734_() instanceof MovementPlateBlock)) {
                return false;
            }
            if (!posCurrent.equals((Object)posOriginal)) continue;
            return true;
        }
        return false;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        Direction facing = (Direction)state.m_61143_(GenericRotatableBlock.FACING);
        double speedModifier = 1.0;
        if (this.targetSticky(worldIn, pos)) {
            speedModifier = 0.4;
        }
        if (entity instanceof DenEntity) {
            return;
        }
        double distanceFromCenterX = entity.m_20185_() - (double)pos.m_123341_() - 0.5;
        double distanceFromCenterZ = entity.m_20189_() - (double)pos.m_123343_() - 0.5;
        double pushToMiddle = 0.2;
        double motionZ = 0.0;
        double motionX = 0.0;
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            motionZ = (double)facing.m_122431_() * speedModifier;
            if (distanceFromCenterX > 0.1) {
                if (entity.m_20184_().f_82479_ > -0.2) {
                    motionX = -1.0 * pushToMiddle;
                }
            } else if (distanceFromCenterX < -0.1) {
                if (entity.m_20184_().f_82479_ < 0.2) {
                    motionX = pushToMiddle;
                }
            } else {
                motionX = 0.0;
            }
        } else if (facing == Direction.EAST || facing == Direction.WEST) {
            motionX = (double)facing.m_122429_() * speedModifier;
            if (distanceFromCenterZ > 0.1) {
                if (entity.m_20184_().f_82481_ > -0.2) {
                    motionZ = -1.0 * pushToMiddle;
                }
            } else if (distanceFromCenterZ < -0.1) {
                if (entity.m_20184_().f_82481_ < 0.2) {
                    motionZ = pushToMiddle;
                }
            } else {
                motionZ = 0.0;
            }
        }
        entity.m_20334_(motionX, (double)facing.m_122430_() * speedModifier, motionZ);
    }

    public boolean targetSticky(Level world, BlockPos pos) {
        BlockPos targetPos = null;
        Direction facing = (Direction)world.m_8055_(pos).m_61143_(FACING);
        switch (facing) {
            case NORTH: {
                targetPos = pos.m_122012_();
                break;
            }
            case SOUTH: {
                targetPos = pos.m_122019_();
                break;
            }
            case EAST: {
                targetPos = pos.m_122029_();
                break;
            }
            case WEST: {
                targetPos = pos.m_122024_();
                break;
            }
        }
        if (targetPos != null) {
            return world.m_8055_(targetPos).m_60734_() instanceof StickPlateBlock;
        }
        return false;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_(FACING, (Comparable)placer.m_6350_()), 2);
        if (this.isLoop(worldIn, pos, 100).booleanValue()) {
            worldIn.m_7471_(pos, false);
            if (!worldIn.f_46443_) {
                Player player = (Player)placer;
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.movepad.loopbuilderror", new Object[0]);
            }
        }
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Shapes.m_83064_((AABB)AABB);
    }
}

