/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.GracideaTileEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.Nullable;

public class GracideaBlock
extends GenericRotatableModelBlock
implements IPlantable,
BonemealableBlock {
    private static final AABB AABB = new AABB(0.3, 0.0, 0.3, 0.7, 0.2, 0.7);

    public GracideaBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60966_().m_60910_().m_60918_(SoundType.f_56740_).m_284180_(MapColor.f_283765_));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return GracideaBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.GRACIDEA.get()), GracideaTileEntity::tick);
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.PLAINS;
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GracideaTileEntity(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Shapes.m_83064_((AABB)AABB);
    }

    public ItemStack m_7397_(BlockGetter p_49823_, BlockPos p_49824_, BlockState p_49825_) {
        return new ItemStack((ItemLike)PixelmonItems.gracidea, 1);
    }

    public void m_213646_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean p_222953_) {
        serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new ItemStack((ItemLike)PixelmonItems.gracidea)));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(Level worldIn, BlockPos pos, BlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)PixelmonItems.gracidea)));
            worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    protected boolean canBlockStay(Level world, BlockPos pos, BlockState state) {
        return world.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50440_;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state) {
        GracideaTileEntity tile = (GracideaTileEntity)world.m_7702_(pos);
        if (tile != null) {
            return tile.canGrow();
        }
        return false;
    }

    public boolean m_214167_(Level level, RandomSource p_220879_, BlockPos blockPos, BlockState p_220881_) {
        GracideaTileEntity tile = BlockHelper.getTileEntity(GracideaTileEntity.class, (LevelReader)level, blockPos);
        if (tile != null) {
            return tile.canGrow();
        }
        return false;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource p_220875_, BlockPos blockPos, BlockState p_220877_) {
        GracideaTileEntity tile = BlockHelper.getTileEntity(GracideaTileEntity.class, (LevelReader)serverLevel, blockPos);
        if (tile != null && RandomHelper.getRandomChance(0.05f)) {
            tile.doGrow();
        }
    }
}

