/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.BellTileEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BellBlock
extends GenericModelBlock {
    private static final AABB AABB = new AABB((double)0.16f, (double)0.38f, (double)0.16f, (double)0.84f, 1.0, (double)0.84f);
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.f_61377_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private final Type bell;

    public BellBlock(Type bell) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(5.0f, 20.0f).m_284180_(MapColor.f_283906_));
        this.bell = bell;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return BellBlock.m_152132_(blockEntity, this.bell.get(), BellTileEntity::tick);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)AABB);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate;
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        if (direction == Direction.DOWN && (blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHMENT, (Comparable)BellAttachType.CEILING)).m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_60710_((LevelReader)context.m_43725_(), blockpos)) {
            return blockstate;
        }
        return null;
    }

    public Type getBell() {
        return this.bell;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ATTACHMENT});
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BellTileEntity(this.getBell(), blockPos, blockState);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        if (placer instanceof ServerPlayer && (te = worldIn.m_7702_(pos)) instanceof BellTileEntity) {
            BellTileEntity bell = (BellTileEntity)te;
            bell.owner = placer.m_20148_();
            bell.m_6596_();
        }
    }

    public ItemStack m_7397_(BlockGetter p_49823_, BlockPos p_49824_, BlockState p_49825_) {
        switch (this.bell) {
            case CLEAR: {
                return new ItemStack((ItemLike)Item.m_41439_((Block)PixelmonBlocks.clear_bell));
            }
            case TIDAL: {
                return new ItemStack((ItemLike)Item.m_41439_((Block)PixelmonBlocks.tidal_bell));
            }
        }
        return ItemStack.f_41583_;
    }

    public static enum Type {
        TIDAL(() -> (BlockEntityType)TileEntityRegistration.TIDAL_BELL.get()),
        CLEAR(() -> (BlockEntityType)TileEntityRegistration.CLEAR_BELL.get());

        private final Supplier<BlockEntityType<BellTileEntity>> supplier;

        private Type(Supplier<BlockEntityType<BellTileEntity>> supplier) {
            this.supplier = supplier;
        }

        public BlockEntityType<BellTileEntity> get() {
            return this.supplier.get();
        }
    }
}

