/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.tasks;

import com.pixelmonmod.pixelmon.battles.tasks.BattleTaskPacket;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class RaidShieldsTask
extends BattleTaskPacket {
    public UUID pokemonUUID;
    public int shields;
    public int maxShields;

    public RaidShieldsTask() {
    }

    public RaidShieldsTask(UUID pokemonUUID, int shields, int maxShields) {
        this.pokemonUUID = pokemonUUID;
        this.shields = shields;
        this.maxShields = maxShields;
    }

    @Override
    public boolean process(ClientBattleManager bm) {
        for (PixelmonClientData pixelmonClientData : ClientProxy.battleManager.displayedOurPokemon) {
            this.updatePokemon(pixelmonClientData, this);
        }
        for (PixelmonClientData pixelmonClientData : ClientProxy.battleManager.displayedEnemyPokemon) {
            this.updatePokemon(pixelmonClientData, this);
        }
        for (PixelmonClientData pokemon : ClientProxy.battleManager.fullOurPokemon) {
            this.updatePokemon(pokemon, this);
        }
        if (ClientProxy.battleManager.displayedAllyPokemon != null) {
            for (PixelmonClientData pixelmonClientData : ClientProxy.battleManager.displayedAllyPokemon) {
                this.updatePokemon(pixelmonClientData, this);
            }
        }
        return false;
    }

    private void updatePokemon(PixelmonClientData pokemon, RaidShieldsTask message) {
        if (pokemon != null && pokemon.pokemonUUID.equals(message.pokemonUUID)) {
            int currentShields = pokemon.shields;
            pokemon.shields = message.shields;
            pokemon.maxShields = message.maxShields;
            if (currentShields > pokemon.shields) {
                pokemon.lostShield = true;
            }
            if (currentShields == 0 && pokemon.shields > 0) {
                SoundHelper.playSound(SoundEvents.f_11673_, 1.0f, 1.0f);
            }
        }
    }

    @Override
    @Nullable
    public UUID getPokemonID() {
        return this.pokemonUUID;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pokemonUUID = buf.m_130259_();
        this.shields = buf.readInt();
        this.maxShields = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.pokemonUUID);
        buf.writeInt(this.shields);
        buf.writeInt(this.maxShields);
    }
}

