/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.tasks;

import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.battles.tasks.BattleMessagePacket;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class EnforcedSwitchTask
extends BattleMessagePacket {
    private int switchPosition = -1;
    private boolean preventFleeOnSwitch = false;

    public EnforcedSwitchTask() {
    }

    public EnforcedSwitchTask(int switchPosition) {
        this(switchPosition, false);
    }

    public EnforcedSwitchTask(int switchPosition, boolean preventFleeOnSwitch) {
        this.switchPosition = switchPosition;
        this.preventFleeOnSwitch = preventFleeOnSwitch;
    }

    @Override
    public Component getMessage() {
        return Component.m_237115_((String)"battlecontroller.switch");
    }

    @Override
    public boolean process(ClientBattleManager bm) {
        bm.setMode(BattleMode.ENFORCED_SWITCH, BattleMode.MAIN_MENU);
        bm.currentPokemon = this.switchPosition;
        bm.enforcedFleeFailed = false;
        bm.preventFleeOnSwitch = this.preventFleeOnSwitch;
        return false;
    }

    @Override
    @Nullable
    public UUID getPokemonID() {
        return null;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.switchPosition);
        buffer.writeBoolean(this.preventFleeOnSwitch);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.switchPosition = buffer.readInt();
        this.preventFleeOnSwitch = buffer.readBoolean();
    }
}

