/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Illusion;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.TransformPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleDataPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Transformed
extends StatusBase {
    private transient int tempAttack;
    private transient int tempDefense;
    private transient int tempSpecialAttack;
    private transient int tempSpecialDefense;
    private transient int tempSpeed;
    private transient Moveset moveset;
    public Species transformedPokemon = null;
    public Gender transformedGender = null;
    public String transformedForm = null;
    public String transformedPalette = "none";

    public Transformed(PixelmonWrapper user, PixelmonWrapper target) {
        super(StatusType.Transformed);
        int[] targetStats = target.getBattleStats().getBaseBattleStats();
        this.tempAttack = targetStats[BattleStatsType.ATTACK.getStatIndex()];
        this.tempDefense = targetStats[BattleStatsType.DEFENSE.getStatIndex()];
        this.tempSpecialAttack = targetStats[BattleStatsType.SPECIAL_ATTACK.getStatIndex()];
        this.tempSpecialDefense = targetStats[BattleStatsType.SPECIAL_DEFENSE.getStatIndex()];
        this.tempSpeed = targetStats[BattleStatsType.SPEED.getStatIndex()];
        user.getBattleStats().copyStats(target.getBattleStats());
        if (!(target.getBattleAbility(false) instanceof Illusion)) {
            user.setTempAbility(target.getBattleAbility(false));
        }
        List<Element> newType = target.type;
        user.setTempType(newType);
        this.moveset = new Moveset().withPokemon(user.getInnerLink());
        Moveset targetMoveset = target.getMoveset();
        for (int i = 0; i < targetMoveset.size(); ++i) {
            Attack a = new Attack(targetMoveset.get(i).getMove());
            if (a.pp != 1) {
                a.pp = 5;
            }
            this.moveset.add(a);
        }
    }

    public void changeTransformedSprite(PixelmonWrapper user, PixelmonWrapper target) {
        this.transformedPokemon = target.getSpecies();
        this.transformedGender = target.getGender();
        this.transformedForm = target.getForm().getName();
        this.transformedPalette = target.getInnerLink().getPalette().getName();
        if (user.getPlayerOwner() != null) {
            this.updateOwner(user);
        }
    }

    private void updateOwner(PixelmonWrapper pokemon) {
        NetworkHelper.sendPacket(new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(pokemon.getTeamPokemon()), false), pokemon.getPlayerOwner());
        pokemon.bc.spectators.forEach(spectator -> spectator.sendMessage(new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(pokemon.getTeamPokemon()), !spectator.watchedName.equals(pokemon.getOwnerName()))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void applyToClientEntity(TransformPacket p) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            for (Entity e : mc.f_91073_.m_104735_()) {
                if (!(e instanceof PixelmonEntity) || e.m_19879_() != p.pixelmonID) continue;
                PixelmonEntity pokemon = (PixelmonEntity)e;
                pokemon.transform(p.transformedModel, p.transformedForm, p.transformedTexture, p.transformedParticles);
                break;
            }
        }
    }

    @Override
    public void applyBeforeEffect(PixelmonWrapper user, PixelmonWrapper target) {
    }

    @Override
    public void applyEndOfBattleEffect(PixelmonWrapper pokemon) {
        if (pokemon.entity != null) {
            pokemon.entity.cancelTransform();
        }
    }

    @Override
    public int[] modifyBaseStats(PixelmonWrapper user, int[] stats) {
        stats[BattleStatsType.ATTACK.getStatIndex()] = this.tempAttack;
        stats[BattleStatsType.DEFENSE.getStatIndex()] = this.tempDefense;
        stats[BattleStatsType.SPECIAL_ATTACK.getStatIndex()] = this.tempSpecialAttack;
        stats[BattleStatsType.SPECIAL_DEFENSE.getStatIndex()] = this.tempSpecialDefense;
        stats[BattleStatsType.SPEED.getStatIndex()] = this.tempSpeed;
        return stats;
    }
}

