/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;

public class Taunt
extends StatusBase {
    transient int turnsRemaining = 3;

    public Taunt() {
        super(StatusType.Taunt);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(this.type)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else {
            MutableComponent message = ChatHandler.getMessage("pixelmon.status.taunted", target.getNickname());
            target.addStatus(new Taunt(), user, message);
        }
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (a.getAttackCategory() != AttackCategory.STATUS) {
            return true;
        }
        if (user.usingZ && a.getAttackCategory() == AttackCategory.STATUS && !user.hasStatus(StatusType.MultiTurn)) {
            return true;
        }
        user.bc.sendToAll("pixelmon.status.tauntcantuse", user.getNickname(), a.getMove().getTranslatedName());
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (this.turnsRemaining <= 0) {
            pw.bc.sendToAll("pixelmon.status.tauntnolonger", pw.getNickname());
            pw.removeStatus(this);
            return;
        }
        for (Attack attack : pw.getMoveset()) {
            if (attack == null || attack.getAttackCategory() != AttackCategory.STATUS) continue;
            attack.setDisabled(true, pw);
        }
    }

    @Override
    public void onEndOfTurn(PixelmonWrapper pw) {
        --this.turnsRemaining;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly() || MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, bestUserChoices)) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            for (Attack attack : pw.getBattleAI().getMoveset(target)) {
                if (attack.getAttackCategory() != AttackCategory.STATUS) continue;
                userChoice.raiseWeight(20.0f);
            }
        }
    }
}

