/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Chlorophyll;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.DrySkin;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.FlowerGift;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Harvest;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.IgnoreWeather;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.LeafGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SolarPower;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Sunny
extends Weather {
    public Sunny() {
        this(5);
    }

    public Sunny(boolean extreme) {
        this(-1);
        this.extreme = extreme;
        this.langContinue = "pixelmon.status.extremelybrightlight";
    }

    public Sunny(int turnsToGo) {
        super(StatusType.Sunny, turnsToGo, EnumHeldItems.heatRock, "pixelmon.effect.harshsunlight", "pixelmon.status.brightlight", "pixelmon.status.sunlightfaded", false, false);
    }

    public Sunny(int turnsToGo, boolean isOverworldWeather) {
        super(StatusType.Sunny, turnsToGo, EnumHeldItems.heatRock, "pixelmon.effect.harshsunlight", "pixelmon.status.brightlight", "pixelmon.status.sunlightfaded", false, isOverworldWeather);
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Sunny(turns);
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (!a.ignoresWeather(user)) {
            if (a.getType() == Element.FIRE) {
                power = (int)((double)power * 1.5);
            } else if (a.getType() == Element.WATER) {
                power = (int)((double)power * 0.5);
            }
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        Attack attack = user.attack;
        if (!attack.ignoresWeather(user) && this.extreme && Attack.dealsDamage(attack) && attack.getType() == Element.WATER) {
            for (PixelmonWrapper pw : pokemon.bc.getActivePokemon()) {
                if (!(pw.getBattleAbility() instanceof IgnoreWeather)) continue;
                return false;
            }
            pokemon.bc.sendToAll("pixelmon.status.harshsunlightwaterattack", new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        Ability ability = target.getBattleAbility();
        if (ability instanceof Chlorophyll || ability instanceof FlowerGift || ability instanceof Harvest || ability instanceof LeafGuard || ability instanceof SolarPower) {
            ++benefits;
        } else if (ability instanceof DrySkin) {
            --benefits;
        }
        List<Attack> moveset = user.getBattleAI().getMoveset(target);
        if (Attack.hasOffensiveAttackType(moveset, Element.FIRE) || Attack.hasAttack(moveset, AttackRegistry.WEATHER_BALL)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.SOLAR_BEAM)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.MOONLIGHT, AttackRegistry.MORNING_SUN, AttackRegistry.SYNTHESIS)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.GROWTH)) {
            ++benefits;
        }
        if (Attack.hasOffensiveAttackType(moveset, Element.WATER)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.HURRICANE)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.THUNDER)) {
            --benefits;
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new Sunny(this.turnsToGo);
    }
}

