/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class StealthRock
extends EntryHazard {
    public StealthRock() {
        super(StatusType.StealthRock, 1);
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public boolean isUnharmed(PixelmonWrapper pw) {
        return super.isUnharmed(pw) || pw.getBattleAbility() instanceof MagicGuard;
    }

    @Override
    public int getDamage(PixelmonWrapper pw) {
        float effectiveness = Element.getTotalEffectiveness(pw.type, Element.ROCK, pw.bc.rules.hasClause(BattleClauseRegistry.INVERSE_BATTLE));
        float modifier = effectiveness * 12.5f;
        int damage = pw.getPercentMaxHealth(modifier);
        return damage;
    }

    @Override
    protected String getFirstLayerMessage() {
        return "pixelmon.effect.floatingstones";
    }

    @Override
    protected String getAffectedMessage() {
        return "pixelmon.status.hurtbystealthrock";
    }

    @Override
    public int getAIWeight() {
        return 30;
    }

    @Override
    public EntryHazard getNewInstance() {
        return new StealthRock();
    }
}

