/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;

public abstract class StatusPersist
extends StatusBase {
    public StatusPersist(StatusType type) {
        super(type);
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128376_("Status", (short)this.type.ordinal());
    }

    public abstract StatusPersist restoreFromNBT(CompoundTag var1);

    public static StatusPersist readStatusFromNBT(CompoundTag nbt) {
        StatusPersist status = NoStatus.noStatus;
        int statusCount = 0;
        if (nbt.m_128441_("Status")) {
            StatusPersist s = StatusType.getEffectInstance(nbt.m_128451_("Status"));
            if (s != null) {
                status = s.restoreFromNBT(nbt);
            }
        } else if (nbt.m_128441_("StatusCount")) {
            int i;
            statusCount = nbt.m_128448_("StatusCount");
            for (i = 0; i < statusCount; ++i) {
                StatusPersist s = StatusType.getEffectInstance(nbt.m_128451_("Status" + i));
                if (s == null) continue;
                status = s.restoreFromNBT(nbt);
                break;
            }
            for (i = 0; i < statusCount; ++i) {
                nbt.m_128473_("Status" + i);
            }
            nbt.m_128473_("StatusCount");
        }
        return status;
    }

    protected boolean addStatus(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage, String alreadyMessage, String addMessage) {
        boolean result;
        boolean isStatusMove;
        boolean bl = isStatusMove = attack != null && attack.getAttackCategory() == AttackCategory.STATUS;
        if (attack != null && (target.hasStatus(StatusType.Sleep) && attack.getMove().hasEffect(Sleep.class) || target.hasStatus(StatusType.Paralysis) && attack.getMove().hasEffect(Paralysis.class))) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll(alreadyMessage, target.getNickname());
                user.setAttackFailed();
            }
            return false;
        }
        if (target.hasNonVolatileStatus() || this.isImmune(target)) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.setAttackFailed();
            }
            return false;
        }
        MutableComponent message = null;
        if (showMessage) {
            message = ChatHandler.getMessage(addMessage, target.getNickname());
        }
        if (!(result = target.addStatus(this, user, message)) && isStatusMove) {
            user.setAttackFailed();
        }
        return result;
    }

    public boolean isStatus(StatusType type) {
        return this.type == type;
    }

    protected boolean alreadyHasStatus(PixelmonWrapper pw) {
        return pw.hasStatus(this.type);
    }
}

