/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.IceBody;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SnowCloak;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Hail;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Snow
extends Weather {
    public Snow() {
        this(5);
    }

    public Snow(int turnsToGo) {
        super(StatusType.Snow, turnsToGo, EnumHeldItems.icyRock, "pixelmon.effect.startsnow", "pixelmon.status.heavysnow", "pixelmon.status.snowstopped", false, false);
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Snow(turns);
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (user.hasType(Element.ICE)) {
            int n = BattleStatsType.DEFENSE.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        List<Attack> moveset;
        int benefits = 0;
        Ability ability = target.getBattleAbility();
        if (ability instanceof IceBody || ability instanceof SnowCloak) {
            ++benefits;
        }
        if (user.hasType(Element.ICE)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset = user.getBattleAI().getMoveset(target), AttackRegistry.BLIZZARD, AttackRegistry.WEATHER_BALL)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.SOLAR_BEAM, AttackRegistry.SOLAR_BLADE)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.MOONLIGHT, AttackRegistry.MORNING_SUN, AttackRegistry.SYNTHESIS)) {
            --benefits;
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new Hail(this.turnsToGo);
    }
}

