/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Infiltrator;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.List;

public abstract class Screen
extends StatusBase {
    BattleStatsType stat;
    transient int effectTurns;
    String langStart;
    String langFail;
    String langEnd;

    public Screen(StatusType type, BattleStatsType stat, int effectTurns, String langStart, String langFail, String langEnd) {
        super(type);
        this.stat = stat;
        this.effectTurns = effectTurns;
        this.langStart = langStart;
        this.langFail = langFail;
        this.langEnd = langEnd;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0 || user.bc.simulateMode) {
            this.apply(user, true);
        }
    }

    public boolean apply(PixelmonWrapper user, boolean failureMessages) {
        if (user.hasStatus(this.type)) {
            if (failureMessages) {
                user.bc.sendToAll(this.langFail, user.getNickname());
            }
            if (user.attack != null && user.attack.moveResult != null) {
                user.attack.moveResult.result = AttackResult.failed;
            }
            return false;
        }
        int turns = user.getUsableHeldItem().getHeldItemType() == EnumHeldItems.lightClay ? 8 : 5;
        user.addTeamStatus(this.getNewInstance(turns), user);
        user.bc.sendToAll(this.langStart, user.getNickname());
        return true;
    }

    protected abstract Screen getNewInstance(int var1);

    @Override
    public int modifyDamageIncludeFixed(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a, DamageTypeEnum damageType) {
        if (a.didCrit) {
            return damage;
        }
        if (damageType != DamageTypeEnum.ATTACK) {
            return damage;
        }
        if (a.isAttack(AttackRegistry.BRICK_BREAK, AttackRegistry.PSYCHIC_FANGS)) {
            return damage;
        }
        if (user.getAbility().isAbility((Class<? extends Ability>)Infiltrator.class)) {
            return damage;
        }
        if (this.shouldReduce(a)) {
            return (int)Math.ceil((float)damage * this.getDamageMultiplier(user, target));
        }
        return damage;
    }

    public float getDamageMultiplier(PixelmonWrapper user, PixelmonWrapper target) {
        return 0.5f;
    }

    public boolean shouldReduce(Attack a) {
        return a.getAttackCategory() == AttackCategory.PHYSICAL && this.stat == BattleStatsType.DEFENSE || a.getAttackCategory() == AttackCategory.SPECIAL && this.stat == BattleStatsType.SPECIAL_DEFENSE;
    }

    @Override
    public boolean ignoreStatus(PixelmonWrapper user, PixelmonWrapper target) {
        return user.getBattleAbility() instanceof Infiltrator;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.effectTurns <= 0) {
            pw.bc.sendToAll(this.langEnd, pw.getNickname());
            pw.removeTeamStatus(this);
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public StatusBase copy() {
        return this.getNewInstance(this.effectTurns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
        if (opponents.isEmpty()) {
            return;
        }
        for (PixelmonWrapper opponent : opponents) {
            if (!this.ignoreStatus(opponent, pw)) continue;
            return;
        }
        BattleAIBase ai = pw.getBattleAI();
        try {
            pw.bc.simulateMode = false;
            pw.addTeamStatus(this.getNewInstance(5), pw);
            pw.bc.simulateMode = true;
            pw.bc.modifyStats();
            List<List<MoveChoice>> bestOpponentChoicesAfter = ai.getBestAttackChoices(opponents);
            ai.weightFromOpponentOptions(pw, userChoice, MoveChoice.splitChoices(opponents, bestOpponentChoices), bestOpponentChoicesAfter);
        }
        finally {
            pw.bc.simulateMode = false;
            pw.removeTeamStatus(this);
            pw.bc.simulateMode = true;
            pw.bc.modifyStats();
            pw.bc.modifyStatsCancellable(pw);
        }
        if (userChoice.weight == 0.0f) {
            userChoice.raiseWeight(10.0f);
        }
    }
}

