/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class SaltCure
extends StatusBase {
    public SaltCure() {
        super(StatusType.SaltCure);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (!this.checkChance(user.bc)) {
            return;
        }
        if (target.addStatus(new SaltCure(), user)) {
            user.bc.sendToAll("pixelmon.effect.saltcured", target.getNickname());
        } else {
            user.bc.sendToAll("pixelmon.effect.saltcuredalready", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (pw.getBattleAbility() instanceof MagicGuard) {
            return;
        }
        float percentMaxHealthDamage = pw.hasType(Element.WATER, Element.STEEL) ? (float)pw.getPercentMaxHealth(25.0f) : (float)pw.getPercentMaxHealth(12.5f);
        pw.bc.sendToAll("pixelmon.status.saltcure", pw.getNickname());
        pw.doBattleDamage(pw, percentMaxHealthDamage, DamageTypeEnum.STATUS);
    }
}

