/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Guts;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MarvelScale;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.QuickFeet;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Synchronize;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class Paralysis
extends StatusPersist {
    public Paralysis() {
        super(StatusType.Paralysis);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance(user.bc)) {
            Paralysis.paralyze(user, target, user.attack, true);
        }
    }

    public static boolean paralyze(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        return new Paralysis().addStatus(user, target, attack, showMessage, "pixelmon.effect.alreadyparalyzed", "pixelmon.effect.isparalyzed");
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (RandomHelper.getRandomChance(25)) {
            user.bc.sendToAll("pixelmon.status.isparalyzed", user.getNickname());
            return false;
        }
        return true;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (!(user.getBattleAbility() instanceof QuickFeet)) {
            int n = BattleStatsType.SPEED.getStatIndex();
            stats[n] = (int)((double)stats[n] * 0.5);
        }
        return stats;
    }

    @Override
    public StatusPersist restoreFromNBT(CompoundTag nbt) {
        return new Paralysis();
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(Element.ELECTRIC);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.paralysiscure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.paralysiscureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        float weight = this.getWeightWithChance(25.0f);
        if (userChoice.isMiddleTier()) {
            for (PixelmonWrapper target : userChoice.targets) {
                Ability ability = target.getBattleAbility();
                if (ability instanceof Guts || ability instanceof MarvelScale || ability instanceof QuickFeet || ability instanceof Synchronize) {
                    return;
                }
                if (!MoveChoice.hasPriority(bestOpponentChoices) && MoveChoice.canOutspeed(bestOpponentChoices, pw, bestUserChoices)) {
                    userChoice.raiseWeight(weight * 3.0f);
                }
                userChoice.raiseWeight(weight);
            }
        }
    }
}

