/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.OfRuin;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.HashSet;

public class OfRuinStatus
extends GlobalStatusBase {
    private HashSet<BattleStatsType> activeReductions = Sets.newHashSet();

    public OfRuinStatus() {
        super(StatusType.OfRuinTracker);
    }

    public void checkForActiveOfRuinAbilities(PixelmonWrapper user) {
        this.activeReductions.clear();
        for (BattleParticipant part : user.bc.participants) {
            for (PixelmonWrapper pw : part.controlledPokemon) {
                if (pw.isFainted() || !(pw.getBattleAbility() instanceof OfRuin)) continue;
                this.activeReductions.add(((OfRuin)pw.getBattleAbility()).getStat());
            }
        }
        if (this.activeReductions.isEmpty()) {
            user.bc.globalStatusController.removeGlobalStatus(this);
        }
    }

    @Override
    public int[] modifyStatsCancellable(PixelmonWrapper pw, int[] stats) {
        for (BattleStatsType reducedStat : this.activeReductions) {
            OfRuin ofRuin;
            Ability ability = pw.getBattleAbility();
            if (ability instanceof OfRuin && (ofRuin = (OfRuin)ability).getStat() == reducedStat) continue;
            if (pw.bc.globalStatusController.hasStatus(StatusType.WonderRoom)) {
                if (reducedStat == BattleStatsType.DEFENSE) {
                    reducedStat = BattleStatsType.SPECIAL_DEFENSE;
                }
                if (reducedStat == BattleStatsType.SPECIAL_DEFENSE) {
                    reducedStat = BattleStatsType.DEFENSE;
                }
            }
            int n = reducedStat.getStatIndex();
            stats[n] = (int)((double)stats[n] * 0.75);
        }
        return stats;
    }
}

