/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;

public class Infatuated
extends StatusBase {
    transient PixelmonWrapper originalTarget;

    public Infatuated() {
        super(StatusType.Infatuated);
    }

    public Infatuated(PixelmonWrapper originalTarget) {
        this();
        this.originalTarget = originalTarget;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        Infatuated.infatuate(user, target, true);
    }

    public static boolean infatuate(PixelmonWrapper user, PixelmonWrapper target, boolean showMessage) {
        if (!user.getGender().isCompatible(target.getGender())) {
            if (showMessage) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.setAttackFailed();
            }
            return false;
        }
        if (target.hasStatus(StatusType.Infatuated)) {
            if (showMessage) {
                user.bc.sendToAll("pixelmon.effect.already", target.getNickname());
                user.setAttackFailed();
            }
            return false;
        }
        MutableComponent message = null;
        if (showMessage) {
            message = ChatHandler.getMessage("pixelmon.effect.falleninlove", target.getNickname());
        }
        return target.addStatus(new Infatuated(user), user, message);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (!user.bc.isInBattle(this.originalTarget)) {
            user.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.inlove", user.getNickname(), this.originalTarget.getNickname());
        if (RandomHelper.getRandomChance(50)) {
            user.bc.sendToAll("pixelmon.status.immobilizedbylove", user.getNickname());
            return false;
        }
        return true;
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.infatuatedcure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.infatuatedcureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (!userChoice.hitsAlly()) {
            userChoice.raiseWeight(40.0f);
        }
    }
}

