/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class HelpingHand
extends StatusBase {
    public HelpingHand() {
        super(StatusType.HelpingHand);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon() == 1 || target.hasStatus(StatusType.HelpingHand) || target.hasMoved()) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            target.setAttackFailed();
        } else {
            target.bc.sendToAll("pixelmon.status.helpinghand", user.getNickname(), target.getNickname());
            target.addStatus(new HelpingHand(), user);
        }
    }

    @Override
    public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return new int[]{(int)((double)power * 1.5), accuracy};
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        userChoice.raiseWeight(25.0f);
    }
}

