/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overcoat;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class FollowMe
extends StatusBase {
    private transient boolean isPowder;
    transient PixelmonWrapper centerOfAttention;

    public FollowMe() {
        this(false, null);
    }

    public FollowMe(boolean isPowder, PixelmonWrapper centerOfAttention) {
        super(StatusType.FollowMe);
        this.isPowder = isPowder;
        this.centerOfAttention = centerOfAttention;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.bc.sendToAll("pixelmon.status.followme", user.getNickname());
        user.addStatus(new FollowMe(Overcoat.isPowderMove(user.attack), user), user);
    }

    @Override
    public boolean redirectAttack(PixelmonWrapper user, PixelmonWrapper targetAlly, Attack attack) {
        return user.isOpponent(targetAlly) && attack.canReachTarget(user, targetAlly) && (!this.isPowder || !user.isImmuneToPowder()) && this.moveCanBeRedirected(attack) && !user.getBattleAbility().preventsRedirection(user, attack);
    }

    private boolean moveCanBeRedirected(Attack attack) {
        return !attack.isAttack(AttackRegistry.BIDE, AttackRegistry.BOUNCE, AttackRegistry.DIG, AttackRegistry.DIVE, AttackRegistry.FLY, AttackRegistry.FREEZE_SHOCK, AttackRegistry.ICE_BURN, AttackRegistry.PHANTOM_FORCE, AttackRegistry.RAZOR_WIND, AttackRegistry.SHADOW_FORCE, AttackRegistry.SKULL_BASH, AttackRegistry.SKY_ATTACK, AttackRegistry.SKY_DROP, AttackRegistry.SOLAR_BEAM, AttackRegistry.SNIPE_SHOT, AttackRegistry.DOOM_DESIRE, AttackRegistry.FUTURE_SIGHT);
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (pw.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon() == 1) {
            return;
        }
        for (PixelmonWrapper ally : pw.getTeamPokemonExcludeSelf()) {
            if (MoveChoice.hasSpreadMove(bestOpponentChoices) || MoveChoice.getTargetedChoices(ally, bestOpponentChoices).isEmpty()) continue;
            userChoice.raiseWeight(25.0f);
            break;
        }
    }
}

