/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Levitate;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;
import java.util.function.Supplier;

public abstract class EntryHazard
extends StatusBase {
    public static List<Supplier<ImmutableAttack>> ENTRY_HAZARDS = Lists.newArrayList((Object[])new Supplier[]{() -> AttackRegistry.SPIKES.orElse(null), () -> AttackRegistry.STEALTH_ROCK.orElse(null), () -> AttackRegistry.STICKY_WEB.orElse(null), () -> AttackRegistry.TOXIC_SPIKES.orElse(null)});
    private int maxLayers;
    protected transient int numLayers = 1;

    public EntryHazard(StatusType type, int maxLayers) {
        super(type);
        this.maxLayers = maxLayers;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0 || user.bc.simulateMode) {
            this.applyHazards(user, target);
        }
    }

    public void applyHazards(PixelmonWrapper user, PixelmonWrapper target) {
        int message = 0;
        EntryHazard hazard = (EntryHazard)target.getStatus(this.type);
        if (hazard == null) {
            target.addTeamStatus(this.getNewInstance(), user);
            message = 3;
        } else if (hazard.numLayers >= this.maxLayers) {
            message = 1;
        } else {
            if (!user.bc.simulateMode) {
                ++hazard.numLayers;
            }
            message = 2;
        }
        switch (message) {
            case 1: {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.attack.moveResult.result = AttackResult.failed;
                break;
            }
            case 2: {
                user.bc.sendToAll(this.getMultiLayerMessage(), target.getNickname());
                break;
            }
            case 3: {
                user.bc.sendToAll(this.getFirstLayerMessage(), target.getNickname());
                break;
            }
        }
    }

    public int getNumLayers() {
        return this.numLayers;
    }

    public abstract EntryHazard getNewInstance();

    protected abstract String getFirstLayerMessage();

    protected String getMultiLayerMessage() {
        return this.getFirstLayerMessage();
    }

    protected abstract String getAffectedMessage();

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public void applyEffectOnSwitch(PixelmonWrapper pw) {
        if (!this.isUnharmed(pw)) {
            pw.bc.sendToAll(this.getAffectedMessage(), pw.getNickname());
            this.doEffect(pw);
        }
    }

    protected void doEffect(PixelmonWrapper pw) {
        pw.doBattleDamage(pw, this.getDamage(pw), DamageTypeEnum.STATUS);
    }

    public int getDamage(PixelmonWrapper pw) {
        return 0;
    }

    @Override
    public StatusBase copy() {
        EntryHazard copy = this.getNewInstance();
        copy.numLayers = this.numLayers;
        return copy;
    }

    protected boolean isAirborne(PixelmonWrapper pw) {
        return !pw.isGrounded() && (pw.hasType(Element.FLYING) || pw.getBattleAbility() instanceof Levitate && !this.ignoreLevitate(pw) || pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.airBalloon || pw.hasStatus(StatusType.MagnetRise, StatusType.Telekinesis));
    }

    private boolean ignoreLevitate(PixelmonWrapper pw) {
        if (pw.bc.actionIndex >= pw.bc.turnList.size()) {
            return false;
        }
        PixelmonWrapper attacker = pw.bc.turnList.get(pw.bc.actionIndex);
        return AbilityRegistry.ignoreAbility(attacker, pw) && attacker.targets.get((int)0).battlePosition == pw.battlePosition && this.wasForcedSwitch(attacker);
    }

    private boolean wasForcedSwitch(PixelmonWrapper opponent) {
        return opponent.attack != null && opponent.attack.isAttack(AttackRegistry.CIRCLE_THROW, AttackRegistry.DRAGON_TAIL, AttackRegistry.ROAR, AttackRegistry.WHIRLWIND) && (opponent.attack.moveResult.result == AttackResult.hit || opponent.attack.moveResult.result == AttackResult.proceed);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper opponent : pw.getParticipant().getOpponentPokemon()) {
            EntryHazard hazard = (EntryHazard)opponent.getStatus(this.type);
            if (hazard == null || hazard.numLayers < this.maxLayers) continue;
            userChoice.raiseWeight(-100.0f);
            return;
        }
        int totalReserve = 0;
        for (BattleParticipant opponent : pw.getParticipant().getOpponents()) {
            totalReserve += opponent.countAblePokemon() - opponent.controlledPokemon.size();
        }
        userChoice.raiseWeight(totalReserve * this.getAIWeight());
    }

    public abstract int getAIWeight();

    protected boolean isUnharmed(PixelmonWrapper pw) {
        return pw.getHeldItem() == PixelmonItems.heavy_duty_boots;
    }
}

