/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SurgeSurfer;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Yawn;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;
import javax.annotation.Nonnull;

public class ElectricTerrain
extends Terrain {
    public ElectricTerrain(boolean extended) {
        super(StatusType.ElectricTerrain, "pixelmon.status.electricterrain", "pixelmon.status.electricterrainend", extended);
    }

    public ElectricTerrain(int turnsToGo) {
        super(StatusType.ElectricTerrain, turnsToGo, "pixelmon.status.electricterrain", "pixelmon.status.electricterrainend");
    }

    @Override
    public Terrain getNewInstance() {
        return new ElectricTerrain(false);
    }

    @Override
    @Nonnull
    public com.pixelmonmod.pixelmon.api.battles.Terrain getTerrainType() {
        return com.pixelmonmod.pixelmon.api.battles.Terrain.ELECTRIC;
    }

    @Override
    public Element getTypingForTerrain() {
        return Element.ELECTRIC;
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.affectsPokemon(user)) {
            if (a.isAttack(AttackRegistry.RISING_VOLTAGE)) {
                power = (int)((double)power * 2.0);
            } else if (a.getType() == Element.ELECTRIC) {
                power = (int)((double)power * 1.3);
            }
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean stopsStatusChange(StatusType t, PixelmonWrapper target, PixelmonWrapper user) {
        if (this.affectsPokemon(target) && (t == StatusType.Sleep || t == StatusType.Yawn)) {
            if (user != target && user.attack.getAttackCategory() == AttackCategory.STATUS) {
                target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        if (this.affectsPokemon(target)) {
            List<Attack> moveset = user.getBattleAI().getMoveset(target);
            if (Attack.hasOffensiveAttackType(moveset, Element.ELECTRIC)) {
                ++benefits;
            }
            if (target.hasStatus(StatusType.Yawn)) {
                ++benefits;
            }
            if (Attack.hasAttack(moveset, AttackRegistry.REST)) {
                --benefits;
            }
            for (Attack move : moveset) {
                for (EffectBase e : move.getMove().effects) {
                    if (!(e instanceof Sleep) && !(e instanceof Yawn)) continue;
                    --benefits;
                    break;
                }
                if (!move.isAttack(AttackRegistry.NATURE_POWER) && !move.isAttack(AttackRegistry.SECRET_POWER) && !move.isAttack(AttackRegistry.CAMOUFLAGE) && !move.isAttack(AttackRegistry.RISING_VOLTAGE) && !move.isAttack(AttackRegistry.TERRAIN_PULSE)) continue;
                ++benefits;
            }
            if (target.getBattleAbility().isAbility((Class<? extends Ability>)SurgeSurfer.class)) {
                ++benefits;
            }
            if (target.hasHeldItem() && (target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainExtender || target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainSeed)) {
                ++benefits;
            }
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new ElectricTerrain(this.turnsToGo);
    }
}

