/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;

public class Disable
extends StatusBase {
    transient ImmutableAttack disabledMove;
    transient int effectiveTurns = 4;

    public Disable() {
        super(StatusType.Disable);
    }

    public Disable(Attack attack) {
        super(StatusType.Disable);
        this.disabledMove = attack.getMove();
    }

    public ImmutableAttack getDisabledMove() {
        return this.disabledMove;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        Attack lastAttack = target.lastAttack;
        if (target.isDynamax() || lastAttack != null && lastAttack.isAttack(AttackRegistry.STRUGGLE)) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
            return;
        }
        if (target.hasStatus(StatusType.Disable)) {
            target.bc.sendToAll("pixelmon.effect.alreadydisabled", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
            return;
        }
        if (lastAttack != null) {
            MutableComponent message = ChatHandler.getMessage("pixelmon.status.disable", target.getNickname(), lastAttack.getMove().getTranslatedName());
            target.addStatus(new Disable(lastAttack), user, message);
        } else {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (a.equals(this.disabledMove)) {
            user.bc.sendToAll("pixelmon.status.disabled", user.getNickname(), a.getMove().getTranslatedName());
            return false;
        }
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.effectiveTurns <= 0) {
            pw.bc.sendToAll("pixelmon.status.nolongerdisabled", pw.getNickname(), this.disabledMove.getTranslatedName());
            pw.removeStatus(this);
        } else {
            pw.getMoveset().stream().filter(attack -> attack.getMove().equals(this.disabledMove)).forEach(attack -> attack.setDisabled(true, pw));
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            ImmutableAttack attackName;
            if (target.isDynamax != 0) continue;
            ImmutableAttack immutableAttack = attackName = target.lastAttack == null ? null : target.lastAttack.savedAttack;
            if (!MoveChoice.canOutspeed(bestOpponentChoices, pw, bestUserChoices) && !MoveChoice.hasSuccessfulAttackChoice(bestOpponentChoices, Optional.ofNullable(attackName))) continue;
            userChoice.raiseWeight(40.0f);
        }
    }
}

