/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;

public class Confusion
extends StatusBase {
    private transient int effectTurns = RandomHelper.getRandomNumberBetween(2, 5);

    public Confusion() {
        super(StatusType.Confusion);
    }

    public static boolean confuse(PixelmonWrapper user, PixelmonWrapper target) {
        return new Confusion().addStatus(user, target);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance(user.bc)) {
            this.addStatus(user, target);
        }
    }

    protected boolean addStatus(PixelmonWrapper user, PixelmonWrapper target) {
        MutableComponent message = ChatHandler.getMessage("pixelmon.effect.becameconfused", target.getNickname());
        if (target.addStatus(new Confusion(), user, message)) {
            return true;
        }
        if (user.hasStatus(StatusType.Confusion) && user.attack.getAttackCategory() == AttackCategory.STATUS) {
            user.bc.sendToAll("pixelmon.effect.alreadyconfused", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        }
        return false;
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (--this.effectTurns <= 0) {
            user.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.confused", user.getNickname());
        if (RandomHelper.getRandomChance(0.33f) || user.bc.isFrozen()) {
            user.bc.sendToAll("pixelmon.status.confusionhurtself", user.getNickname());
            user.doBattleDamage(user, this.calculateConfusionDamage(user), DamageTypeEnum.CONFUSION);
            ++user.amountOfTimesHit;
            return false;
        }
        return true;
    }

    private int calculateConfusionDamage(PixelmonWrapper user) {
        Attack attack = new Attack(new ImmutableAttack(Element.MYSTERY, 40, AttackCategory.PHYSICAL));
        int damage = attack.doDamageCalc(user, user, 1.0);
        damage = user.getBattleAbility().modifyConfusionDamage(damage, user);
        return user.getUsableHeldItem().modifyConfusionDamage(damage, user);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.confusionsnap";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.confusioncureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        boolean hitsAlly = userChoice.hitsAlly();
        boolean offensive = userChoice.isOffensiveMove();
        if (!hitsAlly) {
            for (PixelmonWrapper target : userChoice.targets) {
                if (offensive && hitsAlly || !target.addStatus(new Confusion(), pw)) continue;
                userChoice.raiseWeight(this.getWeightWithChance(40.0f));
            }
        }
    }
}

