/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.raids;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.abilities.Abilities;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.raids.WeightedItemStacks;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.TechnicalMoveItem;
import com.pixelmonmod.pixelmon.tools.LazySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class RaidSettings {
    public int participants = 4;
    public int lives = 4;
    public int turns = 10;
    public boolean autoGenerate = true;
    public int stars = 1;
    public int attacksPerTurn = 1;
    public int shields = 0;
    public int shieldStrength = 2;
    public int perfectIVs = 1;
    public int functionalDynamaxLevel = 0;
    public int trueDynamaxLevel = 0;
    public boolean hiddenAbility = false;
    public boolean shiny = false;
    public boolean gigantamax = false;
    public double shockwaveChance = 0.1;
    public double cheerSuccessChance = 0.2;
    public int level = 50;
    public int trueLevel = 50;
    public boolean canCatch = true;
    public BossTier bossTier = BossTierRegistry.NOT_BOSS;
    public ArrayList<Attack> moveset = new ArrayList();
    public int rewardCount = 1;
    public final WeightedItemStacks potentialRewards = WeightedItemStacks.create();
    public int[] ivOverrides = new int[]{-1, -1, -1, -1, -1, -1};
    public int[] evOverrides = new int[]{-1, -1, -1, -1, -1, -1};
    public int[] statOverrides = new int[]{-1, -1, -1, -1, -1, -1};

    private RaidSettings() {
    }

    protected void init(Pokemon pokemon) {
        if (this.autoGenerate) {
            switch (this.stars) {
                case 1: {
                    this.shields = 0;
                    this.attacksPerTurn = 1;
                    this.functionalDynamaxLevel = 0;
                    this.trueDynamaxLevel = 2;
                    this.trueLevel = RandomHelper.getRandomNumberBetween(20, 30);
                    this.perfectIVs = 1;
                    this.shockwaveChance = 0.15;
                    break;
                }
                case 2: {
                    this.shields = 0;
                    this.attacksPerTurn = RandomHelper.getRandomNumberBetween(1, 2);
                    this.functionalDynamaxLevel = 2;
                    this.trueDynamaxLevel = 4;
                    this.trueLevel = RandomHelper.getRandomNumberBetween(30, 40);
                    this.perfectIVs = 2;
                    this.shockwaveChance = 0.2;
                    break;
                }
                case 3: {
                    this.shields = 1;
                    this.attacksPerTurn = RandomHelper.getRandomNumberBetween(1, 3);
                    this.functionalDynamaxLevel = 8;
                    this.trueDynamaxLevel = 6;
                    this.trueLevel = RandomHelper.getRandomNumberBetween(40, 50);
                    this.perfectIVs = 3;
                    this.shockwaveChance = 0.25;
                    break;
                }
                case 4: {
                    this.shields = 1;
                    this.attacksPerTurn = RandomHelper.getRandomNumberBetween(2, 4);
                    this.functionalDynamaxLevel = 20;
                    this.trueDynamaxLevel = 8;
                    this.trueLevel = RandomHelper.getRandomNumberBetween(50, 60);
                    this.perfectIVs = 4;
                    this.shockwaveChance = 0.3;
                    break;
                }
                case 5: {
                    this.shields = 2;
                    this.attacksPerTurn = RandomHelper.getRandomNumberBetween(3, 4);
                    this.functionalDynamaxLevel = 30;
                    this.trueDynamaxLevel = 10;
                    this.trueLevel = RandomHelper.getRandomNumberBetween(60, 70);
                    this.perfectIVs = 4;
                    this.shockwaveChance = 0.35;
                }
            }
            PermanentStats stats = pokemon.getStats();
            int defense = stats.getDefense() + stats.getSpecialDefense();
            this.shieldStrength = Mth.m_14045_((int)(defense / 35), (int)2, (int)8);
            this.shiny = RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getRaids().getRaidShinyRate(this.stars));
            this.gigantamax = RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getRaids().getRaidGigantamaxFactorRate(this.stars));
            this.hiddenAbility = RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getRaids().getRaidHARate(this.stars));
            if (DropItemRegistry.raidDrops != null) {
                HashMap<Element, WeightedItemStacks> drops = DropItemRegistry.raidDrops.get(this.stars);
                if (drops != null) {
                    WeightedItemStacks wis1 = drops.get(null);
                    if (wis1 != null) {
                        this.potentialRewards.addAll(wis1);
                    }
                    for (Element type : pokemon.getForm().getTypes()) {
                        WeightedItemStacks wis2;
                        if (type == null || (wis2 = drops.get(type)) == null) continue;
                        this.potentialRewards.addAll(wis2);
                    }
                } else {
                    Pixelmon.LOGGER.error("Error in raid drops! No drops found for star pokemonLevel " + this.stars + "!");
                }
            } else {
                Pixelmon.LOGGER.error("Error in raid drops! No drops found at all, file missing perhaps?");
            }
            this.rewardCount = PixelmonConfigProxy.getRaids().getRaidDropCount(this.stars);
            this.moveset.clear();
            this.fillMoveset(pokemon);
        }
        this.populatePokemon(pokemon);
    }

    @Deprecated
    protected void init(PixelmonEntity entity) {
        Pokemon pokemon = entity.getPokemon();
        this.init(pokemon);
        entity.update(EnumUpdateType.ALL);
    }

    public Pokemon getCatchablePokemon(Pokemon boss) {
        Pokemon pokemon = PokemonFactory.create(boss.getSpecies());
        pokemon.setForm(boss.getForm());
        pokemon.setGender(boss.getGender());
        pokemon.setLevel(this.trueLevel);
        pokemon.rerollMoveset();
        pokemon.setAbility(boss.getAbility().getNewInstance());
        pokemon.getIVs().fillFromArray(boss.getIVs().getArray());
        pokemon.setShiny(this.shiny);
        pokemon.setGigantamaxFactor(this.gigantamax);
        pokemon.setDynamaxLevel(this.trueDynamaxLevel);
        return pokemon;
    }

    public ArrayList<ItemStack> getDrops(List<Element> types) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.rewardCount; ++i) {
            ItemStack stack = this.potentialRewards.get();
            if (stack.m_41619_()) continue;
            boolean isTM = false;
            if (stack.m_41720_() instanceof TechnicalMoveItem) {
                ITechnicalMove move;
                List<ITechnicalMove> moves;
                ITechnicalMove tm = TechnicalMoveItem.getInstanceOf(stack);
                if (tm == null || (moves = ITechnicalMove.getForType(tm, RandomHelper.getRandomElementFromCollection(types))) == null || (move = RandomHelper.getRandomElementFromCollection(moves)) == null) continue;
                if (!stack.m_41782_()) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128376_("tm", (short)move.getId());
                isTM = true;
            }
            boolean grown = false;
            if (!isTM) {
                for (ItemStack otherStack : stacks) {
                    if (otherStack.m_41720_() != stack.m_41720_()) continue;
                    otherStack.m_41769_(stack.m_41613_());
                    grown = true;
                    break;
                }
            }
            if (grown) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    private void populatePokemon(Pokemon pokemon) {
        int i;
        Stats form = pokemon.getForm();
        Abilities abilities = form.getAbilities();
        pokemon.setAbility(this.hiddenAbility && abilities.hasHiddenAbilities() ? abilities.getRandomHiddenAbility() : abilities.getRandomAbility());
        pokemon.setShiny(this.shiny);
        pokemon.setGigantamaxFactor(this.gigantamax);
        pokemon.setLevel(this.level);
        pokemon.setDynamaxLevel(this.functionalDynamaxLevel);
        pokemon.setHA(this.hiddenAbility);
        int[] ivs = pokemon.getIVs().getArray();
        int[] evs = pokemon.getEVs().getArray();
        HashSet<BattleStatsType> stats = new HashSet<BattleStatsType>(Arrays.asList(BattleStatsType.HP, BattleStatsType.ATTACK, BattleStatsType.DEFENSE, BattleStatsType.SPECIAL_ATTACK, BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.SPEED));
        for (i = 0; i < this.perfectIVs; ++i) {
            BattleStatsType stat = RandomHelper.removeRandomElementFromCollection(stats);
            if (stat == null) continue;
            ivs[stat.ordinal() - 1] = 31;
        }
        for (i = 0; i < 6; ++i) {
            if (this.ivOverrides[i] > -1) {
                ivs[i] = this.ivOverrides[i];
            }
            if (this.evOverrides[i] <= -1) continue;
            evs[i] = this.evOverrides[i];
        }
        this.fillMoveset(pokemon);
    }

    public void rerollMoveset(Pokemon pokemon) {
        this.moveset.clear();
        this.fillMoveset(pokemon);
    }

    private void fillMoveset(Pokemon pokemon) {
        if (this.moveset.isEmpty()) {
            Optional<PixelmonWrapper> pw = pokemon.getPixelmonWrapper();
            Moveset moveset = pw.isPresent() && pw.get().entity != null && pw.get().entity.transformed != null ? pw.get().entity.transformed.getForm().getMoves().loadMoveset(this.level).withPokemon(pokemon) : pokemon.getForm().getMoves().loadMoveset(this.level).withPokemon(pokemon);
            for (Attack attack : moveset.attacks) {
                if (attack == null) continue;
                if (this.stars >= 3) {
                    this.moveset.add(attack);
                }
                if (this.gigantamax) {
                    this.moveset.add(MaxMoveConverter.getGMaxMoveFromAttack(attack, null, pokemon.getSpecies(), pokemon.getForm().getName().contains("gmax") ? pokemon.getPixelmonWrapper().get().getPrevForm() : pokemon.getForm()));
                    continue;
                }
                this.moveset.add(MaxMoveConverter.getMaxMoveFromAttack(attack, null));
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        LazySupplier supplier = () -> () -> 1;
        supplier.get();
    }

    public static class Builder {
        private final RaidSettings settings = new RaidSettings();

        private Builder() {
        }

        public Builder setParticipantCount(int participants) {
            this.settings.participants = participants;
            return this;
        }

        public Builder setLives(int lives) {
            this.settings.lives = lives;
            return this;
        }

        public Builder setTurns(int turns) {
            this.settings.turns = turns;
            return this;
        }

        public Builder setAutoGenerate(boolean autoGenerate) {
            this.settings.autoGenerate = autoGenerate;
            return this;
        }

        public Builder setStars(int stars) {
            this.settings.stars = stars;
            return this;
        }

        public Builder setPerfectIVs(int perfectIVs) {
            this.settings.perfectIVs = perfectIVs;
            return this;
        }

        public Builder setDynamaxLevel(int functionalLevel, int trueLevel) {
            this.settings.functionalDynamaxLevel = functionalLevel;
            this.settings.trueDynamaxLevel = trueLevel;
            return this;
        }

        public Builder setHiddenAbility(boolean hiddenAbility) {
            this.settings.hiddenAbility = hiddenAbility;
            return this;
        }

        public Builder setShiny(boolean shiny) {
            this.settings.shiny = shiny;
            return this;
        }

        public Builder setGigantamax(boolean gigantamax) {
            this.settings.gigantamax = gigantamax;
            return this;
        }

        public Builder setLevel(int level) {
            this.settings.level = level;
            return this;
        }

        public Builder setTrueLevel(int trueLevel) {
            this.settings.trueLevel = trueLevel;
            return this;
        }

        public Builder setBossTier(BossTier bossTier) {
            this.settings.bossTier = bossTier;
            return this;
        }

        public Builder setRewardCount(int rewardCount) {
            this.settings.rewardCount = rewardCount;
            return this;
        }

        public Builder addReward(int weight, ItemStack stack) {
            this.settings.potentialRewards.add(weight, stack);
            return this;
        }

        public Builder setIVOverrides(int[] ivs) {
            this.settings.ivOverrides = ivs;
            return this;
        }

        public Builder setIVOverride(BattleStatsType stat, int iv) {
            this.settings.ivOverrides[stat.ordinal() - 1] = iv;
            return this;
        }

        public Builder setEVOverrides(int[] evs) {
            this.settings.evOverrides = evs;
            return this;
        }

        public Builder setEVOverride(BattleStatsType stat, int ev) {
            this.settings.evOverrides[stat.ordinal() - 1] = ev;
            return this;
        }

        public Builder setStatOverrides(int[] stats) {
            this.settings.statOverrides = stats;
            return this;
        }

        public Builder setStatOverride(BattleStatsType stat, int s) {
            this.settings.statOverrides[stat.ordinal() - 1] = s;
            return this;
        }

        public Builder setMoveset(ArrayList<Attack> moveset) {
            this.settings.moveset = moveset;
            return this;
        }

        public Builder addAttack(Attack attack) {
            this.settings.moveset.add(attack);
            return this;
        }

        public Builder setShields(int shields, int strength) {
            this.settings.shields = shields;
            this.settings.shieldStrength = strength;
            return this;
        }

        public Builder setCanCatch(boolean canCatch) {
            this.settings.canCatch = canCatch;
            return this;
        }

        public Builder setShockwaveChance(double shockwaveChance) {
            this.settings.shockwaveChance = shockwaveChance;
            return this;
        }

        public Builder setCheerSuccessChance(double cheerSuccessChance) {
            this.settings.cheerSuccessChance = cheerSuccessChance;
            return this;
        }

        public RaidSettings build() {
            return this.settings;
        }
    }
}

