/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.raids;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.raids.RandomizeRaidAllyEvent;
import com.pixelmonmod.pixelmon.api.events.raids.RandomizeRaidEvent;
import com.pixelmonmod.pixelmon.api.events.raids.RegisterRaidAllyEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.raids.RaidPokemon;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import com.pixelmonmod.pixelmon.init.registry.RaidRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.Event;

public class RaidRandomizer {
    private static final List<RaidPokemon> POSSIBLE_ALLIES = new ArrayList<RaidPokemon>();

    private RaidRandomizer() {
        throw new IllegalStateException("Cannot instantiate this class");
    }

    public static Optional<RaidData> getRandomRaid(DenEntity den, boolean force) {
        RandomizeRaidEvent.RollChance rollEvent;
        if (!(force || !Pixelmon.EVENT_BUS.post((Event)(rollEvent = new RandomizeRaidEvent.RollChance(den, PixelmonConfigProxy.getRaids().getDenRespawnChance()))) && RandomHelper.getRandomChance(rollEvent.getChance()))) {
            return Optional.empty();
        }
        Holder biome = den.m_20193_().m_204166_(den.m_20183_());
        RaidRegistry.RaidBiomeGrouping raids = RaidRegistry.getBiomeToRaids().get(((ResourceKey)biome.m_203543_().get()).m_135782_().toString());
        if (raids == null) {
            return Optional.empty();
        }
        int stars = RandomHelper.getRandomIndexFromWeights(RaidRegistry.getBiomeStarWeights(((ResourceKey)biome.m_203543_().get()).toString())) + 1;
        RandomizeRaidEvent.ChooseStarLevel starEvent = new RandomizeRaidEvent.ChooseStarLevel(den, stars);
        if (Pixelmon.EVENT_BUS.post((Event)starEvent) || raids.getRaids().getGroup(starEvent.getStars()) == null) {
            return Optional.empty();
        }
        RaidRegistry.Raid data = RandomHelper.getRandomElementFromCollection(raids.getRaids().getGroup(starEvent.getStars()));
        RaidData raid = data == null ? null : new RaidData(den.m_19879_(), starEvent.getStars(), data.getSpecies(), data.getForm());
        RandomizeRaidEvent.ChooseSpecies speciesEvent = new RandomizeRaidEvent.ChooseSpecies(den, raid);
        if (Pixelmon.EVENT_BUS.post((Event)speciesEvent)) {
            return Optional.empty();
        }
        return Optional.ofNullable(speciesEvent.getRaid());
    }

    public static RaidPokemon getRandomAlly(RaidData raid) {
        if (POSSIBLE_ALLIES.isEmpty()) {
            RegisterRaidAllyEvent event = new RegisterRaidAllyEvent(POSSIBLE_ALLIES);
            Pixelmon.EVENT_BUS.post((Event)event);
            if (event.shouldUseDefaults()) {
                POSSIBLE_ALLIES.add(new RaidPokemon("Noah", PixelmonSpecies.QWILFISH, (Item)PixelmonItems.focus_sash, "Intimidate", AttackRegistry.getAttackBases("Brine", "Waterfall", "Poison Jab", "Pin Missile")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Dean", PixelmonSpecies.THROH, null, "Inner Focus", AttackRegistry.getAttackBases("Mega Punch", "Revenge", "Bind", "Brick Break")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Martin", PixelmonSpecies.SOLROCK, null, "Levitate", AttackRegistry.getAttackBases("Cosmic Power", "Rock Throw", "Psychic", "Rock Polish")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Kit", PixelmonSpecies.DHELMISE, null, "Steelworker", AttackRegistry.getAttackBases("Gyro Ball", "Slam", "Shadow Ball", "Giga Drain")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Portia", PixelmonSpecies.HEATMOR, null, "Gluttony", AttackRegistry.getAttackBases("Fire Lash", "Bind", "Thunder Punch", "Slash")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Sophie", PixelmonSpecies.MARACTUS, null, "Water Absorb", AttackRegistry.getAttackBases("Sucker Punch", "Giga Drain", "Solar Beam", "Pin Missile")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Catherine", PixelmonSpecies.TOGEPI, (Item)PixelmonItems.focus_sash, "Serene Grace", AttackRegistry.getAttackBases("Life Dew", "Ancient Power", "Draining Kiss", "Swift")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Janet", PixelmonSpecies.SNORLAX, null, "Immunity", AttackRegistry.getAttackBases("Giga Impact", "Body Slam", "Crunch", "Stomping Tantrum")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Sean", PixelmonSpecies.TORKOAL, null, "Drought", AttackRegistry.getAttackBases("Rapid Spin", "Flame Wheel", "Flamethrower", "Clear Smog")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Patricia", PixelmonSpecies.WISHIWASHI, null, "Schooling", AttackRegistry.getAttackBases("Liquidation", "Aqua Tail", "Whirlpool", "Brine")));
                POSSIBLE_ALLIES.add(new RaidPokemon("William", PixelmonSpecies.MUDBRAY, (Item)PixelmonItems.focus_sash, "OwnTempo", AttackRegistry.getAttackBases("Strength", "Rock Tomb", "High Horsepower", "Superpower")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Isabella", PixelmonSpecies.MAGIKARP, (Item)PixelmonItems.focus_sash, "Swift Swim", AttackRegistry.getAttackBases("Flail", "Tackle", "Hydro Pump")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Nicki", PixelmonSpecies.JOLTEON, null, "Volt Absorb", AttackRegistry.getAttackBases("Double Kick", "Quick Attack", "Electro Ball", "Swift")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Alfie", PixelmonSpecies.WOBBUFFET, null, "Shadow Tag", AttackRegistry.getAttackBases("Counter", "Mirror Coat", "Safeguard", "Amnesia")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Oscar", PixelmonSpecies.HAWLUCHA, null, "Limber", AttackRegistry.getAttackBases("Wing Attack", "Feather Dance", "Flying Press", "Thunder Punch")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Amelia", PixelmonSpecies.CLEFAIRY, (Item)PixelmonItems.focus_sash, "Magic Guard", AttackRegistry.getAttackBases("Life Dew", "Follow Me", "Dazzling Gleam", "Disarming Voice")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Poppy", PixelmonSpecies.PIKACHU, (Item)PixelmonItems.focus_sash, "Static", AttackRegistry.getAttackBases("Thunderbolt", "Quick Attack", "Iron Tail", "Electroweb")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Ivy", PixelmonSpecies.WEAVILE, null, "Pressure", AttackRegistry.getAttackBases("Metal Claw", "Slash", "Assurance", "Ice Shard")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Freya", PixelmonSpecies.EEVEE, (Item)PixelmonItems.focus_sash, "Adaptability", AttackRegistry.getAttackBases("Helping Hand", "Round", "Quick Attack", "Bite")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Arthur", PixelmonSpecies.SALAZZLE, null, "Corrosion", AttackRegistry.getAttackBases("Flamethrower", "Fire Lash", "Sludge Bomb")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Klara", PixelmonSpecies.SLOWBRO, null, "Quick Draw", AttackRegistry.getAttackBases("Scald", "Shell Side Arm", "Focus Blast", "Psychic")).setForm("galarian"));
                POSSIBLE_ALLIES.add(new RaidPokemon("Peony", PixelmonSpecies.AGGRON, null, "Sturdy", AttackRegistry.getAttackBases("Crunch", "Iron Head", "Stone Edge", "Body Press")));
                POSSIBLE_ALLIES.add(new RaidPokemon("Peonia", PixelmonSpecies.TYRANTRUM, null, "Strong Jaw", AttackRegistry.getAttackBases("Stone Edge", "Crunch", "Dragon Claw", "High Horsepower")));
            }
        }
        RaidPokemon ally = CollectionHelper.getRandomElement(POSSIBLE_ALLIES);
        RandomizeRaidAllyEvent allyEvent = new RandomizeRaidAllyEvent(raid, ally);
        Pixelmon.EVENT_BUS.post((Event)allyEvent);
        return allyEvent.getAlly();
    }

    public static void addAlly(RaidPokemon pokemon) {
        POSSIBLE_ALLIES.add(pokemon);
    }

    public static void clearAllyInfo() {
        POSSIBLE_ALLIES.clear();
    }
}

