/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.raids;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.api.battles.BattleItemScanner;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.enums.TriBoolean;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.SpawnPixelmonEntityForBattleEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BagItemEvent;
import com.pixelmonmod.pixelmon.api.events.raids.JoinRaidEvent;
import com.pixelmonmod.pixelmon.api.events.raids.RaidDropsEvent;
import com.pixelmonmod.pixelmon.api.events.raids.StartRaidEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureHealth;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureValues;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.raids.EnumRaidKickReason;
import com.pixelmonmod.pixelmon.battles.raids.RaidGovernor;
import com.pixelmonmod.pixelmon.battles.raids.RaidPokemon;
import com.pixelmonmod.pixelmon.battles.raids.RaidRandomizer;
import com.pixelmonmod.pixelmon.battles.raids.RaidSettings;
import com.pixelmonmod.pixelmon.battles.tasks.RaidDropsTask;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.CloseRaidPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.OpenRaidPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.UpdateRaidCatchPacket;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RaidData {
    public final UUID uuid = UUID.randomUUID();
    private final int stars;
    private final Supplier<Species> species;
    private final Supplier<Stats> form;
    private final int entityID;
    public final boolean canAllCatch;
    public final boolean canUseMaster;
    private boolean locked = false;
    private boolean starting = false;
    private UUID owner = null;
    private final ArrayList<RaidPlayer> players = new ArrayList();
    private ServerPlayer ownerPlayer = null;
    public int tick = 0;
    private static final int[][] npcOffsets = new int[][]{{2, 0}, {0, 2}, {-2, 0}, {0, -2}};
    private static final float[] npcRotations = new float[]{180.0f, 270.0f, 0.0f, 90.0f};

    public RaidData(int entityID, int stars, Species species) {
        this(entityID, stars, species, species.getDefaultForm());
    }

    public RaidData(int entityID, int stars, Species species, Stats form) {
        this.entityID = entityID;
        this.stars = stars;
        this.species = () -> species;
        this.form = () -> form;
        this.canAllCatch = PixelmonConfigProxy.getRaids().getRaidCanAllCatch(this.stars);
        this.canUseMaster = PixelmonConfigProxy.getRaids().getRaidCanUseMaster(this.stars);
    }

    public RaidData(int entityID, int stars, int species, String form) {
        this.entityID = entityID;
        this.stars = stars;
        this.species = () -> PixelmonSpecies.fromNationalDex(species);
        this.form = () -> form.isEmpty() ? this.species.get().getDefaultForm() : this.species.get().getForm(form);
        this.canAllCatch = PixelmonConfigProxy.getRaids().getRaidCanAllCatch(this.stars);
        this.canUseMaster = PixelmonConfigProxy.getRaids().getRaidCanUseMaster(this.stars);
    }

    public RaidData(CompoundTag tag) {
        CompoundTag nbt = tag.m_128469_("RaidData");
        this.tick = nbt.m_128451_("Tick");
        this.entityID = nbt.m_128451_("EntityID");
        this.stars = nbt.m_128448_("Stars");
        this.species = () -> PixelmonSpecies.fromNationalDex(nbt.m_128451_("Species"));
        this.form = nbt.m_128471_("HasForm") ? () -> this.species.get().getForm(nbt.m_128461_("Form")) : null;
        this.locked = nbt.m_128471_("Locked");
        this.starting = nbt.m_128471_("Starting");
        if (nbt.m_128403_("Owner")) {
            this.owner = nbt.m_128342_("Owner");
        }
        ListTag participants = nbt.m_128437_("Players", 10);
        for (Tag entry : participants) {
            this.players.add(new RaidPlayer((CompoundTag)entry));
        }
        this.canAllCatch = nbt.m_128471_("CanAllCatch");
        this.canUseMaster = nbt.m_128471_("CanUseMaster");
    }

    public RaidData(FriendlyByteBuf buf) {
        this.tick = buf.readInt();
        this.entityID = buf.readInt();
        this.stars = buf.readShort();
        int speciesNum = buf.readInt();
        this.species = () -> PixelmonSpecies.fromNationalDex(speciesNum);
        if (buf.readBoolean()) {
            String formNum = buf.m_130277_();
            this.form = () -> this.species.get().getForm(formNum);
        } else {
            this.form = () -> null;
        }
        this.locked = buf.readBoolean();
        this.starting = buf.readBoolean();
        if (buf.readBoolean()) {
            this.owner = buf.m_130259_();
        }
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.players.add(new RaidPlayer(buf));
        }
        this.canAllCatch = buf.readBoolean();
        this.canUseMaster = buf.readBoolean();
    }

    public int getDen() {
        return this.entityID;
    }

    public int getStars() {
        return this.stars;
    }

    public Species getSpecies() {
        return this.species.get();
    }

    public Stats getForm() {
        return this.form.get();
    }

    public ArrayList<RaidPlayer> getPlayers() {
        return this.players;
    }

    public boolean hasPlayers() {
        HashSet<ServerPlayer> playersToRemove = new HashSet<ServerPlayer>();
        for (RaidPlayer rp : this.players) {
            if (!rp.isPlayer() || !rp.Player.m_9232_()) continue;
            playersToRemove.add(rp.Player);
        }
        for (ServerPlayer toRemove : playersToRemove) {
            this.removePlayer(toRemove);
        }
        return !this.players.isEmpty();
    }

    public boolean isSolo() {
        return this.players.size() == 1 && this.locked || this.players.size() == 0;
    }

    public void processAction(int action, int slot, ItemStack usedStack, ServerPlayer ep) {
        if (this.starting && action != 10) {
            return;
        }
        RaidPlayer player = this.getPlayer(ep);
        if (player != null) {
            PlayerPartyStorage pps = StorageProxy.getPartyNow(ep);
            Pokemon[] team = pps.getAll();
            switch (action) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Pokemon pokemon = team[action];
                    if (pokemon == null || !pokemon.canBattle()) break;
                    player.updatePokemon(action, pokemon);
                    this.updateAll();
                    break;
                }
                case 6: {
                    if (this.players.size() != 1) break;
                    this.locked = true;
                    this.starting = true;
                    this.updateAll();
                    break;
                }
                case 7: {
                    if (this.players.size() != 1) break;
                    this.locked = false;
                    this.updateAll();
                    break;
                }
                case 8: {
                    this.removePlayer(ep);
                    break;
                }
                case 9: {
                    if (this.players.size() < 1) break;
                    this.locked = true;
                    this.starting = true;
                    this.updateAll();
                    break;
                }
                case 10: {
                    ItemStack foundStack;
                    if (player.catchAttempted || player.possibleCatch == null || usedStack == null) break;
                    player.catchAttempted = true;
                    BattleController battleController = BattleRegistry.getBattle((Player)player.Player);
                    BagItemEvent.SelectItem.Pre pre = new BagItemEvent.SelectItem.Pre(battleController, "EndOfRaid", player.Player, usedStack, foundStack = BattleItemScanner.findMatchingItem(usedStack, player.Player));
                    if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                        return;
                    }
                    usedStack = pre.getFoundItem();
                    if (usedStack == null) {
                        return;
                    }
                    if (!(usedStack.m_41720_() instanceof PokeBallItem)) break;
                    PokeBall ball = PokeBallPart.getPokeBall(usedStack).orElse(PokeBallRegistry.POKE_BALL.getValueUnsafe());
                    if (!this.canUseMaster && ball.getCatchBonus() >= 255.0) {
                        return;
                    }
                    int shakes = player.tryCatch(this, ball);
                    boolean sentToPC = false;
                    if (shakes >= 4) {
                        if (Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.SuccessfulRaidCapture(ep, player.possibleCatch, this))) {
                            shakes = RandomHelper.getRandomNumberBetween(1, 3);
                        } else {
                            player.possibleCatch.setOriginalTrainer((Player)ep);
                            player.possibleCatch.setBall(ball);
                            ball.getLogic().doAfterEffect(ball, null, player.possibleCatch.getOrCreatePixelmon());
                            TriBoolean result = pps.addSilently(player.possibleCatch);
                            if (result == TriBoolean.NULL) {
                                shakes = -1;
                            } else if (result == TriBoolean.FALSE) {
                                sentToPC = true;
                            }
                        }
                    }
                    Pixelmon.EVENT_BUS.post((Event)new BagItemEvent.SelectItem.Post(battleController, "EndOfRaid", player.Player, usedStack, foundStack));
                    if (shakes > 0 && !ep.m_7500_()) {
                        BattleItemScanner.consumeItem(usedStack, player.Player);
                    }
                    if (shakes > 0 && shakes < 4) {
                        Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.FailedRaidCapture(ep, player.possibleCatch, this));
                    }
                    NetworkHelper.sendPacket(new UpdateRaidCatchPacket(shakes, sentToPC), ep);
                }
            }
        } else {
            NetworkHelper.sendPacket(new CloseRaidPacket(), ep);
        }
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public void updateAll() {
        for (RaidPlayer player : this.players) {
            ServerPlayer ep = player.Player;
            if (ep == null) continue;
            NetworkHelper.sendPacket(new OpenRaidPacket(this), ep);
        }
    }

    public void kickAll(EnumRaidKickReason reason) {
        for (RaidPlayer player : this.players) {
            ServerPlayer ep = player.Player;
            if (ep == null) continue;
            ep.m_213846_((Component)Component.m_237115_((String)reason.getMessage()));
            NetworkHelper.sendPacket(new CloseRaidPacket(), ep);
        }
        this.players.clear();
    }

    public boolean isStarting() {
        return this.starting;
    }

    public void setStarting(boolean starting) {
        this.starting = starting;
    }

    public boolean addPlayer(int playerCap, ServerPlayer ep, Pokemon pokemon, int index) {
        for (RaidPlayer player : this.players) {
            if (!ep.m_20148_().equals(player.player)) continue;
            this.updateAll();
            return true;
        }
        if (this.locked || this.starting || this.players.size() >= playerCap) {
            return false;
        }
        if (!Pixelmon.EVENT_BUS.post((Event)new JoinRaidEvent(this, ep, pokemon))) {
            this.players.add(new RaidPlayer(index, ep, pokemon));
            if (this.players.size() == 1) {
                this.owner = ep.m_20148_();
                this.locked = true;
            }
            this.updateAll();
        }
        return true;
    }

    public boolean removePlayer(ServerPlayer ep) {
        boolean removed = false;
        boolean shouldReset = false;
        Iterator<RaidPlayer> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            RaidPlayer player = iterator.next();
            if (!ep.m_20148_().equals(player.player)) continue;
            iterator.remove();
            removed = true;
            if (!player.player.equals(this.owner)) continue;
            shouldReset = true;
        }
        if (shouldReset) {
            this.locked = false;
            this.kickAll(EnumRaidKickReason.LEADER_LEFT);
        } else {
            this.updateAll();
        }
        NetworkHelper.sendPacket(new CloseRaidPacket(), ep);
        return removed;
    }

    public boolean updatePlayer(ServerPlayer ep, Pokemon pokemon, int index) {
        for (RaidPlayer player : this.players) {
            if (!ep.m_20148_().equals(player.player)) continue;
            player.updatePokemon(index, pokemon);
            this.updateAll();
            return true;
        }
        return false;
    }

    public RaidPlayer getPlayer(UUID uuid) {
        for (RaidPlayer player : this.players) {
            if (!uuid.equals(player.player)) continue;
            return player;
        }
        return null;
    }

    public RaidPlayer getPlayer(ServerPlayer ep) {
        return this.getPlayer(ep.m_20148_());
    }

    public Optional<DenEntity> getDenEntity(Level world) {
        Entity entity = world.m_6815_(this.getDen());
        return Optional.ofNullable(entity instanceof DenEntity ? (DenEntity)entity : null);
    }

    public boolean isOwner(UUID uuid) {
        return uuid.equals(this.owner);
    }

    public void onUpdate(DenEntity den) {
        boolean shouldReset = false;
        Iterator<RaidPlayer> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            RaidPlayer player = iterator.next();
            if (player.Player == null || !player.Player.m_9232_()) continue;
            iterator.remove();
            if (this.owner != null && !this.owner.equals(player.player)) continue;
            shouldReset = true;
        }
        if (shouldReset) {
            this.kickAll(EnumRaidKickReason.LEADER_LEFT);
        } else if (this.isStarting()) {
            if (this.tick == 0) {
                this.populateWithNPCs();
            }
            ++this.tick;
            if (this.tick % 20 == 0) {
                this.updateAll();
            }
            if (this.tick >= 100) {
                this.startRaid(den);
            }
        }
    }

    public void populateWithNPCs() {
        int maxLevel = 1;
        for (RaidPlayer player : this.players) {
            maxLevel = Math.max(maxLevel, player.level);
        }
        int npcs = 4 - this.players.size();
        for (int i = 0; i < npcs; ++i) {
            this.players.add(new RaidPlayer(RaidRandomizer.getRandomAlly(this), maxLevel));
        }
        this.updateAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startRaid(DenEntity den) {
        HashSet<NPCTrainer> trainers;
        block22: {
            boolean canStart = true;
            BattleParticipant[] allies = new BattleParticipant[4];
            trainers = new HashSet<NPCTrainer>();
            int i = 0;
            try {
                for (RaidPlayer player : this.players) {
                    block24: {
                        block23: {
                            if (player.Player == null) break block23;
                            NetworkHelper.sendPacket(new CloseRaidPacket(), player.Player);
                            PlayerPartyStorage pps = StorageProxy.getPartyNow(player.Player);
                            Pokemon pokemon = pps.get(player.uuid);
                            if (pokemon != null) {
                                allies[i] = new PlayerParticipant(true, player.Player, pokemon);
                                if (!Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                                    PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon((Entity)player.Player);
                                    pixelmon.setPixelmonToFlyForBattle();
                                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                                }
                                break block24;
                            } else {
                                canStart = false;
                                break;
                            }
                        }
                        int index = i % 4;
                        NPCTrainer trainer = new NPCTrainer(den.f_19853_);
                        int[] offset = npcOffsets[index];
                        trainer.m_6021_(den.m_20185_() + (double)offset[0], den.m_20186_(), den.m_20189_() + (double)offset[1]);
                        BaseTrainer base = ServerNPCRegistry.trainers.getRandomBase();
                        trainer.init(base);
                        trainer.setAIMode(EnumTrainerAI.StandStill);
                        trainer.initAI();
                        trainer.clearGreetings();
                        trainer.setName(player.name);
                        trainer.canEngage = false;
                        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                        server.execute(() -> {
                            if (den.f_19853_ instanceof ServerLevel) {
                                ((ServerLevel)den.f_19853_).m_8847_((Entity)trainer);
                            }
                            trainer.getPersistentData().m_128379_("IsRaidTrainer", true);
                            trainer.f_19857_ = npcRotations[index];
                            trainer.m_19890_(trainer.m_20185_(), trainer.m_20186_(), trainer.m_20189_(), npcRotations[index], 0.0f);
                            trainer.m_6021_(trainer.m_20185_(), trainer.m_20186_(), trainer.m_20189_());
                        });
                        for (int j = 0; j < 6; ++j) {
                            trainer.getPokemonStorage().set(j, j == 0 ? player.pokemon : null);
                        }
                        trainers.add(trainer);
                        allies[i] = new TrainerParticipant(trainer, 1);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failed to start raid due to error, catching and continuing safely...");
                e.printStackTrace();
                canStart = false;
            }
            if (canStart) {
                PixelmonEntity raidPixelmon = null;
                try {
                    boolean canContinue = true;
                    for (BattleParticipant ally : allies) {
                        if (ally == null) {
                            canContinue = false;
                            break;
                        }
                        if (!(ally instanceof TrainerParticipant) && !(ally instanceof PlayerParticipant)) continue;
                        if (ally instanceof PlayerParticipant) {
                            PlayerParticipant pp = (PlayerParticipant)ally;
                            if (pp.player.m_9232_()) {
                                canContinue = false;
                                break;
                            }
                        }
                        if (ally.getEntity() != null && ally.allPokemon != null && ally.allPokemon.length > 0 && ally.allPokemon[0] != null) continue;
                        canContinue = false;
                        break;
                    }
                    if (canContinue) {
                        RaidPixelmonParticipant rpp;
                        Pokemon raidEnemy = PokemonFactory.create(this.getSpecies());
                        if (this.getForm() != null) {
                            raidEnemy.setForm(this.getForm());
                        }
                        if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(raidEnemy))) {
                            RaidPixelmonParticipant rpp2 = new RaidPixelmonParticipant(this, RaidSettings.builder().setStars(this.stars).build(), raidEnemy);
                            BattleRegistry.startBattle(allies, new BattleParticipant[]{rpp2}, BattleType.RAID);
                            den.setInUseRaidData();
                            den.clearData();
                            return;
                        }
                        raidPixelmon = raidEnemy.getOrSpawnPixelmon(den.f_19853_, den.m_20185_(), den.m_20186_() + 3.0, den.m_20189_());
                        if (raidPixelmon != null) {
                            raidPixelmon.setPixelmonToFlyForBattle();
                        }
                        if (!Pixelmon.EVENT_BUS.post((Event)new StartRaidEvent(den, this, allies, raidPixelmon, rpp = new RaidPixelmonParticipant(this, RaidSettings.builder().setStars(this.stars).build(), raidPixelmon)))) {
                            BattleRegistry.startBattle(allies, new BattleParticipant[]{rpp}, BattleType.RAID);
                            den.setInUseRaidData();
                            den.clearData();
                            return;
                        }
                        raidPixelmon.unloadEntity();
                        Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(raidEnemy, raidPixelmon));
                    }
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to start raid battle due to error, catching and continuing safely...");
                    e.printStackTrace();
                    if (raidPixelmon == null) break block22;
                    raidPixelmon.unloadEntity();
                }
            }
        }
        Iterator<RaidPlayer> iterator = trainers.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.locked = false;
                this.starting = false;
                this.tick = 0;
                this.kickAll(EnumRaidKickReason.INVALID_POKEMON);
                return;
            }
            NPCTrainer trainer = (NPCTrainer)((Object)iterator.next());
            trainer.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void write(CompoundTag tag) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Tick", this.tick);
        nbt.m_128405_("EntityID", this.entityID);
        nbt.m_128376_("Stars", (short)this.stars);
        nbt.m_128405_("Species", this.species.get().getDex());
        nbt.m_128379_("HasForm", this.form.get() != null);
        if (this.form.get() != null) {
            nbt.m_128359_("Form", this.form.get().getName());
        }
        nbt.m_128379_("Locked", this.locked);
        nbt.m_128379_("Starting", this.starting);
        if (this.owner != null) {
            nbt.m_128362_("Owner", this.owner);
        }
        ListTag players = new ListTag();
        for (RaidPlayer player : this.players) {
            players.add((Object)player.write());
        }
        nbt.m_128365_("Players", (Tag)players);
        nbt.m_128379_("CanAllCatch", this.canAllCatch);
        nbt.m_128379_("CanUseMaster", this.canUseMaster);
        tag.m_128365_("RaidData", (Tag)tag);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.tick);
        buf.writeInt(this.entityID);
        buf.writeShort(this.stars);
        buf.writeInt(this.species.get().getDex());
        buf.writeBoolean(this.form.get() != null);
        if (this.form.get() != null) {
            buf.m_130070_(this.form.get().getName());
        }
        buf.writeBoolean(this.locked);
        buf.writeBoolean(this.starting);
        buf.writeBoolean(this.owner != null);
        if (this.owner != null) {
            buf.m_130077_(this.owner);
        }
        buf.writeInt(this.players.size());
        for (RaidPlayer player : this.players) {
            player.write(buf);
        }
        buf.writeBoolean(this.canAllCatch);
        buf.writeBoolean(this.canUseMaster);
    }

    public static class RaidPlayer {
        public final UUID player;
        public String name;
        public UUID uuid;
        public Species species;
        public Gender gender;
        public Stats form;
        public String palette;
        public int index;
        public ServerPlayer Player;
        public int level;
        public Pokemon possibleCatch = null;
        public boolean canCatch = true;
        public boolean catchAttempted = false;
        public ArrayList<ItemStack> drops;
        public Pokemon pokemon;

        public RaidPlayer(int index, ServerPlayer player, Pokemon pokemon) {
            this.player = player.m_20148_();
            this.Player = player;
            this.updatePokemon(index, pokemon);
        }

        public RaidPlayer(RaidPokemon pokemon, int maxLevel) {
            this.player = null;
            this.Player = null;
            this.pokemon = pokemon.makePokemon(Math.max(1, (int)Math.floor((double)maxLevel * 0.7)));
            this.name = pokemon.getName();
            this.updatePokemon(0, this.pokemon);
        }

        public RaidPlayer(CompoundTag tag) {
            this.player = tag.m_128403_("player") ? tag.m_128342_("player") : null;
            this.uuid = tag.m_128342_("uuid");
            this.species = PixelmonSpecies.fromNationalDex(tag.m_128451_("species"));
            this.gender = Gender.values()[tag.m_128448_("gender")];
            this.form = this.species.getForm(tag.m_128461_("form"));
            this.palette = tag.m_128461_("palette");
            this.index = tag.m_128451_("index");
        }

        public RaidPlayer(FriendlyByteBuf buf) {
            this.player = buf.readBoolean() ? buf.m_130259_() : null;
            this.uuid = buf.m_130259_();
            this.species = PixelmonSpecies.fromNationalDex(buf.readInt());
            this.gender = Gender.values()[buf.readShort()];
            this.form = this.species.getForm(buf.m_130277_());
            this.palette = buf.m_130277_();
            this.index = buf.readInt();
        }

        public void updatePokemon(int index, Pokemon pokemon) {
            this.uuid = pokemon.getUUID();
            this.species = pokemon.getSpecies();
            this.gender = pokemon.getGender();
            this.form = pokemon.getForm();
            this.palette = pokemon.getPalette().getName();
            this.level = pokemon.getPokemonLevel();
            this.index = index;
        }

        public boolean isPlayer() {
            return this.player != null && this.Player != null;
        }

        public void winRaid(RaidPixelmonParticipant rpp, RaidData raid, RaidGovernor governor) {
            if (this.isPlayer()) {
                PixelmonWrapper pw = rpp.getWrapper();
                RaidDropsEvent dropsEvent = new RaidDropsEvent(raid, this, governor, governor.getSettings().getCatchablePokemon(pw.pokemon), governor.getSettings().getDrops(pw.pokemon.getForm().getTypes()), governor.settings.canCatch && (raid.isOwner(this.player) || raid.canAllCatch));
                Pixelmon.EVENT_BUS.post((Event)dropsEvent);
                this.possibleCatch = dropsEvent.getPossibleCatch();
                this.canCatch = dropsEvent.canCatch();
                this.drops = dropsEvent.getDrops();
                BagItemEvent.CollectItems.Pre pre = new BagItemEvent.CollectItems.Pre(rpp.bc, "EndOfRaid", this.Player, BagSection.POKEBALLS);
                if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                    pre.getItems().clear();
                }
                rpp.bc.getPlayer((Player)this.Player).sendMessage(new RaidDropsTask(this.canCatch, pre.getItems(), raid, governor.settings.shiny, this));
                Pixelmon.EVENT_BUS.post((Event)new BagItemEvent.CollectItems.Post(rpp.bc, "EndOfRaid", this.Player, pre.getSection(), pre.getItems()));
                for (ItemStack drop : this.drops) {
                    if (this.Player.m_36356_(drop)) continue;
                    this.Player.m_36176_(drop, true);
                }
            }
        }

        public int tryCatch(RaidData raid, PokeBall ball) {
            if (this.Player != null && this.possibleCatch != null && this.canCatch) {
                CaptureValues values = ball.getCaptureMethod().calculateCapture(new CaptureHealth(this, raid), ball, null, raid, this.Player, this.possibleCatch, PokeBallMode.EMPTY);
                return values.getShakes();
            }
            return RandomHelper.getRandomNumberBetween(1, 3);
        }

        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            this.write(nbt);
            return nbt;
        }

        public void write(CompoundTag tag) {
            if (this.player != null) {
                tag.m_128362_("player", this.player);
            }
            tag.m_128362_("uuid", this.uuid);
            tag.m_128405_("species", this.species.getDex());
            tag.m_128376_("gender", (short)this.gender.ordinal());
            tag.m_128359_("form", this.form.getName());
            tag.m_128359_("palette", this.palette);
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.player != null);
            if (this.player != null) {
                buf.m_130077_(this.player);
            }
            buf.m_130077_(this.uuid);
            buf.writeInt(this.species.getDex());
            buf.writeShort(this.gender.ordinal());
            buf.m_130070_(this.form.getName());
            buf.m_130070_(this.palette);
            buf.writeInt(this.index);
        }
    }
}

