/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class WildPixelmonParticipant
extends BattleParticipant {
    private boolean isBlockBattleParticipant = false;

    public WildPixelmonParticipant(boolean isGrassBattleParticipant, PixelmonEntity ... pixelmon) {
        super(pixelmon.length);
        this.init(pixelmon);
        this.isBlockBattleParticipant = isGrassBattleParticipant;
    }

    public WildPixelmonParticipant(PixelmonEntity ... pixelmon) {
        super(pixelmon.length);
        this.init(pixelmon);
    }

    public WildPixelmonParticipant(Pokemon ... pokemon) {
        super(pokemon.length);
        this.init(pokemon);
    }

    public WildPixelmonParticipant(int size, Pokemon ... pokemon) {
        super(size);
        this.init(pokemon);
    }

    private void init(PixelmonEntity[] pixelmon) {
        this.allPokemon = new PixelmonWrapper[pixelmon.length];
        for (int i = 0; i < pixelmon.length; ++i) {
            PixelmonWrapper pw;
            this.allPokemon[i] = pw = new PixelmonWrapper((BattleParticipant)this, pixelmon[i], i);
            this.controlledPokemon.add(pw);
        }
    }

    private void init(Pokemon[] pixelmon) {
        int i;
        this.allPokemon = new PixelmonWrapper[pixelmon.length];
        for (i = 0; i < pixelmon.length; ++i) {
            PixelmonWrapper pw;
            this.allPokemon[i] = pw = new PixelmonWrapper((BattleParticipant)this, pixelmon[i], i);
        }
        for (i = 0; i < this.controlledPokemon.size(); ++i) {
            this.controlledPokemon.add(this.allPokemon[i]);
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.WildPokemon;
    }

    @Override
    public boolean hasMorePokemon() {
        return this.countAblePokemon() == 1;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        int remaining = 0;
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (pixelmonWrapper == null || !pixelmonWrapper.isAlive() || this.controlledPokemon.contains(pixelmonWrapper) || pixelmonWrapper.isSwitching || this.switchingOut.contains(pixelmonWrapper)) continue;
            ++remaining;
        }
        return remaining > 0;
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void startBattle() {
        super.startBattle();
        boolean isBoss = false;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.entity != null) {
                pw.entity.f_21345_.m_25355_(Goal.Flag.MOVE);
                pw.entity.f_21345_.m_25355_(Goal.Flag.JUMP);
                pw.entity.f_21345_.m_25355_(Goal.Flag.TARGET);
                pw.entity.m_21570_(0.0f);
                pw.entity.m_21564_(0.0f);
                pw.entity.m_21567_(0.0f);
                pw.entity.f_19812_ = true;
                pw.entity.m_21573_().m_26573_();
                BossTier bossTier = pw.entity.getBossTier();
                if (bossTier.isBoss()) {
                    isBoss = true;
                    int lvl = 1;
                    for (BattleParticipant p : this.bc.participants) {
                        if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                        int highestLevel = ((PlayerParticipant)p).getHighestLevel();
                        lvl = Math.max(lvl, highestLevel);
                    }
                    lvl = (int)((double)lvl * bossTier.getLevelMultiplier());
                    PermanentStats permanentStats = pw.getStats();
                    permanentStats.getIVs().maximizeIVs();
                    permanentStats.getEVs().randomizeMaxEVs();
                    pw.setTempLevel(lvl += bossTier.getExtraLevels());
                }
            }
            pw.setHealth(pw.getMaxHealth());
            pw.getMoveset().forEach(attack -> {
                if (attack != null) {
                    attack.pp = attack.getMaxPP();
                }
            });
            pw.onBattlefield = true;
        }
        if (this.getBattleAI() == null) {
            this.setBattleAI(isBoss ? PixelmonConfigProxy.getBattle().getBattleAIBoss().createAI(this) : PixelmonConfigProxy.getBattle().getBattleAIWild().createAI(this));
        }
    }

    @Override
    public void endBattle(BattleEndCause cause) {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.resetBattleEvolution();
            if (pw.entity != null) {
                pw.entity.onEndBattle();
            }
            if (pw.entity == null || !pw.isFainted() && !this.shouldDespawn() && !this.isBlockBattleParticipant) continue;
            pw.entity.m_6089_();
        }
    }

    private boolean shouldDespawn() {
        if (PixelmonConfigProxy.getSpawning().isDespawnOnFleeOrLoss()) {
            if (this.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE) {
                return this.bc.getOpponents(this).get(0) instanceof PlayerParticipant;
            }
            return true;
        }
        return false;
    }

    @Override
    public void getNextPokemon(int position) {
    }

    @Override
    public UUID getNextPokemonUUID() {
        return null;
    }

    @Override
    public Component getName() {
        Object key = "";
        if (!this.controlledPokemon.isEmpty()) {
            key = "pixelmon." + ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity.getLocalizedName().toLowerCase(Locale.ROOT);
        }
        return Component.m_237115_((String)key);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pw) {
        if (this.bc == null) {
            return null;
        }
        if (!pw.getMoveset().isEmpty()) {
            return this.getBattleAI().getNextMove(pw);
        }
        this.bc.setFlee(pw.getPokemonUUID());
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper oldPokemon, UUID newPixelmonUUID) {
        int index = oldPokemon.getControlledIndex();
        if (index == -1 && this.bc.simulateMode) {
            index = 0;
        }
        String beforeName = oldPokemon.getNickname();
        PixelmonWrapper newWrapper = this.getPokemonFromParty(newPixelmonUUID);
        newWrapper.bc = oldPokemon.bc;
        oldPokemon.beforeSwitch(newWrapper);
        if (!oldPokemon.isFainted() && !oldPokemon.nextSwitchIsMove) {
            this.bc.sendToOthers("playerparticipant.withdrew", this, oldPokemon.getPokemonName(), beforeName);
        }
        this.controlledPokemon.set(index, newWrapper);
        newWrapper.getBattleAbility().beforeSwitch(newWrapper);
        if (!this.bc.simulateMode) {
            this.bc.sendToOthers("pixelmon.battletext.sentout", this, oldPokemon.getPokemonName(), newWrapper.getNickname());
            this.bc.participants.forEach(BattleParticipant::updateOtherPokemon);
        }
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        boolean allGood = true;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.getMoveset().isEmpty()) continue;
            pw.pokemon.getMoveset().clear();
            pw.pokemon.getMoveset().addAll(pw.pokemon.getForm().getMoves().loadMoveset(pw.getPokemonLevelNum()));
            if (!pw.getMoveset().isEmpty()) continue;
            if (PixelmonConfigProxy.getGeneral().getDebug().isPrintErrors()) {
                Pixelmon.LOGGER.info("Couldn't load " + pw.pokemon.getLocalizedName() + "'s moves.");
            }
            allGood = false;
        }
        return allGood;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
    }

    public Mob getEntity() {
        if (this.controlledPokemon.isEmpty()) {
            return null;
        }
        return ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity;
    }

    public PixelmonWrapper asWrapper() {
        Iterator iterator = this.controlledPokemon.iterator();
        if (iterator.hasNext()) {
            PixelmonWrapper pixelmonWrapper = (PixelmonWrapper)iterator.next();
            return pixelmonWrapper;
        }
        return null;
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public boolean canDynamax() {
        return false;
    }

    @Override
    public String getDisplayName() {
        Iterator iterator = this.controlledPokemon.iterator();
        if (iterator.hasNext()) {
            PixelmonWrapper pw = (PixelmonWrapper)iterator.next();
            return pw.getNickname();
        }
        return super.getDisplayName();
    }
}

