/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class TestParticipant
extends BattleParticipant {
    public boolean hasAmuletCoin = false;
    public int amuletCoinMultiplier = PixelmonConfigProxy.getItems().getAmuletCoinMultiplier();
    public boolean hasHappyHour = false;
    public int happyHourMultiplier = PixelmonConfigProxy.getBattle().getHappyHourMultiplier();
    public int payDay = 0;
    public EnumMegaItemsUnlocked unlocked = EnumMegaItemsUnlocked.Both;
    public HashMap<UUID, MoveChoice> moveChoices = new HashMap();
    public List<Component> battleMessages = Lists.newArrayList();

    public TestParticipant(Pokemon ... team) {
        super(1);
        this.loadParty(Lists.newArrayList((Object[])team));
        this.initialize();
    }

    public TestParticipant(int numControlled, Pokemon ... team) {
        super(numControlled);
        this.loadParty(Lists.newArrayList((Object[])team));
        this.initialize();
    }

    private void initialize() {
        this.setBattleAI(new NoOpAI(this));
        int positionIndex = 0;
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (pixelmonWrapper != null) {
                this.controlledPokemon.add(pixelmonWrapper);
                pixelmonWrapper.battlePosition = positionIndex++;
                pixelmonWrapper.onBattlefield = true;
            }
            if (this.controlledPokemon.size() >= this.numControlledPokemon) break;
        }
    }

    public PixelmonWrapper asWrapper() {
        return (PixelmonWrapper)this.controlledPokemon.get(0);
    }

    public PixelmonWrapper asWrapper(Pokemon pokemon) {
        return this.getPokemonFromParty(pokemon.getUUID());
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Test;
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (pixelmonWrapper == null || !pixelmonWrapper.isAlive() || this.controlledPokemon.contains(pixelmonWrapper) || pixelmonWrapper.isSwitching || this.switchingOut.contains(pixelmonWrapper)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startBattle() {
        super.startBattle();
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.bc = this.bc;
        }
    }

    public void logBattleMessage(Component message) {
        this.battleMessages.add(message);
    }

    private ComponentContents lastMessageContents() {
        return this.battleMessages.get(this.battleMessages.size() - 1).m_214077_();
    }

    public String lastMessageKey() {
        ComponentContents lastMessage = this.lastMessageContents();
        if (lastMessage instanceof TranslatableContents) {
            return ((TranslatableContents)lastMessage).m_237508_();
        }
        return null;
    }

    public boolean hasMessageContaining(String keyFragment) {
        for (Component message : this.battleMessages) {
            TranslatableContents translatableContents;
            ComponentContents componentContents = message.m_214077_();
            if (!(componentContents instanceof TranslatableContents) || !(translatableContents = (TranslatableContents)componentContents).m_237508_().contains(keyFragment)) continue;
            return true;
        }
        return false;
    }

    public int numberOfMessageOccurrences(String keyFragment) {
        int count = 0;
        for (Component message : this.battleMessages) {
            TranslatableContents translatableContents;
            ComponentContents componentContents = message.m_214077_();
            if (!(componentContents instanceof TranslatableContents) || !(translatableContents = (TranslatableContents)componentContents).m_237508_().contains(keyFragment)) continue;
            ++count;
        }
        return count;
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonList() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            teamPokemon.addAll(p.controlledPokemon);
        }
        return teamPokemon;
    }

    @Override
    public void endBattle(BattleEndCause cause) {
        String burmyForm = null;
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (!pixelmonWrapper.changeBurmy || this.controlledPokemon.isEmpty()) continue;
            if (burmyForm == null) {
                burmyForm = PixelmonForms.getFromTerrain(TerrainExamine.getTerrain((PixelmonWrapper)this.controlledPokemon.get(0)));
            }
            pixelmonWrapper.pokemon.setForm(burmyForm);
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.resetOnSwitch();
            pw.resetBattleEvolution();
            if (cause != BattleEndCause.FLEE && cause != BattleEndCause.FORFEIT && cause != BattleEndCause.FORCE) continue;
            this.resetPayDay();
        }
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            pixelmonWrapper.resetBattleEvolution();
            pixelmonWrapper.writeToNBT();
        }
        if (this.payDay > 0 && this.hasMorePokemon()) {
            this.payDay *= this.getPrizeMoneyMultiplier();
            ChatHandler.sendBattleMessage((Entity)this.getEntity(), "pixelmon.effect.paydayend", this.getName(), this.payDay);
        }
    }

    @Override
    public void getNextPokemon(int position) {
        if (position >= this.controlledPokemon.size() || this.bc.battleEnded) {
            this.wait = false;
            return;
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.battlePosition != position) continue;
            this.bc.switchPokemon(pw.getPokemonUUID(), this.getBattleAI().getNextSwitch(pw), true);
            return;
        }
    }

    public UUID getNextSwitch(PixelmonWrapper user) {
        if (this.moveChoices.containsKey(user.getPokemonUUID())) {
            MoveChoice move = this.moveChoices.get(user.getPokemonUUID());
            return move.switchPokemon;
        }
        return null;
    }

    public int getPrizeMoneyMultiplier() {
        int multiplier = 1;
        if (this.hasAmuletCoin) {
            multiplier *= this.amuletCoinMultiplier;
        }
        if (this.hasHappyHour) {
            multiplier *= this.happyHourMultiplier;
        }
        return multiplier;
    }

    @Override
    public UUID getNextPokemonUUID() {
        for (PixelmonWrapper pw : this.allPokemon) {
            if (!pw.pokemon.canBattle() || pw.onBattlefield) continue;
            return pw.getPokemonUUID();
        }
        return null;
    }

    @Override
    public Component getName() {
        return Component.m_237113_((String)"test-participant");
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pixelmonWrapper) {
        return null;
    }

    @Override
    public void selectAction() {
        for (PixelmonWrapper p : this.controlledPokemon) {
            MoveChoice moveChoice;
            if (p.attack != null && p.attack.doesPersist(p)) continue;
            if (p.skipsTurn()) {
                return;
            }
            if (p.bc == null) {
                p.bc = this.bc;
            }
            if ((moveChoice = this.moveChoices.get(p.getPokemonUUID())) == null) continue;
            if (moveChoice.isAttack()) {
                p.setAttack(moveChoice.attack, moveChoice.targets, p.willEvolve);
                continue;
            }
            this.bc.switchPokemon(p.getPokemonUUID(), moveChoice.switchPokemon, false);
        }
    }

    public void evolve() {
        Pokemon user = ((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon;
        this.evolve(user);
    }

    public void evolve(Pokemon pokemon) {
        PixelmonWrapper pw = this.bc.getPokemonFromUUID(pokemon.getUUID());
        pw.willEvolve = true;
    }

    public void useZMove() {
        this.useZMove(((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon);
    }

    public void useZMove(Pokemon user) {
        this.getPokemonFromParty((UUID)user.getUUID()).usingZ = true;
    }

    public void switchPokemon(Pokemon switchingOut, Pokemon switchingIn) {
        if (this.moveChoices.containsKey(switchingOut.getUUID())) {
            MoveChoice choice = this.moveChoices.get(switchingOut.getUUID());
            choice.switchPokemon = switchingIn.getUUID();
        } else {
            PixelmonWrapper pw = this.getPartyPokemonFromUUID(switchingOut.getUUID());
            MoveChoice choice = new MoveChoice(pw, switchingIn.getUUID());
            this.moveChoices.put(pw.getPokemonUUID(), choice);
        }
    }

    public void attackSelf(int move) {
        PixelmonWrapper user = (PixelmonWrapper)this.controlledPokemon.get(0);
        Attack attack = user.getMoveset().get(move - 1);
        MoveChoice choice = new MoveChoice(user, attack, Lists.newArrayList((Object[])new PixelmonWrapper[]{user}));
        this.moveChoices.put(user.getPokemonUUID(), choice);
    }

    public void attackSelf(Pokemon pw, int move) {
        PixelmonWrapper user = this.getPokemonFromParty(pw.getUUID());
        Attack attack = user.getMoveset().get(move - 1);
        MoveChoice choice = new MoveChoice(user, attack, Lists.newArrayList((Object[])new PixelmonWrapper[]{user}));
        this.moveChoices.put(user.getPokemonUUID(), choice);
    }

    public void attackAuto() {
        this.attackOpponent(1);
    }

    public void attackAutoTarget(int move) {
        Pokemon user = ((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon;
        this.attackAutoTarget(user, move);
    }

    public void attackAutoTargetAll() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            this.attackAutoTarget(pw.pokemon, 1);
        }
    }

    public void attackAuto(Pokemon user) {
        PixelmonWrapper pw = this.getPokemonFromParty(user.getUUID());
        Attack attack = user.getMoveset().get(0);
        MoveChoice choice = new MoveChoice(pw, attack, Lists.newArrayList((Object[])new PixelmonWrapper[]{this.bc.getOppositePokemon(pw)}));
        this.moveChoices.put(user.getUUID(), choice);
    }

    public void attackAutoTarget(Pokemon user, int move) {
        PixelmonWrapper pw = this.bc.getPokemonFromUUID(user.getUUID());
        Attack attack = pw.getMoveset().get(move - 1);
        ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
        if (attack.getMove().getTargetingInfo().hitsAll) {
            PixelmonWrapper opposite;
            if (attack.getMove().getTargetingInfo().hitsSelf) {
                targets.add(pw);
            }
            if ((opposite = this.bc.getOppositePokemon(pw)) != null) {
                if (attack.getMove().getTargetingInfo().hitsOppositeFoe) {
                    targets.add(opposite);
                }
                int oppositePosition = opposite.battlePosition;
                ArrayList<PixelmonWrapper> oppositePokemon = this.bc.getOpponentPokemon(pw);
                if (attack.getMove().getTargetingInfo().hitsAdjacentFoe) {
                    if (oppositePosition - 1 >= 0) {
                        targets.add((PixelmonWrapper)oppositePokemon.get(oppositePosition - 1));
                    }
                    if (oppositePosition + 1 < oppositePokemon.size()) {
                        targets.add((PixelmonWrapper)oppositePokemon.get(oppositePosition + 1));
                    }
                }
                if (attack.getMove().getTargetingInfo().hitsExtendedFoe) {
                    for (PixelmonWrapper target : oppositePokemon) {
                        if (Math.abs(target.battlePosition - oppositePosition) < 2) continue;
                        targets.add(target);
                    }
                }
            }
            if (attack.getMove().getTargetingInfo().hitsAdjacentAlly) {
                ArrayList<PixelmonWrapper> team = this.getTeamPokemonList();
                for (PixelmonWrapper active : team) {
                    if (Math.abs(active.battlePosition - pw.battlePosition) != 1) continue;
                    targets.add(active);
                }
            }
            if (attack.getMove().getTargetingInfo().hitsExtendedAlly) {
                ArrayList<PixelmonWrapper> team = this.getTeamPokemonList();
                for (PixelmonWrapper active : team) {
                    if (Math.abs(active.battlePosition - pw.battlePosition) < 2) continue;
                    targets.add(active);
                }
            }
        } else if (attack.getMove().getTargetingInfo().hitsSelf) {
            targets.add(pw);
        } else if (attack.getMove().getTargetingInfo().hitsOppositeFoe) {
            targets.add(this.bc.getOppositePokemon(pw));
        } else {
            targets.add(this.bc.getTeamPokemonExcludeSelf(pw).get(0));
        }
        MoveChoice choice = new MoveChoice(pw, attack, targets);
        this.moveChoices.put(pw.getPokemonUUID(), choice);
    }

    public void attackOpponent(int move) {
        PixelmonWrapper user = (PixelmonWrapper)this.controlledPokemon.get(0);
        Attack attack = user.getMoveset().get(move - 1);
        MoveChoice choice = new MoveChoice(user, attack, this.bc.getOpponentPokemon(user));
        this.moveChoices.put(user.getPokemonUUID(), choice);
    }

    public void attackOpponent(Pokemon user, int move) {
        PixelmonWrapper pw = this.getPokemonFromParty(user.getUUID());
        Attack attack = pw.getMoveset().get(move - 1);
        MoveChoice choice = new MoveChoice(pw, attack, this.bc.getOpponentPokemon(pw));
        this.moveChoices.put(user.getUUID(), choice);
    }

    public void attackTarget(int move, Pokemon target) {
        Pokemon user = ((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon;
        this.attackTarget(user, move, target);
    }

    public void attackTarget(Pokemon user, int move, Pokemon target) {
        this.attackTarget(user, move, Lists.newArrayList((Object[])new Pokemon[]{target}));
    }

    public void attackTarget(Pokemon user, int move, List<Pokemon> targets) {
        PixelmonWrapper pw = this.getPokemonFromParty(user.getUUID());
        Attack attack = pw.getMoveset().get(move - 1);
        ArrayList<PixelmonWrapper> targetList = new ArrayList<PixelmonWrapper>(targets.size());
        for (Pokemon poke : targets) {
            PixelmonWrapper targetPW = this.bc.getPokemonFromUUID(poke.getUUID());
            if (targetPW == null) continue;
            targetList.add(targetPW);
        }
        MoveChoice choice = new MoveChoice(pw, attack, targetList);
        this.moveChoices.put(pw.getPokemonUUID(), choice);
    }

    @Override
    public void onEndTurn(BattleController bc) {
        for (PixelmonWrapper pw : this.allPokemon) {
            if (pw.attack != null && pw.attack.doesPersist(pw)) continue;
            this.moveChoices.remove(pw.getPokemonUUID());
        }
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, UUID newPixelmonUUID) {
        PixelmonWrapper newWrapper = this.getPokemonFromParty(newPixelmonUUID);
        if (newWrapper.bc == null) {
            newWrapper.bc = this.bc;
        }
        pw.beforeSwitch(newWrapper);
        newWrapper.battlePosition = pw.battlePosition;
        newWrapper.onBattlefield = true;
        pw.onBattlefield = false;
        newWrapper.getBattleAbility().beforeSwitch(newWrapper);
        int index = this.controlledPokemon.indexOf(pw);
        this.controlledPokemon.set(index, newWrapper);
        this.bc.participants.forEach(BattleParticipant::updateOtherPokemon);
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (PixelmonWrapper pw : this.allPokemon) {
            if (!pw.getMoveset().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
    }

    @Override
    public LivingEntity getEntity() {
        return null;
    }

    @Override
    public void updateOtherPokemon() {
    }

    public int getHighestLevel() {
        int lvl = -1;
        for (PixelmonWrapper pw : this.allPokemon) {
            lvl = Math.max(lvl, pw.getPokemonLevelNum());
        }
        return lvl;
    }

    @Override
    public String getDisplayName() {
        return "TestPlayer";
    }

    @Override
    public boolean canMegaEvolve() {
        if (this.bc != null && this.bc.isRaid()) {
            return false;
        }
        return this.unlocked.canMega();
    }

    @Override
    public boolean canDynamax() {
        BattleParticipant bp;
        if (this.bc != null && this.bc.isRaid() && (bp = this.getOpponents().get(0)) instanceof RaidPixelmonParticipant) {
            RaidPixelmonParticipant rpp = (RaidPixelmonParticipant)bp;
            return rpp.canDynamax(this);
        }
        return this.unlocked.canDynamax();
    }

    public void resetPayDay() {
        this.payDay = 0;
    }
}

