/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.BattleItemScanner;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.DynamaxEvent;
import com.pixelmonmod.pixelmon.api.events.MegaEvolutionEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonFaintEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonKnockoutEvent;
import com.pixelmonmod.pixelmon.api.events.battles.AttackEvent;
import com.pixelmonmod.pixelmon.api.events.battles.UseBattleItemEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Comatose;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Corrosion;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Illusion;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Imposter;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Levitate;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Multitype;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overcoat;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ParadoxBoostAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ParentalBond;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.RKSSystem;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Trace;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PokemonLevel;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.pokemon.stats.TempBattlePokemonLevel;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonDamageTypes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.ZMove;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.AttackModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.CriticalHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.MultipleHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.Recoil;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BatonPass;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BeatUp;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.DragonDarts;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.FalseSwipe;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.NightShade;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.PopulationBomb;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TripleAxel;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TripleKick;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.BattlePriorityHelper;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.AttackAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.BagItemAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.ChangeAbilityAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.ChangeTypeAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.DamagePokemonAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.EnterDynamaxAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.ExitDynamaxAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.HealPokemonAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.HeldItemChangeAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.MegaEvolveAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.SelectAttackAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.StatusAddAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.StatusRemoveAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.SwitchAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.UltraBurstAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.InPursuit;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.ProtectVariation;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Substitute;
import com.pixelmonmod.pixelmon.battles.tasks.HPIncreaseTask;
import com.pixelmonmod.pixelmon.battles.tasks.RaidShieldsTask;
import com.pixelmonmod.pixelmon.battles.tasks.StatusUpdateTask;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.DynamaxPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.MegaEvolvePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UpdateMovesetPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UseItemPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UseZMovePacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.enums.items.EnumOrbShard;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.MemoryItem;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.heldItems.BlankTechnicalMachineItem;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import com.pixelmonmod.pixelmon.items.heldItems.OrbItem;
import com.pixelmonmod.pixelmon.items.heldItems.PlateItem;
import com.pixelmonmod.pixelmon.items.heldItems.ZCrystalItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class PixelmonWrapper {
    public PixelmonEntity entity;
    public Pokemon pokemon;
    public Pokemon initialCopyOfPokemon;
    private final BattleParticipant participant;
    public BattleController bc;
    public Attack attack;
    public Attack selectedAttack;
    public Attack lastAttack;
    public Attack lastSimulatedAttack;
    public Attack lastTempAttack;
    public Attack lastSimulatedTempAttack;
    public List<PixelmonWrapper> lastTargets = new ArrayList<PixelmonWrapper>();
    public List<PixelmonWrapper> lastSimulatedTargets = new ArrayList<PixelmonWrapper>();
    public int targetIndex;
    public Set<Attack> usedMoves = new HashSet<Attack>();
    public int escapeAttempts = 0;
    public int damageTakenThisTurn = 0;
    public int amountOfTimesHit = 0;
    public float priority;
    public boolean canAttack = true;
    public boolean willTryFlee = false;
    public boolean isSwitching = false;
    public boolean willEvolve = false;
    public boolean nextSwitchIsMove;
    public UUID willUseItemPokemon;
    public ItemStack willUseItemInStack;
    public int willUseItemInStackInfo;
    private boolean takenTurn = false;
    public boolean hasBeenInBattle = false;
    public boolean isTempAttack = false;
    public boolean wait;
    public boolean onBattlefield;
    public int battlePosition;
    private int partyPosition;
    private double[] basePos;
    private List<Element> initialType = null;
    public Element addedType;
    public Ability tempAbility = null;
    public Moveset temporaryMoveset = null;
    private boolean returnHeldItem = false;
    public List<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
    public UUID newPokemonUUID;
    public boolean inMultipleHit = false;
    public boolean inParentalBond = false;
    public int protectsInARow = 0;
    public boolean hasAwardedExp = false;
    private Set<PixelmonWrapper> attackers = new HashSet<PixelmonWrapper>();
    public boolean switchedThisTurn = false;
    public boolean switchedLastTurn = false;
    public boolean evolvedThisTurn = false;
    public boolean faintedAtEndOfTurn = false;
    public boolean changeBurmy = false;
    public Attack choiceLocked;
    public boolean choiceSwapped = false;
    public int metronomeBoost;
    private HeldItem consumedHeldItem = PixelmonItems.no_item;
    public boolean eatenBerry = false;
    public boolean eatingBerry = false;
    public boolean forceEatingBerry = false;
    public int lastDirectDamage = -1;
    public int lastHP = -1;
    protected int beginingOfTurnHP;
    public AttackCategory lastDirectCategory;
    public int lastDirectPosition;
    public EvolutionQuery evolution = null;
    private boolean tempLevel;
    protected PokemonLevel temporaryPokemonLevel = null;
    int startHealth;
    private BattleStats battleStats = new BattleStats(this);
    private List<StatusBase> status = new ArrayList<StatusBase>();
    public List<Element> type = new ArrayList<Element>();
    public boolean isMega;
    public int isDynamax = 0;
    public int dynamaxTurns = 3;
    public Stats prevForm = null;
    public String prevPaletteName = "";
    public boolean animateHP = true;
    public boolean usingZ = false;
    public boolean usingZPower = false;
    public ZMove zMove = null;
    public boolean ignoringZCrystal = false;
    public boolean skipZConvert = false;
    public int shields = 0;
    public int maxShields = 0;

    private PixelmonWrapper(BattleParticipant participant) {
        this.participant = participant;
    }

    public PixelmonWrapper(BattleParticipant participant, PixelmonEntity entity, int partyPosition) {
        this(participant);
        this.pokemon = entity.getPokemon();
        this.entity = entity;
        this.entity.setPixelmonWrapper(this);
        this.loadFromPokemon(this.pokemon);
        this.isMega = this.pokemon.getForm().hasMegaForm() && entity.getBossTier().isMega();
        this.beginingOfTurnHP = this.getHealth();
    }

    public PixelmonWrapper(BattleParticipant participant, PixelmonEntity pixelmon, int partyPosition, BattleController bc) {
        this(participant, pixelmon, partyPosition);
        if (this.entity != null) {
            this.entity.battleController = bc;
        }
        this.bc = bc;
    }

    public PixelmonWrapper(BattleParticipant participant, Pokemon pokemon, int partyPosition) {
        this(participant);
        this.pokemon = pokemon;
        this.loadFromPokemon(pokemon);
        this.isMega = false;
        this.isDynamax = 0;
        this.partyPosition = partyPosition;
        this.beginingOfTurnHP = this.getHealth();
    }

    public PixelmonWrapper(PixelmonWrapper pw) {
        this.addedType = pw.addedType;
        this.amountOfTimesHit = pw.amountOfTimesHit;
        this.animateHP = pw.animateHP;
        this.onBattlefield = pw.onBattlefield;
        this.battlePosition = pw.battlePosition;
        this.canAttack = pw.canAttack;
        this.changeBurmy = pw.changeBurmy;
        this.choiceSwapped = pw.choiceSwapped;
        this.damageTakenThisTurn = pw.damageTakenThisTurn;
        this.dynamaxTurns = pw.dynamaxTurns;
        this.eatenBerry = pw.eatenBerry;
        this.eatingBerry = pw.eatingBerry;
        this.escapeAttempts = pw.escapeAttempts;
        this.hasAwardedExp = pw.hasAwardedExp;
        this.ignoringZCrystal = pw.ignoringZCrystal;
        this.inMultipleHit = pw.inMultipleHit;
        this.inParentalBond = pw.inParentalBond;
        this.isDynamax = pw.isDynamax;
        this.isMega = pw.isMega;
        this.isSwitching = pw.isSwitching;
        this.lastDirectDamage = pw.lastDirectDamage;
        this.lastDirectPosition = pw.lastDirectPosition;
        this.lastHP = pw.lastHP;
        this.maxShields = pw.maxShields;
        this.metronomeBoost = pw.metronomeBoost;
        this.nextSwitchIsMove = pw.nextSwitchIsMove;
        this.partyPosition = pw.partyPosition;
        this.prevForm = pw.prevForm;
        this.prevPaletteName = pw.prevPaletteName;
        this.priority = pw.priority;
        this.protectsInARow = pw.protectsInARow;
        this.returnHeldItem = pw.returnHeldItem;
        this.shields = pw.shields;
        this.skipZConvert = pw.skipZConvert;
        this.startHealth = pw.startHealth;
        this.switchedThisTurn = pw.switchedThisTurn;
        this.targetIndex = pw.targetIndex;
        this.tempLevel = pw.tempLevel;
        this.usingZ = pw.usingZ;
        this.wait = pw.wait;
        this.willEvolve = pw.willEvolve;
        this.willTryFlee = pw.willTryFlee;
        this.willUseItemInStackInfo = pw.willUseItemInStackInfo;
        this.attack = pw.attack != null ? pw.attack.deepCopy() : null;
        this.battleStats = pw.battleStats.copy();
        this.bc = pw.bc;
        this.choiceLocked = pw.choiceLocked;
        this.consumedHeldItem = pw.consumedHeldItem;
        this.entity = pw.entity;
        this.evolution = pw.evolution;
        this.initialCopyOfPokemon = PokemonBuilder.copy(pw.initialCopyOfPokemon).build();
        this.lastAttack = pw.lastAttack != null ? pw.lastAttack.deepCopy() : null;
        this.lastSimulatedAttack = pw.lastSimulatedAttack;
        this.lastTempAttack = pw.lastTempAttack;
        this.lastSimulatedTempAttack = pw.lastSimulatedTempAttack;
        this.lastDirectCategory = pw.lastDirectCategory;
        this.lastTargets = pw.lastTargets;
        this.lastSimulatedTargets = pw.lastSimulatedTargets;
        this.newPokemonUUID = pw.newPokemonUUID;
        this.participant = pw.participant;
        this.pokemon = pw.pokemon;
        this.selectedAttack = pw.selectedAttack != null ? pw.selectedAttack.deepCopy() : null;
        this.tempAbility = pw.tempAbility;
        this.temporaryMoveset = pw.temporaryMoveset != null ? pw.temporaryMoveset.copy() : null;
        this.temporaryPokemonLevel = pw.temporaryPokemonLevel;
        this.willUseItemInStack = pw.willUseItemInStack;
        this.willUseItemPokemon = pw.willUseItemPokemon;
        this.zMove = pw.zMove;
        this.attackers = new HashSet<PixelmonWrapper>(pw.attackers.size());
        this.attackers.addAll(pw.attackers);
        this.basePos = pw.basePos != null ? (double[])pw.basePos.clone() : null;
        ArrayList arrayList = this.initialType = pw.initialType == null ? null : new ArrayList(pw.initialType.size());
        if (pw.initialType != null) {
            this.initialType.addAll(pw.initialType);
        }
        this.status = new ArrayList<StatusBase>(pw.status.size());
        this.status.addAll(pw.status.stream().map(StatusBase::copy).collect(Collectors.toList()));
        this.targets = new ArrayList<PixelmonWrapper>(pw.targets.size());
        this.targets.addAll(pw.targets);
        this.type = new ArrayList<Element>(pw.type.size());
        this.type.addAll(pw.type);
        this.usedMoves = new HashSet<Attack>(pw.usedMoves.size());
        this.usedMoves.addAll(pw.usedMoves);
        this.beginingOfTurnHP = pw.beginingOfTurnHP;
    }

    private void loadFromPokemon(Pokemon pokemon) {
        this.isMega = false;
        this.isDynamax = 0;
        if (this.entity != null) {
            this.entity.dynamaxAnimationTicks = 0;
        }
        this.type = new ArrayList<Element>(pokemon.getForm().getTypes());
        this.initialCopyOfPokemon = PokemonBuilder.copy(pokemon).build();
        if (pokemon.getStatus() != NoStatus.noStatus) {
            this.getStatuses().add(pokemon.getStatus());
        }
    }

    public PermanentStats getStats() {
        return this.pokemon.getStats();
    }

    public BattleStats getBattleStats() {
        return this.battleStats;
    }

    public List<Element> getInitialType() {
        return this.initialType;
    }

    public int getFriendship() {
        return this.pokemon.getFriendship();
    }

    public Set<PixelmonWrapper> getAttackers() {
        return this.attackers;
    }

    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.getInnerLink().getPokerus());
    }

    public boolean hasType(Element ... types) {
        for (Element type : types) {
            if (!this.type.contains(type)) continue;
            return true;
        }
        return false;
    }

    public void clearTurnVariables() {
        this.canAttack = true;
        this.willTryFlee = false;
        if (this.isAlive()) {
            this.isSwitching = false;
        }
        this.switchedThisTurn = false;
    }

    public void setMoveTargets(PixelmonWrapper ... pokemon) {
        this.targets.clear();
        Collections.addAll(this.targets, pokemon);
    }

    public void selectAIAction() {
        if (this.attack == null || !this.attack.doesPersist(this)) {
            if (this.skipsTurn()) {
                return;
            }
            if (this.bc == null) {
                this.bc = this.participant.bc;
            }
            this.chooseMove();
        }
    }

    public boolean skipsTurn() {
        for (StatusBase status : this.getStatuses()) {
            if (!status.skipsTurn()) continue;
            return true;
        }
        return false;
    }

    public boolean canEvolve() {
        for (StatusBase status : this.getStatuses()) {
            if (!status.stopsEvolution(this)) continue;
            return false;
        }
        return true;
    }

    public boolean stopsForcedSwitches(PixelmonWrapper cause) {
        if (this.getBattleAbility(cause).stopsForcedSwitches(this, cause)) {
            return true;
        }
        for (StatusBase status : this.getStatuses()) {
            if (!status.stopsForcedSwitches(cause)) continue;
            return true;
        }
        return false;
    }

    public void chooseMove() {
        this.chooseMove(this.participant.getMove(this));
    }

    public void chooseMove(MoveChoice moveChoice) {
        if (moveChoice != null) {
            if (moveChoice.isAttack()) {
                this.setAttack(moveChoice.attack, moveChoice.targets, true);
            } else {
                this.bc.switchPokemon(this.getPokemonUUID(), moveChoice.switchPokemon, false);
            }
        }
    }

    public ArrayList<PixelmonWrapper> getTargets(Attack chosenAttack) {
        ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
        if (chosenAttack == null) {
            return targets;
        }
        TargetingInfo info = chosenAttack.getMove().getTargetingInfo();
        ArrayList<PixelmonWrapper> teamPokemon = this.bc.getTeamPokemon(this.participant);
        ArrayList<PixelmonWrapper> opponentPokemon = this.bc.getOpponentPokemon(this.participant);
        boolean[][] targetted = new boolean[][]{new boolean[teamPokemon.size()], new boolean[opponentPokemon.size()]};
        int mypos = teamPokemon.indexOf(this);
        if (this.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.HORDE && info.hitsAll && info.hitsOppositeFoe && info.hitsAdjacentFoe) {
            targets.addAll(opponentPokemon);
            return targets;
        }
        if (info.hitsAll) {
            if (info.hitsOppositeFoe && targetted[1].length > mypos) {
                targetted[1][mypos] = true;
            }
            if (info.hitsAdjacentFoe) {
                if (mypos - 1 >= 0) {
                    targetted[1][mypos - 1] = true;
                }
                if (mypos + 1 < targetted[1].length) {
                    targetted[1][mypos + 1] = true;
                }
            }
            if (info.hitsExtendedFoe) {
                if (mypos - 2 >= 0) {
                    targetted[1][mypos - 2] = true;
                }
                if (mypos + 2 < targetted[1].length) {
                    targetted[1][mypos + 2] = true;
                }
            }
            if (info.hitsSelf) {
                targetted[0][mypos] = true;
            }
            if (info.hitsAdjacentAlly) {
                if (mypos - 1 >= 0) {
                    targetted[0][mypos - 1] = true;
                }
                if (mypos + 1 < targetted[0].length) {
                    targetted[0][mypos + 1] = true;
                }
            }
            if (info.hitsExtendedAlly) {
                if (mypos - 2 >= 0) {
                    targetted[0][mypos - 2] = true;
                }
                if (mypos + 2 < targetted[0].length) {
                    targetted[0][mypos + 2] = true;
                }
            }
            if (this.bc.isRaid() && info.hitsSelf && info.hitsAdjacentAlly && info.hitsExtendedAlly) {
                if (mypos - 3 >= 0) {
                    targetted[0][mypos - 3] = true;
                }
                if (mypos + 3 < targetted[0].length) {
                    targetted[0][mypos + 3] = true;
                }
            }
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < targetted[i].length; ++j) {
                    if (!targetted[i][j]) continue;
                    if (i == 0) {
                        targets.add(teamPokemon.get(j));
                        continue;
                    }
                    targets.add(opponentPokemon.get(j));
                }
            }
        } else {
            ArrayList<PixelmonWrapper> tempTargets = new ArrayList<PixelmonWrapper>();
            if (info.hitsSelf) {
                tempTargets.add(this);
            }
            if (info.hitsAdjacentAlly) {
                if (mypos > 0 && teamPokemon.size() > mypos - 1) {
                    tempTargets.add(teamPokemon.get(mypos - 1));
                }
                if (mypos < teamPokemon.size() - 1) {
                    tempTargets.add(teamPokemon.get(mypos + 1));
                }
            }
            if (info.hitsExtendedAlly) {
                if (mypos > 1 && teamPokemon.size() > mypos - 2) {
                    tempTargets.add(teamPokemon.get(mypos - 2));
                }
                if (mypos < teamPokemon.size() - 2) {
                    tempTargets.add(teamPokemon.get(mypos + 2));
                }
            }
            if (info.hitsOppositeFoe && mypos < opponentPokemon.size()) {
                tempTargets.add(opponentPokemon.get(mypos));
            }
            if (info.hitsAdjacentFoe) {
                if (mypos > 0 && opponentPokemon.size() > mypos - 1) {
                    tempTargets.add(opponentPokemon.get(mypos - 1));
                }
                if (mypos < opponentPokemon.size() - 1) {
                    tempTargets.add(opponentPokemon.get(mypos + 1));
                }
            }
            if (info.hitsExtendedFoe) {
                if (mypos > 1 && opponentPokemon.size() > mypos - 2) {
                    tempTargets.add(opponentPokemon.get(mypos - 2));
                }
                if (mypos < opponentPokemon.size() - 2) {
                    tempTargets.add(opponentPokemon.get(mypos + 2));
                }
            }
            for (int i = 0; i < tempTargets.size(); ++i) {
                if (tempTargets.get(i) != null) continue;
                tempTargets.remove(i);
                --i;
            }
            ArrayList invalid = new ArrayList();
            if (!tempTargets.isEmpty()) {
                if (info.hitsOppositeFoe || info.hitsExtendedFoe || info.hitsAdjacentFoe) {
                    invalid.addAll(tempTargets.stream().filter(pw -> pw.getParticipant().team == this.getParticipant().team || pw.isFainted()).collect(Collectors.toList()));
                }
                tempTargets.removeAll(invalid);
                if (!tempTargets.isEmpty()) {
                    targets.add((PixelmonWrapper)tempTargets.get(RandomHelper.getRandomNumberBetween(0, tempTargets.size() - 1)));
                }
            }
        }
        return targets;
    }

    public void useAttack() {
        this.selectedAttack = this.attack;
        if (!this.bc.simulateMode) {
            for (BattleParticipant participant : this.bc.participants) {
                participant.getBattleAI().registerMove(this);
            }
        }
        this.useAttack(true);
    }

    public void useAttack(boolean affectPP) {
        if (this.attack == null || this.isFainted()) {
            return;
        }
        if (this.participant.bc.oldGen.isYes() && this.participant.canMegaEvolve()) {
            if (this.usingZ && this.zMove == null) {
                this.zMove = this.attack.getMove().getZMove(this.pokemon, this.ignoringZCrystal);
            }
            if (this.zMove == null) {
                this.usingZ = false;
            }
        }
        this.usedMoves.add(this.attack);
        this.getBattleAbility().startMove(this);
        if (!this.attack.isAttack(AttackRegistry.FOCUS_PUNCH) && !this.hasStatus(StatusType.Bide)) {
            this.bc.sendToAll("pixelmon.battletext.used", this.getNickname(), this.usingZ ? this.zMove.getLocalizedName() : this.attack.getMove().getTranslatedName());
        }
        boolean reducePP = false;
        if (this.targets.size() > 1 && !this.attack.getMove().getTargetingInfo().hitsAll) {
            PixelmonWrapper firstPokemon = this.targets.get(0);
            this.targets.clear();
            this.targets.add(firstPokemon);
        }
        for (EffectBase effect : this.attack.getMove().effects) {
            effect.modifyTargets(this.targets, this.attack, this);
        }
        if (this.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.HORDE && this.attack.getMove().getTargetingInfo().hitsAll && this.attack.getMove().getTargetingInfo().hitsOppositeFoe && this.attack.getMove().getTargetingInfo().hitsAdjacentFoe) {
            this.targets = this.getTargets(this.attack);
        }
        this.manageTargetingFaintedPokemon();
        this.targets = BattlePriorityHelper.getTurnOrder(this.targets);
        MoveResults[] arr = new MoveResults[this.targets.size()];
        this.attack.hasPlayedAnimationOnce = false;
        this.targetIndex = 0;
        while (this.targetIndex < this.targets.size()) {
            PixelmonWrapper target = this.targets.get(this.targetIndex);
            MoveResults results = new MoveResults(target, 0, this.priority, AttackResult.proceed);
            this.attack.saveAttack();
            reducePP = this.attack.use(this, target, results, this.usingZ ? this.zMove : null) || reducePP;
            this.findCriticalHitEffects(target);
            if (this.targetIndex == this.targets.size() - 1) {
                for (EffectBase effect : this.attack.getMove().effects) {
                    if (effect == null) continue;
                    effect.applyEffectAfterAllTargets(this);
                }
            }
            this.attack.restoreAttack();
            this.attack.resetOverridePower();
            if (this.targetIndex >= arr.length) {
                arr = Arrays.copyOf(arr, this.targetIndex + 1);
            }
            if (arr[this.targetIndex] == null) {
                arr[this.targetIndex] = results;
            }
            ++this.targetIndex;
        }
        this.attack.hasPlayedAnimationOnce = false;
        this.updateBattleFromMoveResults(arr);
        this.reducePP(reducePP, affectPP);
        this.registerZMove();
        this.participant.onUseAttackPost(this.bc, this);
    }

    public List<PixelmonWrapper> targetNewNonFaintedPokemon(List<PixelmonWrapper> correctedTargets, PixelmonWrapper target) {
        if (!target.isSameTeam(this) && this.targets.size() == 1) {
            for (PixelmonWrapper otherTarget : target.getTeamPokemon()) {
                if (otherTarget.isFainted() || correctedTargets.size() >= 1 && !this.attack.getMove().getTargetingInfo().hitsAll) continue;
                correctedTargets.add(otherTarget);
            }
        }
        return correctedTargets;
    }

    private void manageTargetingFaintedPokemon() {
        ArrayList deadPokes = new ArrayList();
        ArrayList correctedTargets = new ArrayList();
        if (!this.attack.canHitNoTarget()) {
            this.targets.stream().filter(PixelmonWrapper::isFainted).forEach(target -> {
                deadPokes.add(target);
                this.targetNewNonFaintedPokemon(correctedTargets, (PixelmonWrapper)target);
            });
            deadPokes.forEach(this.targets::remove);
            this.targets.addAll(new ArrayList(correctedTargets));
        }
    }

    private void findCriticalHitEffects(PixelmonWrapper target) {
        CriticalHit critModifier = null;
        for (EffectBase e : new ArrayList<EffectBase>(this.attack.getMove().effects)) {
            if (!(e instanceof AttackModifierBase) || !(e instanceof CriticalHit)) continue;
            critModifier = (CriticalHit)e;
        }
        if (Attack.calcCriticalHit(critModifier, this, target) > 1.0) {
            ++this.pokemon.lastBattleCrits;
        }
    }

    private void updateBattleFromMoveResults(MoveResults[] arr) {
        boolean hadTarget = false;
        boolean ignore = false;
        for (MoveResults result : arr) {
            if (result == null) continue;
            if (result.result == AttackResult.ignore) {
                ignore = true;
            }
            if (result.result != AttackResult.notarget) {
                hadTarget = true;
            }
            if (result.result == AttackResult.charging || result.result == AttackResult.ignore) continue;
            this.savePreviousAttackValues();
        }
        if (!hadTarget) {
            this.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            if (this.hasStatus(StatusType.MultiTurn)) {
                for (EffectBase effect : this.attack.getMove().effects) {
                    effect.applyMissEffect(this, this);
                }
            }
        }
        if (!ignore) {
            this.bc.battleLog.logEvent(new AttackAction(this.bc.battleTurn, this, this.attack, this.targets.toArray(new PixelmonWrapper[0]), arr));
        }
    }

    public void savePreviousAttackValues() {
        if (!this.bc.simulateMode) {
            this.lastAttack = new Attack(this.attack);
            this.lastTargets = new ArrayList<PixelmonWrapper>(this.targets.size());
            this.lastTargets.addAll(this.targets);
            this.bc.lastAttack = new Attack(this.attack);
            if (this.attack != this.selectedAttack) {
                this.lastTempAttack = new Attack(this.attack);
                this.bc.lastTempAttack = new Attack(this.attack);
            }
        } else {
            this.lastSimulatedAttack = new Attack(this.attack);
            this.lastSimulatedTargets = new ArrayList<PixelmonWrapper>(this.targets.size());
            this.lastSimulatedTargets.addAll(this.targets);
            this.bc.lastSimulatedAttack = new Attack(this.attack);
            if (this.attack != this.selectedAttack) {
                this.lastSimulatedTempAttack = new Attack(this.attack);
                this.bc.lastSimulatedTempAttack = new Attack(this.attack);
            }
        }
    }

    public boolean reducePP(boolean reducePP, boolean affectPP) {
        if (reducePP && affectPP && this.attack.pp > 0) {
            if (this.attack.isMax) {
                --this.attack.originalMove.pp;
            } else {
                --this.attack.pp;
            }
            this.setTemporaryMoveset(this.temporaryMoveset);
            return true;
        }
        return false;
    }

    public boolean registerZMove() {
        if (this.participant.bc.oldGen.isYes() && this.participant.canMegaEvolve() && this.usingZ) {
            this.participant.usedZ = true;
            if (this.participant.getType() == ParticipantType.Player) {
                PlayerParticipant player = (PlayerParticipant)this.participant;
                NetworkHelper.sendPacket(new UseZMovePacket(), player.player);
                this.zMove = null;
                return true;
            }
            this.zMove = null;
        }
        return false;
    }

    public MoveResults[] useAttackOnly() {
        MoveResults saveResult = this.attack.moveResult;
        MoveResults[] resultsArray = new MoveResults[this.targets.size()];
        this.targetIndex = 0;
        while (this.targetIndex < this.targets.size()) {
            PixelmonWrapper target = this.targets.get(this.targetIndex);
            resultsArray[this.targetIndex] = new MoveResults(target, 0, this.priority, AttackResult.proceed);
            this.attack.saveAttack();
            this.attack.use(this, target, resultsArray[this.targetIndex]);
            this.attack.restoreAttack();
            ++this.targetIndex;
        }
        this.attack.moveResult = saveResult;
        return resultsArray;
    }

    public void useItem() {
        ItemStack consumedItem;
        UseBattleItemEvent event;
        PixelmonItem item = null;
        ServerPlayer user = null;
        ItemStack usedStack = null;
        int additionalInfo = 0;
        PlayerParticipant playerPart = (PlayerParticipant)this.participant;
        user = playerPart.player;
        PlayerPartyStorage party = playerPart.getStorage();
        if (party == null) {
            return;
        }
        PixelmonWrapper target = this;
        if (this.willUseItemInStackInfo == -1) {
            target = this.getParticipant().getPokemonFromParty(this.willUseItemPokemon);
        }
        usedStack = this.willUseItemInStack;
        additionalInfo = this.willUseItemInStackInfo;
        this.willUseItemInStack = null;
        this.willUseItemInStackInfo = 0;
        this.attack = null;
        this.selectedAttack = null;
        item = (PixelmonItem)usedStack.m_41720_();
        boolean isPokeBall = item instanceof PokeBallItem;
        if (isPokeBall && this.bc.getOpponentPokemon(this.participant).size() >= 1) {
            for (PixelmonWrapper opponent : this.bc.getOpponentPokemon(this.participant)) {
                if (!opponent.isAlive()) continue;
                target = opponent;
                break;
            }
        }
        if (Pixelmon.EVENT_BUS.post((Event)(event = new UseBattleItemEvent(this, target, usedStack, additionalInfo)))) {
            this.bc.getPlayers().forEach(pp -> {
                pp.wait = false;
            });
            return;
        }
        item = (PixelmonItem)event.getStack().m_41720_();
        additionalInfo = event.getAdditionalInfo();
        target = event.getTarget();
        if (target != null) {
            this.bc.battleLog.logEvent(new BagItemAction(this.bc.battleTurn, this, target, item));
        }
        if (isPokeBall) {
            this.bc.sendToAll("pixelmon.pokeballs.throw", this.participant.getDisplayName(), item.m_7626_(usedStack));
        } else {
            this.bc.sendToAll("pixelmon.items.useitem", this.participant.getDisplayName(), item.m_7626_(usedStack));
        }
        if (!isPokeBall && this.hasStatus(StatusType.Embargo)) {
            this.bc.sendToAll("pixelmon.status.embargo", this.getNickname());
        } else if (item.useFromBag(this, target, event.getStack(), additionalInfo) && (consumedItem = BattleItemScanner.consumeItem(usedStack, user)) != null) {
            NetworkHelper.sendPacket(new UseItemPacket(consumedItem.m_41720_()), user);
        }
    }

    public void useTempAttack(Attack tempAttack) {
        if (tempAttack != null) {
            this.useTempAttack(tempAttack, this.getTargets(tempAttack), false);
        }
    }

    public void useTempAttack(Attack tempAttack, PixelmonWrapper target) {
        this.useTempAttack(tempAttack, Lists.newArrayList((Object[])new PixelmonWrapper[]{target}));
    }

    public void useTempAttack(Attack tempAttack, List<PixelmonWrapper> targets) {
        this.useTempAttack(tempAttack, targets, false);
    }

    public void useTempAttack(Attack tempAttack, List<PixelmonWrapper> targets, boolean affectPP) {
        this.targets = targets;
        this.selectedAttack = this.attack;
        this.attack = tempAttack;
        this.isTempAttack = true;
        if (this.usingZ) {
            this.ignoringZCrystal = true;
            if (this.zMove == null) {
                this.zMove = tempAttack.getMove().getZMove(this.pokemon, true);
            }
        }
        if (!this.hasStatus(StatusType.Flinch) || this.getStatus(StatusType.Flinch).canAttackThisTurn(this, tempAttack)) {
            this.useAttack(affectPP);
            for (EffectBase effect : this.attack.getMove().effects) {
                if (!(effect instanceof MultiTurnSpecialAttackBase)) continue;
                if (this.selectedAttack != null) {
                    --this.selectedAttack.pp;
                }
                return;
            }
        }
        this.ignoringZCrystal = false;
        this.attack = this.selectedAttack;
    }

    public void turnTick() {
        boolean isActive;
        if (this.bc == null) {
            this.bc = this.participant.bc;
        }
        Moveset moveset = this.getMoveset();
        for (int i = 0; i < moveset.size(); ++i) {
            moveset.get(i).setDisabled(false, this);
        }
        this.checkSkyBattleDisable();
        boolean bl = isActive = this.isAlive() && this.bc != null && !this.bc.battleEnded;
        if (isActive) {
            this.getBattleAbility().applyRepeatedEffect(this);
        }
        HeldItem usableItem = this.getUsableHeldItem();
        if (isActive && this.isAlive()) {
            usableItem.applyRepeatedEffect(this);
        }
        for (int i = 0; i < this.getStatusSize(); ++i) {
            StatusBase s = this.getStatus(i);
            try {
                if (this.bc == null || this.bc.battleEnded || !this.isAlive() && !s.isTeamStatus()) continue;
                int beforeSize = this.getStatusSize();
                s.applyRepeatedEffect(this);
                if (beforeSize <= this.getStatusSize()) continue;
                --i;
                continue;
            }
            catch (Exception e) {
                this.bc.battleLog.onCrash(e, "Error calculating applyRepeatedEffect() for " + s.type.toString());
            }
        }
        if (isActive && this.isAlive()) {
            usableItem.applyRepeatedEffectAfterStatus(this);
            this.getBattleAbility().applyRepeatedEffectAfterStatus(this);
        }
        this.faintedAtEndOfTurn = isActive && !this.isAlive();
    }

    public void endTurn() {
        boolean resetProtect;
        this.returnToBasePos();
        this.damageTakenThisTurn = 0;
        boolean bl = resetProtect = this.attack == null;
        if (!resetProtect) {
            resetProtect = true;
            for (EffectBase e : this.attack.getMove().effects) {
                if (!(e instanceof ProtectVariation)) continue;
                resetProtect = false;
                break;
            }
        }
        if (resetProtect) {
            this.protectsInARow = 0;
        }
        this.switchedLastTurn = this.switchedThisTurn;
        this.switchedThisTurn = false;
        this.evolvedThisTurn = false;
        this.lastDirectDamage = -1;
        this.lastHP = -1;
        this.beginingOfTurnHP = this.getHealth();
    }

    public BattleParticipant getParticipant() {
        return this.participant;
    }

    public PixelmonWrapper doSwitch() {
        if (!this.bc.simulateMode) {
            this.isSwitching = false;
            this.canAttack = false;
            if (this.isDynamax > 0) {
                this.dynamax(true, this.getHealthPercent());
            }
            if (this.isFainted()) {
                this.resetBattleEvolution();
                if (this.isMega) {
                    this.isMega = false;
                }
            } else {
                if (this.participant.getPokemonFromUUID(this.newPokemonUUID) != null) {
                    this.bc.sendToAll("battlecontroller.!escaped", this.getRealNickname());
                    return null;
                }
                if (this.pokemon.getSpecies().is(PixelmonSpecies.MELOETTA)) {
                    this.resetBattleEvolution();
                }
            }
        }
        ArrayList<StatusBase> statusCopy = new ArrayList<StatusBase>();
        boolean batonPassing = false;
        boolean shedTailing = false;
        BattleStats tempStats = new BattleStats(this);
        boolean wasSimulateMode = this.bc.simulateMode;
        this.bc.simulateMode = false;
        tempStats.copyStats(this.getBattleStats());
        this.bc.simulateMode = wasSimulateMode;
        if (this.nextSwitchIsMove && this.attack != null) {
            if (this.attack.isAttack(AttackRegistry.BATON_PASS)) {
                batonPassing = true;
            } else if (this.attack.isAttack(AttackRegistry.SHED_TAIL)) {
                shedTailing = true;
            }
        }
        if (!this.bc.simulateMode) {
            for (int i = 0; i < this.getStatusSize(); ++i) {
                try {
                    StatusBase status = this.getStatus(i);
                    if (status.isTeamStatus() || batonPassing && BatonPass.isBatonPassable(status) || shedTailing && status instanceof Substitute) {
                        statusCopy.add(status);
                        continue;
                    }
                    if (StatusType.isPrimaryStatus(status.type)) continue;
                    this.removeStatus(status, false);
                    --i;
                    continue;
                }
                catch (Exception e2) {
                    this.bc.battleLog.onCrash(e2, "Error in doSwitch().");
                }
            }
        }
        UUID oldUUID = this.getPokemonUUID();
        if (!this.bc.simulateMode) {
            this.update(EnumUpdateType.Status);
        }
        if (this.newPokemonUUID == null) {
            return null;
        }
        PixelmonWrapper newPokemon = this.participant.switchPokemon(this, this.newPokemonUUID);
        this.newPokemonUUID = null;
        if (newPokemon == null) {
            return null;
        }
        if (newPokemon.entity != null) {
            newPokemon.entity.m_21153_(newPokemon.getHealth());
            newPokemon.entity.battleController = this.bc;
        }
        newPokemon.battlePosition = this.battlePosition;
        newPokemon.switchedThisTurn = true;
        newPokemon.takenTurn = true;
        if (!this.bc.simulateMode) {
            newPokemon.onBattlefield = true;
            this.onBattlefield = false;
            this.hasBeenInBattle = true;
            newPokemon.isDynamax = 0;
            newPokemon.dynamaxTurns = 0;
            if (newPokemon.entity != null) {
                newPokemon.entity.dynamaxAnimationTicks = 0;
            }
        }
        if (newPokemon.getPokemonUUID().equals(this.participant.evolution)) {
            if (newPokemon.getPrevForm() != null && newPokemon.getPrevForm().getMegaForm(newPokemon.getHeldItem()).isPresent()) {
                newPokemon.setForm(newPokemon.getPrevForm().getMegaForm(newPokemon.getHeldItem()).get());
                newPokemon.isMega = true;
                newPokemon.setTempAbility(newPokemon.getForm().getAbilities().getRandomAbility());
            } else {
                newPokemon.setForm(newPokemon.getForm());
            }
        }
        if (!this.bc.simulateMode) {
            this.bc.sendSwitchPacket(oldUUID, newPokemon);
        }
        if (batonPassing) {
            this.bc.simulateMode = false;
            newPokemon.getBattleStats().copyStats(tempStats);
            this.bc.simulateMode = wasSimulateMode;
        }
        if (this.attack != null && this.attack.moveResult != null && !this.bc.simulateMode && (this.attack.moveResult.result == AttackResult.succeeded || this.attack.moveResult.result == AttackResult.proceed) && this.usingZ && this.attack.isAttack(AttackRegistry.MEMENTO, AttackRegistry.PARTING_SHOT)) {
            newPokemon.healByPercent(100.0f);
        }
        if (!statusCopy.isEmpty()) {
            for (StatusBase statusBase : statusCopy) {
                newPokemon.addStatus(statusBase, newPokemon);
            }
            ArrayList<StatusBase> entryHazards = new ArrayList<StatusBase>();
            for (StatusBase e : statusCopy) {
                if (!(e instanceof EntryHazard)) {
                    e.applyEffectOnSwitch(newPokemon);
                    continue;
                }
                entryHazards.add(e);
            }
            for (StatusBase e : entryHazards) {
                e.applyEffectOnSwitch(newPokemon);
            }
        }
        for (GlobalStatusBase globalStatusBase : this.bc.globalStatusController.getGlobalStatuses()) {
            globalStatusBase.applyEffectOnSwitch(newPokemon);
        }
        newPokemon.afterSwitch(this);
        if (!this.bc.simulateMode) {
            this.bc.getOpponentPokemon(this.participant).stream().filter(pw -> pw.targets.contains(this)).forEach(pw -> {
                pw.targets.remove(this);
                pw.targets.add(newPokemon);
            });
            this.bc.getTeamPokemon(this.participant).stream().filter(pw -> pw != this).filter(pw -> pw.targets.contains(this)).forEach(pw -> {
                pw.targets.remove(this);
                pw.targets.add(newPokemon);
            });
            newPokemon.addAttackers();
            this.bc.participants.stream().filter(p2 -> p2.team != this.participant.team).forEach(BattleParticipant::updateOtherPokemon);
            this.getParticipant().onSwitchIn(this.bc, this);
        }
        return newPokemon;
    }

    public void beforeSwitch(PixelmonWrapper switchingIn) {
        if (!this.bc.simulateMode) {
            this.getBattleStats().clearBattleStats();
            switchingIn.getBattleAbility().applySwitchReplaceEffect(switchingIn, this);
            if (this.isAlive()) {
                this.getBattleAbility().applySwitchOutEffect(this);
            }
            for (int i = 0; i < this.getStatusSize(); ++i) {
                StatusBase status = this.getStatus(i);
                if (!this.isAlive() && !status.isTeamStatus()) continue;
                status.applySwitchOutEffect(this, switchingIn);
            }
            this.getUsableHeldItem().applySwitchOutEffect(this);
            this.resetOnSwitch();
        }
    }

    public void afterSwitch() {
        this.afterSwitch(null);
    }

    public void afterSwitch(PixelmonWrapper oldPokemon) {
        if (!this.bc.simulateMode) {
            if (this.bc.duringSwitchAction()) {
                this.bc.storeSwitchInActivation(this, oldPokemon);
                return;
            }
            if (this.bc.oldGen.isYes()) {
                this.checkPrimalReversion();
            }
            if (this.tempAbility == null) {
                this.getBattleAbility().applySwitchInEffect(this);
            }
            for (PixelmonWrapper pw : this.getTeamPokemonExcludeSelf()) {
                pw.getBattleAbility().applyAllySwitchInEffect(pw, this);
            }
            for (PixelmonWrapper pw : this.getOpponentPokemon()) {
                pw.getBattleAbility().applyFoeSwitchInEffect(pw, this, oldPokemon);
            }
            this.getUsableHeldItem().applySwitchInEffect(this);
            if (this.participant.getType() == ParticipantType.Player && this.getSpecies().is(PixelmonSpecies.BURMY)) {
                this.changeBurmy = true;
            }
            this.hasBeenInBattle = true;
            this.checkSkyBattleDisable();
        }
    }

    private void checkPrimalReversion() {
        if ((this.getSpecies().is(PixelmonSpecies.KYOGRE) && this.getHeldItem() == PixelmonItems.blue_orb || this.getSpecies().is(PixelmonSpecies.GROUDON) && this.getHeldItem() == PixelmonItems.red_orb) && !this.getForm().isForm("primal")) {
            this.setForm("primal");
            this.setTempAbility(this.getForm().getAbilities().getRandomAbility());
            this.bc.sendToAll("pixelmon.battletext.primalreversion", this.getNickname());
        }
    }

    private void checkSkyBattleDisable() {
        for (Attack move : this.getMoveset()) {
            if (move == null || move.checkSkyBattle(this.bc)) continue;
            move.setDisabled(true, this);
        }
    }

    public boolean switchThisTurn() {
        if (this.isSwitching) {
            if (!BattleParticipant.canSwitch(this)[0]) {
                return false;
            }
            this.forcePursuitAttackers();
            this.bc.battleLog.logEvent(new SwitchAction(this.bc.battleTurn, this, this.findPixelmon(this.newPokemonUUID)));
            this.doSwitch();
            return true;
        }
        return false;
    }

    protected PixelmonWrapper findPixelmon(UUID uuid) {
        for (BattleParticipant battleParticipant : this.bc.participants) {
            for (PixelmonWrapper pixelmonWrapper : battleParticipant.allPokemon) {
                if (!Objects.equals(pixelmonWrapper.getPokemonUUID(), uuid)) continue;
                return pixelmonWrapper;
            }
        }
        return null;
    }

    public void forcePursuitAttackers() {
        for (PixelmonWrapper pw : this.bc.getDefaultTurnOrder()) {
            if (!this.isAlive()) {
                return;
            }
            if (pw.isAlly(this) || pw.hasMoved() || pw.attack == null || !pw.attack.isAttack(AttackRegistry.PURSUIT) || !pw.attack.canReachTarget(pw, this)) continue;
            if (pw.willEvolve) {
                pw.megaEvolve();
            }
            pw.targets.clear();
            pw.targets.add(this);
            pw.addStatus(new InPursuit(), pw);
            pw.takeTurn();
        }
    }

    public void takeTurn() {
        block19: {
            block21: {
                block20: {
                    block18: {
                        this.takenTurn = true;
                        if (this.willUseItemInStack == null) break block18;
                        this.useItem();
                        break block19;
                    }
                    this.canAttack = this.canAttackThisTurn(this.attack);
                    if (!this.canAttack) break block20;
                    this.participant.bc.clearHurtTimer();
                    this.getUsableHeldItem().onAttackUsed(this, this.attack);
                    for (int i = 0; i < this.status.size(); ++i) {
                        StatusBase statusBase = this.status.get(i);
                        int initialSize = this.status.size();
                        statusBase.onAttackUsed(this, this.attack);
                        if (initialSize <= this.status.size()) continue;
                        --i;
                    }
                    if (this.attack != null) {
                        if (this.usingZ && this.attack.getAttackCategory() == AttackCategory.STATUS && this.attack.getMove().getZMove(this.pokemon, false) != null) {
                            this.usingZPower = true;
                            for (EffectBase effectBase : this.attack.getMove().getZMove((Pokemon)this.pokemon, (boolean)false).effects) {
                                try {
                                    if (effectBase instanceof StatsEffect) {
                                        ((StatsEffect)effectBase).applyStatEffect(this, this, this.attack.getMove());
                                        continue;
                                    }
                                    if (effectBase instanceof SpecialAttackBase) {
                                        if (effectBase.applyEffectStart(this, this) != AttackResult.proceed) continue;
                                        ((SpecialAttackBase)effectBase).applyEffectDuring(this, this);
                                        continue;
                                    }
                                    if (!(effectBase instanceof StatusBase)) continue;
                                    effectBase.applyEffect(this, this);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            this.usingZPower = false;
                        }
                        if (!(this.participant instanceof RaidPixelmonParticipant)) {
                            if (this.isDynamax == 1) {
                                this.attack = MaxMoveConverter.getMaxMoveFromAttack(this.attack, this);
                            } else if (this.isDynamax == 2) {
                                this.attack = MaxMoveConverter.getGMaxMoveFromAttack(this.attack, this, this.getSpecies(), this.getForm().getName().contains("gmax") ? this.getPrevForm() : this.getForm());
                            }
                        }
                    }
                    if (this.attack == null) break block21;
                    boolean shouldContinue = true;
                    for (BattleParticipant bp : this.bc.participants) {
                        if (!bp.onUseAttackOther(this.bc, this.attack, this.participant, this)) continue;
                        shouldContinue = false;
                        --this.attack.pp;
                        this.setTemporaryMoveset(this.temporaryMoveset);
                        break;
                    }
                    if (!shouldContinue || this.participant.onUseAttack(this.bc, this)) break block21;
                    this.useAttack();
                    break block21;
                }
                if (this.attack != null && this.hasStatus(StatusType.MultiTurn)) {
                    for (EffectBase effectBase : this.attack.getMove().effects) {
                        if (!(effectBase instanceof MultiTurnSpecialAttackBase)) continue;
                        ((MultiTurnSpecialAttackBase)effectBase).removeEffect(this, this);
                    }
                }
            }
            this.isTempAttack = false;
            for (StatusBase statusBase : new ArrayList<StatusBase>(this.status)) {
                statusBase.onEndOfTurn(this);
            }
            for (PixelmonWrapper pixelmonWrapper : this.targets) {
                for (StatusBase status : new ArrayList<StatusBase>(pixelmonWrapper.status)) {
                    status.onEndOfAttackersTurn(pixelmonWrapper, this);
                }
            }
        }
    }

    public boolean dynamax(boolean revert, float healthPercentage) {
        int currentHP = this.getHealth();
        if (revert) {
            if (this.isDynamax > 0) {
                if (this.isDynamax == 2) {
                    this.setForm(this.prevForm);
                    this.setPalette(this.prevPaletteName);
                    this.setForm(this.getPrevForm());
                }
                boolean gigantamax = this.isGigantamax();
                this.isDynamax = -1;
                if (this.entity != null) {
                    this.entity.setDynamaxed(true);
                    this.entity.dynamaxAnimationTicks = -50;
                }
                if (!this.getSpecies().is(PixelmonSpecies.SHEDINJA)) {
                    this.updateHPIncrease();
                    int newHP = (int)Math.ceil((double)this.getMaxHealth() * ((double)healthPercentage / 100.0));
                    this.setHealth(newHP);
                    this.updateBattleDamage(currentHP - newHP);
                }
                if (this.participant.getType() == ParticipantType.Player) {
                    PlayerParticipant player = (PlayerParticipant)this.participant;
                    NetworkHelper.sendPacket(new DynamaxPacket(UUID.randomUUID(), false), player.player);
                }
                this.bc.updateFormChange(this);
                this.bc.battleLog.logEvent(new ExitDynamaxAction(this.bc.battleTurn, this, gigantamax));
                if (!this.bc.battleEnded) {
                    String nickname = this.getNickname();
                    this.bc.sendToAll("pixelmon.battletext.dynamaxlost", nickname, this.participant.getDisplayName());
                }
            }
        } else if (!this.bc.battleEnded) {
            this.dynamaxTurns = 3;
            if (this.entity != null) {
                this.entity.setDynamaxed(true);
                this.entity.dynamaxAnimationTicks = 50;
            }
            this.participant.dynamax = this.getPokemonUUID();
            if (!this.getSpecies().is(PixelmonSpecies.SHEDINJA)) {
                this.updateHPIncrease();
                int newHP = (int)Math.ceil((double)this.getMaxHealth() * ((double)healthPercentage / 100.0));
                this.setHealth(newHP);
                this.updateBattleDamage(currentHP - newHP);
            }
            String nickname = this.getNickname();
            if (this.participant.getType() == ParticipantType.Player) {
                PlayerParticipant player = (PlayerParticipant)this.participant;
                NetworkHelper.sendPacket(new DynamaxPacket(this.getPokemonUUID(), this.isDynamax == 2), player.player);
            }
            this.bc.updateFormChange(this);
            this.bc.battleLog.logEvent(new EnterDynamaxAction(this.bc.battleTurn, this, this.isGigantamax()));
            this.bc.sendToAll("pixelmon.battletext.dynamax", nickname, this.participant.getDisplayName());
        }
        return false;
    }

    public boolean megaEvolve() {
        if (this.bc.simulateMode) {
            return false;
        }
        this.willEvolve = false;
        if (this.bc.oldGen.isYes() && (this.canMegaEvolve() || this.canUltraBurst()) && this.participant.canMegaEvolve()) {
            if (this.participant.ultraBurst == null && this.getSpecies().is(PixelmonSpecies.NECROZMA)) {
                if (Pixelmon.EVENT_BUS.post((Event)new MegaEvolutionEvent.Battle(this.getPlayerOwner(), this, null, true))) {
                    return false;
                }
                this.participant.ultraBurst = this.getPokemonUUID();
                this.bc.sendToAll("pixelmon.battletext.necrozmaultrareact", this.participant.getDisplayName());
                this.participant.wait = true;
                this.pokemon.getPersistentData().m_128359_("SrcForm", this.pokemon.getForm().getName());
                this.evolution = new EvolutionQuery(this.pokemon, this.pokemon.getSpecies().getForm("ultra"));
                this.tempAbility = null;
                this.setForm("ultra");
                this.bc.battleLog.logEvent(new UltraBurstAction(this.bc.battleTurn, this));
                if (this.participant.getType() == ParticipantType.Player) {
                    PlayerParticipant player = (PlayerParticipant)this.participant;
                    NetworkHelper.sendPacket(new MegaEvolvePacket(this.getPokemonUUID(), true), player.player);
                } else if (this.bc.isFrozen()) {
                    this.participant.wait = false;
                }
                this.bc.updateFormChange(this.entity);
                this.evolvedThisTurn = true;
                return true;
            }
            boolean isRayquaza = this.pokemon.isPokemon(PixelmonSpecies.RAYQUAZA.getValueUnsafe());
            if (this.canMegaEvolve() && this.participant.evolution == null && (this.participant.canMegaEvolve() || isRayquaza)) {
                Stats form = this.getForm().getMegaForm(this.getHeldItem()).orElse(null);
                if (isRayquaza && form == null) {
                    form = this.getForm().getMegaForms().get(0);
                }
                if (form != null) {
                    if (Pixelmon.EVENT_BUS.post((Event)new MegaEvolutionEvent.Battle(this.getPlayerOwner(), this, this.pokemon.getHeldItem(), false))) {
                        return false;
                    }
                    this.isMega = true;
                    this.participant.evolution = this.getPokemonUUID();
                    String nickname = this.getNickname();
                    if (isRayquaza) {
                        this.bc.sendToAll("pixelmon.battletext.rayquazamegareact", this.participant.getDisplayName());
                    } else {
                        this.bc.sendToAll("pixelmon.battletext.megareact", nickname, this.getHeldItem().getLocalizedName(), this.participant.getDisplayName());
                    }
                    this.participant.wait = true;
                    this.evolution = new EvolutionQuery(this.pokemon, form);
                    this.tempAbility = null;
                    this.setPrevForm(this.getForm());
                    this.setForm(form);
                    this.setTempAbility(form.getAbilities().getRandomAbility(), true);
                    this.bc.battleLog.logEvent(new MegaEvolveAction(this.bc.battleTurn, this, form.getName()));
                    if (this.participant.getType() == ParticipantType.Player) {
                        PlayerParticipant player = (PlayerParticipant)this.participant;
                        NetworkHelper.sendPacket(new MegaEvolvePacket(this.getPokemonUUID(), false), player.player);
                    } else if (this.bc.isFrozen()) {
                        this.participant.wait = false;
                    }
                    this.bc.updateFormChange(this);
                    this.evolvedThisTurn = true;
                    return true;
                }
            }
        } else if (this.participant.dynamax == null && this.participant.canDynamax()) {
            boolean gigantamax = this.canGigantamax();
            boolean dynamax = this.canDynamax();
            if (gigantamax || dynamax) {
                if (Pixelmon.EVENT_BUS.post((Event)new DynamaxEvent.BattleEvolve(this, gigantamax))) {
                    return false;
                }
                this.getBattleAbility().applyDynamaxEffect(this);
                if (gigantamax || this.canUltraBurst()) {
                    this.setPrevPaletteName(this.pokemon.getPalette().getName());
                    this.setPrevForm(this.getForm());
                    this.setForm(this.getForm().getGigantamaxForm().orElse(this.getForm()));
                }
                float healthPercentage = this.getHealthPercent();
                this.isDynamax = gigantamax ? 2 : 1;
                this.dynamax(false, healthPercentage);
                this.evolvedThisTurn = true;
                return true;
            }
        }
        return false;
    }

    public boolean canAttackThisTurn(Attack a) {
        if (this.getBattleAbility().canAttackThisTurn(this, a)) {
            for (StatusBase e : new ArrayList<StatusBase>(this.status)) {
                try {
                    if (e instanceof StatusPersist || e.canAttackThisTurn(this, a)) continue;
                    return false;
                }
                catch (Exception exc) {
                    this.bc.battleLog.onCrash(exc, "Error calculating canAttackThisTurn for " + e.type.toString());
                }
            }
            for (StatusBase e : new ArrayList<StatusBase>(this.status)) {
                try {
                    if (!(e instanceof StatusPersist) || e.canAttackThisTurn(this, a)) continue;
                    return false;
                }
                catch (Exception exc) {
                    this.bc.battleLog.onCrash(exc, "Error calculating canAttackThisTurn for " + e.type.toString());
                }
            }
            return true;
        }
        return false;
    }

    public void setAttack(int buttonId, List<PixelmonWrapper> targets, boolean megaEvolving) {
        Attack attack = this.getMoveset().get(buttonId >= 4 ? buttonId - 4 : buttonId);
        this.usingZ = buttonId >= 4 && !this.participant.usedZ && attack.getMove().hasZMove(this.pokemon) && this.participant.canMegaEvolve() ? this.participant.bc.oldGen.isYes() : false;
        this.setAttack(attack, targets, megaEvolving);
    }

    public void setAttack(Attack attack, List<PixelmonWrapper> targets, boolean megaEvolving) {
        this.attack = attack;
        this.targets = targets;
        if (!this.bc.simulateMode) {
            this.wait = false;
            this.willEvolve = megaEvolving;
            this.bc.battleLog.logEvent(new SelectAttackAction(this.bc.battleTurn, this, attack, targets, megaEvolving));
        }
    }

    public boolean isFainted() {
        return this.getHealth() <= 0;
    }

    public boolean isAlive() {
        return !this.isFainted();
    }

    public void setStruggle(ArrayList<PixelmonWrapper> targets) {
        this.setAttack(new Attack(AttackRegistry.STRUGGLE), targets, false);
    }

    public void returnToBasePos() {
        if (this.basePos != null && this.entity != null) {
            this.entity.m_7678_(this.basePos[0], this.basePos[1], this.basePos[2], this.participant.team == 0 ? 270.0f : 90.0f, 0.0f);
            this.entity.f_19859_ = this.entity.f_19857_;
        }
    }

    public void setBasePosition(double[] ds) {
        if (this.entity != null) {
            this.basePos = ds;
            this.entity.m_7678_(ds[0], ds[1], ds[2], 0.0f, 0.0f);
        }
    }

    public void setTempType(Element newType) {
        this.setTempType(newType.makeTypeList());
    }

    public void setTempType(List<Element> newType) {
        if (!this.bc.simulateMode) {
            if (this.initialType == null) {
                this.initialType = this.type;
            }
            List<Element> oldTypes = this.type;
            this.type = newType;
            this.bc.battleLog.logEvent(new ChangeTypeAction(this.bc.battleTurn, this, this.type, oldTypes));
        }
    }

    public void setTempAbility(Ability newAbility) {
        this.setTempAbility(newAbility, false);
    }

    public void setTempAbility(Ability newAbility, boolean formChange) {
        if (!this.bc.simulateMode) {
            this.getBattleAbility().onAbilityLost(this);
            if (newAbility.needNewInstance()) {
                newAbility = newAbility.getNewInstance();
            }
            this.tempAbility = newAbility;
            this.bc.battleLog.logEvent(new ChangeAbilityAction(this.bc.battleTurn, this, this.pokemon.getAbility(), this.tempAbility));
            Ability pokemonAbility = this.getBattleAbility();
            if ((formChange || !(pokemonAbility instanceof Trace) && !(pokemonAbility instanceof Imposter)) && !this.bc.duringSwitchAction()) {
                pokemonAbility.applySwitchInEffect(this);
            }
        }
    }

    public void resetOnSwitch() {
        int i;
        if (this.bc != null && this.bc.simulateMode) {
            return;
        }
        this.lastAttack = null;
        this.lastTempAttack = null;
        this.lastSimulatedAttack = null;
        this.lastTargets = null;
        this.lastSimulatedTargets = null;
        this.protectsInARow = 0;
        if (this.initialType != null) {
            this.type = this.initialType;
            this.initialType = null;
        }
        this.tempAbility = null;
        Moveset moveset = this.getMoveset();
        for (i = 0; i < moveset.size(); ++i) {
            if (moveset.get(i) == null) continue;
            moveset.get(i).setDisabled(false, this, true);
        }
        this.usedMoves.clear();
        this.escapeAttempts = 0;
        this.damageTakenThisTurn = 0;
        this.nextSwitchIsMove = false;
        this.wait = false;
        this.isSwitching = false;
        this.choiceLocked = null;
        this.inMultipleHit = false;
        this.inParentalBond = false;
        for (i = 0; i < this.status.size(); ++i) {
            if (this.status.get((int)i).type.isPrimaryStatus()) continue;
            this.status.remove(i--);
        }
        this.battleStats.clearBattleStats();
    }

    public float getWeight(boolean ignoreAbility) {
        float weight = this.getForm().getWeight();
        if (!ignoreAbility) {
            weight = this.getBattleAbility().modifyWeight(weight);
        }
        weight = this.getUsableHeldItem().modifyWeight(weight);
        for (StatusBase status : this.getStatuses()) {
            weight = status.modifyWeight(weight);
        }
        return weight;
    }

    public void consumeItem() {
        HeldItem item = this.getHeldItem();
        this.setConsumedItem(item);
        this.removeHeldItem();
        this.bc.getActiveUnfaintedPokemon().forEach(pw -> pw.getBattleAbility().onItemConsumed((PixelmonWrapper)pw, this, item));
    }

    public void setConsumedItem(HeldItem heldItem) {
        if (!this.bc.simulateMode) {
            this.consumedHeldItem = heldItem == null ? PixelmonItems.no_item : heldItem;
        }
    }

    public HeldItem getConsumedItem() {
        return this.consumedHeldItem;
    }

    public void setNewHeldItem(HeldItem heldItem) {
        this.setHeldItem(heldItem);
        this.getUsableHeldItem().applySwitchInEffect(this);
    }

    public boolean isGrounded() {
        return this.hasStatus(StatusType.SmackedDown) || this.bc.globalStatusController.hasStatus(StatusType.Gravity) || this.getUsableHeldItem().getHeldItemType() == EnumHeldItems.ironBall;
    }

    public boolean isAirborne() {
        return !this.isGrounded() && (this.hasType(Element.FLYING) || this.getBattleAbility() instanceof Levitate || this.hasStatus(StatusType.MagnetRise, StatusType.Telekinesis) || this.getUsableHeldItem().getHeldItemType() == EnumHeldItems.airBalloon);
    }

    public boolean addTeamStatus(StatusBase status, PixelmonWrapper cause) {
        boolean succeeded = false;
        for (PixelmonWrapper pw : this.getTeamPokemon()) {
            succeeded = pw.addStatus(status.copy(), cause) || succeeded;
        }
        return succeeded;
    }

    public boolean removeTeamStatus(StatusBase status) {
        return this.removeTeamStatus(status.type);
    }

    public boolean removeTeamStatus(StatusType ... statuses) {
        boolean hadStatus = false;
        for (StatusType status : statuses) {
            for (PixelmonWrapper pw : this.getTeamPokemon()) {
                hadStatus = pw.removeStatus(status) || hadStatus;
            }
        }
        return hadStatus;
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon() {
        return this.bc.getTeamPokemon(this);
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonExcludeSelf() {
        return this.bc.getTeamPokemonExcludeSelf(this);
    }

    public ArrayList<PixelmonWrapper> getOpponentPokemon() {
        return this.bc.getOpponentPokemon(this);
    }

    public boolean isAlly(PixelmonWrapper pokemon) {
        return this.getTeamPokemon().contains(pokemon);
    }

    public boolean isOpponent(PixelmonWrapper pokemon) {
        return this.getOpponentPokemon().contains(pokemon);
    }

    public int getControlledIndex() {
        return this.participant.controlledPokemon.indexOf(this);
    }

    public BattleAIBase getBattleAI() {
        return this.getParticipant().getBattleAI();
    }

    public void setUpSwitchMove() {
        this.wait = true;
        this.nextSwitchIsMove = true;
        this.canAttack = false;
        this.bc.removeFromTurnList(this);
    }

    public void forceRandomSwitch(UUID switchPokemon) {
        this.setUpSwitchMove();
        this.bc.switchPokemon(this.getPokemonUUID(), switchPokemon, true);
    }

    public boolean isImmuneToPowder() {
        if (this.hasType(Element.GRASS) || this.getBattleAbility() instanceof Overcoat) {
            return true;
        }
        HeldItem item = this.getHeldItem();
        return item.getHeldItemType() == EnumHeldItems.safetyGoggles;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getPokemonName()).append("[");
        builder.append("health=").append(this.getHealth()).append(", ").append(", max health=").append(this.getMaxHealth()).append(", ").append(", escape attempts=").append(this.escapeAttempts).append(", damage taken this turn=").append(this.damageTakenThisTurn).append(", priority=").append(this.priority).append(", can attack=").append(this.canAttack).append(", will try flee=").append(this.willTryFlee).append(", switching=").append(this.isSwitching).append(", evolve=").append(this.willEvolve).append(", status=").append(this.status.stream().map(Object::toString).collect(Collectors.joining(", "))).append(", held item=").append((Object)this.getUsableHeldItem()).append(", moveset=").append(this.getMoveset().toString());
        return builder.append("]").toString();
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof PixelmonWrapper) {
            PixelmonWrapper otherPW = (PixelmonWrapper)other;
            return this.getPokemonUUID().equals(otherPW.getPokemonUUID());
        }
        return false;
    }

    public void setMoved(boolean moved) {
        this.takenTurn = moved;
    }

    public boolean hasMoved() {
        return this.takenTurn;
    }

    public boolean isFirstTurn() {
        return this.bc.battleTurn == 0 || this.switchedThisTurn || this.switchedLastTurn;
    }

    public boolean isMovingLast() {
        return this.bc.turnList.indexOf(this) == this.bc.turnList.size() - 1;
    }

    public boolean isSameTeam(PixelmonWrapper other) {
        return this.getParticipant().team == other.getParticipant().team;
    }

    public Moveset getMoveset() {
        return this.temporaryMoveset == null ? this.pokemon.getMoveset() : this.temporaryMoveset;
    }

    public void setTemporaryMoveset(Moveset moveset) {
        this.temporaryMoveset = moveset;
        if (this.participant instanceof PlayerParticipant) {
            ServerPlayer player = ((PlayerParticipant)this.participant).player;
            NetworkHelper.sendPacket(new UpdateMovesetPacket(this), player);
        }
    }

    public boolean removeStatus(StatusType s) {
        for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            if (base.type != s) continue;
            this.removeStatus(base);
            return true;
        }
        return false;
    }

    public boolean removeStatus(StatusType s, boolean message) {
        for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            if (base.type != s) continue;
            this.removeStatus(base, message);
            return true;
        }
        return false;
    }

    public boolean removeStatuses(StatusType ... statuses) {
        return this.removeStatuses(true, statuses);
    }

    public boolean removeStatuses(boolean showMessage, StatusType ... statuses) {
        boolean wasRemoved = false;
        block0: for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            for (StatusType type : statuses) {
                if (base.type != type) continue;
                int beforeSize = this.status.size();
                this.removeStatus(base, showMessage);
                if (this.status.size() < beforeSize) {
                    --i;
                }
                wasRemoved = true;
                continue block0;
            }
        }
        return wasRemoved;
    }

    public void removeStatus(int i) {
        this.removeStatus(this.status.get(i));
    }

    public StatusBase getStatus(StatusType type) {
        for (StatusBase base : this.status) {
            if (base.type != type) continue;
            return base;
        }
        return null;
    }

    public boolean hasStatus(StatusType ... statuses) {
        for (StatusType current : statuses) {
            if (current == StatusType.Sleep && this.getBattleAbility().isAbility((Class<? extends Ability>)Comatose.class)) {
                return true;
            }
            for (StatusBase base : this.status) {
                if (base.type != current) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyStatusPreventingAttack(PixelmonWrapper attacker) {
        for (StatusBase status : this.getStatuses()) {
            if (!status.stopsIncomingAttack(this, attacker)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonVolatileStatus() {
        return this.hasNonVolatileStatus(true);
    }

    public boolean hasNonVolatileStatus(boolean includeComatose) {
        return this.hasStatus(StatusType.Poison, StatusType.Burn, StatusType.PoisonBadly, StatusType.Freeze, StatusType.Sleep, StatusType.Paralysis, StatusType.Frostbite, StatusType.Drowsy) || includeComatose && this.getBattleAbility().isAbility((Class<? extends Ability>)Comatose.class);
    }

    public int countStatuses(StatusType ... statuses) {
        int count = 0;
        for (StatusBase base : this.status) {
            for (StatusType current : statuses) {
                if (base.type != current) continue;
                ++count;
            }
        }
        return count;
    }

    public int getStatusSize() {
        return this.status.size();
    }

    public List<StatusBase> getStatuses() {
        return this.status;
    }

    public StatusBase getStatus(int i) {
        return this.status.get(i);
    }

    public int getStatusIndex(StatusType findStatus) {
        for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            if (base.type != findStatus) continue;
            return i;
        }
        return -1;
    }

    public StatusPersist getPrimaryStatus() {
        for (StatusBase s : this.status) {
            if (!(s instanceof StatusPersist)) continue;
            return (StatusPersist)s;
        }
        return NoStatus.noStatus;
    }

    public void setStatus(int i, StatusBase newStatus) {
        this.status.set(i, newStatus);
    }

    public void clearStatus() {
        if (this.bc.simulateMode) {
            return;
        }
        if (this.hasNonVolatileStatus(false) && this.entity != null) {
            this.sendStatusPacket(-1);
        }
        this.status.clear();
    }

    public boolean addStatus(StatusBase e, PixelmonWrapper opponent) {
        return this.addStatus(e, opponent, null);
    }

    public boolean addStatus(StatusBase e, PixelmonWrapper opponent, MutableComponent message) {
        if (this.cannotHaveStatus(e, opponent)) {
            return false;
        }
        if (this.participant.onAddStatus(this.bc, opponent, this, e)) {
            return true;
        }
        e.applyBeforeEffect(this, opponent);
        if (!this.bc.isSimulation()) {
            e.turnGained = this.bc.actionIndex;
            e.battleTurnGained = this.bc.battleTurn;
            this.status.add(e);
            this.bc.battleLog.logEvent(new StatusAddAction(this.bc.battleTurn, this, e));
        }
        if (this.bc.sendMessages) {
            if (message != null) {
                this.bc.sendToAll((Component)message);
            }
            if (!this.bc.simulateMode && e.type.isPrimaryStatus()) {
                this.sendStatusPacket(e.type.ordinal());
            }
            this.getUsableHeldItem().onStatusAdded(this, opponent, e);
            this.getBattleAbility().onStatusAdded(e, this, opponent);
            if (!this.bc.simulateMode) {
                if (this.getPlayerOwner() != null && e.type.isPrimaryStatus()) {
                    this.update(EnumUpdateType.Status);
                }
                this.bc.updatePokemonHealth();
            }
        }
        return true;
    }

    public void sendStatusPacket(int statusID) {
        if (this.bc != null && !this.bc.simulateMode) {
            this.bc.participants.stream().filter(p -> p.getType() == ParticipantType.Player).forEach(p -> NetworkHelper.sendPacket(new StatusUpdateTask(this.getPokemonUUID(), statusID), ((PlayerParticipant)p).player));
            this.bc.spectators.forEach(spectator -> spectator.sendMessage(new StatusUpdateTask(this.getPokemonUUID(), statusID)));
        }
    }

    public void removeStatus(StatusBase e) {
        this.removeStatus(e, true);
    }

    public void removeStatus(StatusBase e, boolean showMessage) {
        if (this.bc.simulateMode) {
            return;
        }
        boolean removed = this.status.remove(e);
        if (removed) {
            this.bc.battleLog.logEvent(new StatusRemoveAction(this.bc.battleTurn, this, e));
        }
        if (removed && showMessage) {
            String message;
            String string = message = this.eatingBerry ? e.getCureMessageItem() : e.getCureMessage();
            if (!message.isEmpty()) {
                String nickname = this.getNickname();
                if (this.eatingBerry) {
                    this.bc.sendToAll(message, nickname, this.getHeldItem().getLocalizedName());
                } else {
                    this.bc.sendToAll(message, nickname);
                }
            }
        }
        if (e.type.isPrimaryStatus()) {
            this.sendStatusPacket(-1);
            this.update(EnumUpdateType.Status);
        }
        this.bc.updatePokemonHealth();
    }

    public StatusBase removePrimaryStatus() {
        return this.removePrimaryStatus(true);
    }

    public StatusBase removePrimaryStatus(boolean showMessage) {
        try {
            for (StatusBase base : this.status) {
                if (!StatusType.isPrimaryStatus(base.type)) continue;
                this.removeStatus(base, showMessage);
                return base;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean cannotHaveStatus(StatusBase t, PixelmonWrapper opponent) {
        return this.cannotHaveStatus(t, opponent, false);
    }

    public boolean cannotHaveStatus(StatusBase t, PixelmonWrapper opponent, boolean ignorePrimaryOverlap) {
        StatusType type = t.type;
        if (StatusType.isPrimaryStatus(type) && this.hasNonVolatileStatus() && !ignorePrimaryOverlap) {
            return true;
        }
        if (t.isImmune(this) && t instanceof Poison && opponent.getBattleAbility().getClass() != Corrosion.class || this.isFainted() && !t.isTeamStatus() || this.hasStatus(type)) {
            return true;
        }
        for (StatusBase statusBase : this.status) {
            try {
                if (!statusBase.stopsStatusChange(type, this, opponent)) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("Problem with cannotHaveStatus for StatusType " + type.name());
                e.printStackTrace();
            }
        }
        for (GlobalStatusBase globalStatusBase : this.bc.globalStatusController.getGlobalStatuses()) {
            try {
                if (!globalStatusBase.stopsStatusChange(type, this, opponent)) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("Problem with cannotHaveStatus for StatusType " + type.name());
                e.printStackTrace();
            }
        }
        for (PixelmonWrapper pixelmonWrapper : this.bc.getTeamPokemon(this)) {
            if (pixelmonWrapper.getBattleAbility(opponent).allowsStatusTeammate(type, pixelmonWrapper, this, opponent)) continue;
            return true;
        }
        return !this.getBattleAbility(opponent).allowsStatus(type, this, opponent);
    }

    public List<EntryHazard> getEntryHazards() {
        ArrayList<EntryHazard> hazards = new ArrayList<EntryHazard>();
        for (StatusBase s : this.status) {
            if (!(s instanceof EntryHazard)) continue;
            hazards.add((EntryHazard)s);
        }
        return hazards;
    }

    private void updateBattleDamage(float damage) {
        this.updateBattleDamage((int)damage);
    }

    private void updateBattleDamage(int damage) {
        this.bc.updatePokemonHealth();
        this.bc.sendDamagePacket(this, damage);
        this.update(EnumUpdateType.HP);
        if (this.isFainted()) {
            int turnIndex = this.bc.turnList.indexOf(this);
            if (turnIndex > this.bc.actionIndex) {
                this.bc.turnList.remove(turnIndex);
            }
            if (this.removePrimaryStatus(false) != null) {
                this.sendStatusPacket(-1);
                this.update(EnumUpdateType.Status);
            }
        }
    }

    public List<Element> getEffectiveTypes(PixelmonWrapper user, PixelmonWrapper target) {
        List<Element> effectiveTypes = user.getBattleAbility().getEffectiveTypes(user, target);
        if (!effectiveTypes.equals(target.type)) {
            return effectiveTypes;
        }
        for (int i = 0; i < target.getStatusSize(); ++i) {
            effectiveTypes = target.getStatus(i).getEffectiveTypes(user, target);
            if (effectiveTypes.equals(target.type)) continue;
            return effectiveTypes;
        }
        effectiveTypes = target.getUsableHeldItem().getEffectiveTypes(user, target);
        for (GlobalStatusBase status : target.bc.globalStatusController.getGlobalStatuses()) {
            effectiveTypes = status.getEffectiveTypes(user, target);
        }
        return effectiveTypes;
    }

    public float doBattleDamage(PixelmonWrapper source, float damage, DamageTypeEnum damageType) {
        this.lastHP = this.getHealth();
        Ability thisAbility = this.getBattleAbility(source);
        HeldItem thisHeldItem = this.getUsableHeldItem();
        if (source == null) {
            source = this;
        }
        if (this.isFainted()) {
            return -1.0f;
        }
        boolean isMultiHit = false;
        Substitute substitute = null;
        boolean hitSubstitute = false;
        if (source != this) {
            if (damageType == DamageTypeEnum.ATTACK || damageType == DamageTypeEnum.ATTACKFIXED) {
                substitute = (Substitute)this.getStatus(StatusType.Substitute);
                boolean bl = hitSubstitute = substitute != null && !substitute.ignoreSubstitute(source);
            }
            if (damageType == DamageTypeEnum.ATTACK) {
                for (EffectBase e : source.attack.getMove().effects) {
                    if (!(e instanceof MultipleHit) && !(e instanceof TripleKick) && !(e instanceof BeatUp) && !(e instanceof DragonDarts) && !(e instanceof TripleAxel) && !(e instanceof PopulationBomb)) continue;
                    isMultiHit = true;
                    break;
                }
                if (!isMultiHit) {
                    source.attack.sendEffectiveChat(source, this);
                }
                damage = this.modifyCalculatedNonFixedDamage(source, thisAbility, thisHeldItem, damageType, damage, hitSubstitute);
            } else if (damageType == DamageTypeEnum.ATTACKFIXED && !hitSubstitute) {
                for (EffectBase e : source.attack.getMove().effects) {
                    if (!(e instanceof NightShade) || !(source.getBattleAbility() instanceof ParentalBond)) continue;
                    isMultiHit = true;
                    break;
                }
                for (StatusBase status : this.getStatuses()) {
                    damage = status.modifyDamageIncludeFixed((int)damage, source, this, source.attack, damageType);
                }
                damage = thisAbility.modifyDamageIncludeFixed((int)damage, source, this, source.attack);
                damage = (float)thisHeldItem.modifyDamageIncludeFixed(damage, source, this, source.attack);
            }
        } else {
            damage = thisAbility.modifySelfDamage((int)damage, this, source.attack);
        }
        damage = thisAbility.modifyDamage((int)damage, source, this, damageType, source.attack, thisAbility);
        damage = (float)Math.floor(damage);
        if (this.getParticipant() != null && !this.bc.simulateMode) {
            damage = this.getParticipant().onHit(source, damage, damageType);
        }
        if (hitSubstitute) {
            float damageResult = this.doBattleDamageToSubstitute(substitute, source, damageType, damage, isMultiHit);
            return damageResult;
        }
        if (source.attack != null && source.attack.getMove().hasEffect(FalseSwipe.class) && this != source && damageType == DamageTypeEnum.ATTACK) {
            damage = Math.min(damage, (float)(this.getHealth() - 1));
        }
        float damageResult = Math.min((float)this.getHealth(), damage);
        if (source != this && source.attack != null && source.attack.moveResult != null) {
            source.attack.moveResult.damage = (int)damageResult;
            source.attack.moveResult.fullDamage = (int)damage;
            source.attack.moveResult.target = this;
            source.attack.moveResult.result = AttackResult.hit;
        }
        if (!this.bc.simulateMode) {
            if (this.entity != null) {
                double prevMotionX = this.entity.m_20184_().f_82479_;
                double prevMotionY = this.entity.m_20184_().f_82480_;
                double prevMotionZ = this.entity.m_20184_().f_82481_;
                this.entity.m_6469_(PixelmonDamageTypes.getBattleDamage(this.entity.m_9236_(), (Entity)source.entity), 0.0f);
                this.entity.m_20334_(prevMotionX, prevMotionY, prevMotionZ);
            }
            int health = this.getHealth();
            this.setHealth(Math.max(this.getHealth() - (int)damageResult, 0));
            this.bc.battleLog.logEvent(new DamagePokemonAction(this.bc.battleTurn, this, (int)damageResult, source, damageType, health, this.getHealth()));
            this.updateBattleDamage(damage);
            if (damageType == DamageTypeEnum.ATTACK || damageType == DamageTypeEnum.ATTACKFIXED) {
                ++this.amountOfTimesHit;
            }
            if (source.attack != null && !this.isSameTeam(source)) {
                this.lastDirectPosition = source.battlePosition;
                this.lastDirectDamage = (int)damageResult;
                this.lastDirectCategory = source.attack.getAttackCategory();
            }
        }
        for (int i = 0; i < this.getStatusSize(); ++i) {
            this.getStatus(i).onDamageReceived(source, this, source.attack, (int)damageResult, damageType);
        }
        thisAbility.onDamageReceived(source, this, source.attack, (int)damageResult, damageType);
        if (source != this && damageType.isDirect()) {
            if (source.attack.getMove().getMakesContact()) {
                Attack.applyContact(source, this);
            }
            source.getBattleAbility(source).tookDamageUser((int)damageResult, source, this, source.attack);
            thisAbility.tookDamageTarget((int)damageResult, source, this, source.attack);
        }
        if (this.isFainted()) {
            this.onFaintAbilities(source);
        }
        if (damageType.isDirect()) {
            source.getUsableHeldItem().postProcessDamagingAttackUser(source, this, source.attack, damageResult);
        }
        if (!isMultiHit) {
            Attack.postProcessAttackAllHits(source, this, source.attack, damageResult, damageType, false);
        }
        if (source.attack != null && source.attack.getMove().effects != null && source != this) {
            for (EffectBase effect : source.attack.getMove().effects) {
                if (!(effect instanceof Recoil) || damageType == DamageTypeEnum.RECOIL) continue;
                ((Recoil)effect).applyRecoil(source, damageResult);
            }
        }
        if (source.attack == null || !source.attack.canRemoveBerry()) {
            thisHeldItem.tookDamage(source, this, damageResult, damageType);
        }
        this.damageTakenThisTurn = (int)((float)this.damageTakenThisTurn + damage);
        if (this.getHealth() <= 0) {
            String name = this.getNickname();
            this.bc.sendToAll("battlecontroller.hasfainted", name);
            if (this.participant.getType() == ParticipantType.WildPokemon && this.entity != null) {
                this.entity.m_6667_(PixelmonDamageTypes.getBattleDamage(this.entity.m_9236_(), (Entity)source.entity));
            } else {
                this.pokemon.decreaseFriendship(1);
                PixelmonFaintEvent.Pre pre = new PixelmonFaintEvent.Pre(this.getPlayerOwner(), this.pokemon);
                if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                    return damageResult;
                }
                this.getParticipant().incrementFaintCount();
                if (damageType == DamageTypeEnum.RECOIL) {
                    Pixelmon.EVENT_BUS.post((Event)new AttackEvent.Recoil(this.bc, this, damage, true));
                }
                Pixelmon.EVENT_BUS.post((Event)new PixelmonFaintEvent.Post(this.getPlayerOwner(), this.pokemon));
            }
            Pixelmon.EVENT_BUS.post((Event)new PixelmonKnockoutEvent(source, this));
        } else if (!this.bc.simulateMode && damageType == DamageTypeEnum.RECOIL) {
            Pixelmon.EVENT_BUS.post((Event)new AttackEvent.Recoil(this.bc, this, damage, false));
        }
        return damageResult;
    }

    private float modifyCalculatedNonFixedDamage(PixelmonWrapper source, Ability thisAbility, HeldItem thisHeldItem, DamageTypeEnum damageType, float damage, boolean hitSubstitute) {
        ArrayList<PixelmonWrapper> allies = this.bc.getTeamPokemon(this.getParticipant());
        if (allies.size() > 1) {
            for (PixelmonWrapper ally : allies) {
                if (ally == this) continue;
                damage = ally.getBattleAbility().modifyDamageTeammate((int)damage, source, this, source.attack);
            }
        }
        damage = source.getBattleAbility().modifyDamageUser((int)damage, source, this, source.attack);
        if (!AbilityRegistry.ignoreAbility(source, this)) {
            damage = thisAbility.modifyDamageTarget((int)damage, source, this, source.attack);
        }
        for (EffectBase effect : source.attack.getMove().effects) {
            if (effect == null) continue;
            damage = effect.modifyDamage((int)damage, source, this, source.attack);
        }
        if (!hitSubstitute) {
            for (StatusBase status : this.getStatuses()) {
                damage = status.modifyDamageIncludeFixed((int)damage, source, this, source.attack, damageType);
            }
            damage = thisAbility.modifyDamageIncludeFixed((int)damage, source, this, source.attack);
            damage = (float)thisHeldItem.modifyDamageIncludeFixed(damage, source, this, source.attack);
        }
        return damage;
    }

    private float doBattleDamageToSubstitute(Substitute substitute, PixelmonWrapper source, DamageTypeEnum damageType, float damage, boolean isMultiHit) {
        float damageResult = substitute.attackSubstitute(damage, source, this);
        source.attack.moveResult.damage = (int)damageResult;
        source.attack.moveResult.fullDamage = (int)damage;
        source.attack.moveResult.target = this;
        source.attack.moveResult.result = AttackResult.succeeded;
        if (damageType.isDirect()) {
            source.getUsableHeldItem().postProcessDamagingAttackUser(source, this, source.attack, damageResult);
        }
        if (!isMultiHit) {
            Attack.postProcessAttackAllHits(source, this, source.attack, damageResult, damageType, true);
        }
        for (EffectBase effect : source.attack.getMove().effects) {
            if (!(effect instanceof Recoil)) continue;
            ((Recoil)effect).applyRecoil(source, damageResult);
        }
        return damageResult;
    }

    private void onFaintAbilities(PixelmonWrapper source) {
        ArrayList<PixelmonWrapper> allies = this.bc.getTeamPokemon(this);
        ArrayList<PixelmonWrapper> foes = this.bc.getOpponentPokemon(this);
        this.getBattleAbility(source).onSelfFaint(this, source);
        for (PixelmonWrapper pw : allies) {
            if (pw == this) continue;
            pw.getBattleAbility(source).onAllyFaint(pw, this, source);
        }
        for (PixelmonWrapper pw : foes) {
            pw.getBattleAbility(source).onFoeFaint(pw, this, source);
            if (pw.getParticipant() == null || this.bc.simulateMode) continue;
            pw.getParticipant().onOpponentKO(this.bc, this);
        }
    }

    public Ability getAbility() {
        return this.pokemon.getAbility();
    }

    public Ability getBattleAbility() {
        return this.getBattleAbility(true, null);
    }

    public Ability getBattleAbility(PixelmonWrapper moveUser) {
        return this.getBattleAbility(true, moveUser);
    }

    public Ability getBattleAbility(boolean canIgnore) {
        return this.getBattleAbility(canIgnore, null);
    }

    public Ability getBattleAbility(boolean canIgnore, PixelmonWrapper moveUser) {
        if (canIgnore && AbilityRegistry.ignoreAbility(moveUser, this)) {
            return ComingSoon.noAbility;
        }
        if (this.tempAbility != null) {
            return this.tempAbility;
        }
        return this.pokemon.getAbility();
    }

    public boolean hasHeldItem() {
        return !(this.pokemon.getHeldItemAsItemHeld() instanceof NoItem);
    }

    public HeldItem getHeldItem() {
        return this.pokemon.getHeldItemAsItemHeld();
    }

    public HeldItem getUsableHeldItem() {
        if (HeldItem.canUseItem(this)) {
            return this.getHeldItem();
        }
        return PixelmonItems.no_item;
    }

    public void removeHeldItem() {
        this.setHeldItem(PixelmonItems.no_item);
    }

    public void setHeldItem(HeldItem newItem) {
        if (this.bc != null && !this.bc.simulateMode) {
            HeldItem heldItem = this.getHeldItem();
            this.pokemon.setHeldItem(newItem == null ? null : new ItemStack((ItemLike)newItem));
            this.getBattleAbility().onItemChanged(this, this.pokemon.getHeldItemAsItemHeld());
            this.bc.battleLog.logEvent(new HeldItemChangeAction(this.bc.battleTurn, this, heldItem, newItem));
        }
    }

    public void setHeldItem(ItemStack itemStack) {
        if (this.bc != null && !this.bc.simulateMode) {
            this.pokemon.setHeldItem(itemStack);
            if (this.getBattleAbility() != null) {
                this.getBattleAbility().onItemChanged(this, this.pokemon.getHeldItemAsItemHeld());
            }
        }
    }

    public boolean canMegaEvolve() {
        if (this.pokemon.hasFlag("unmegaevo")) {
            return false;
        }
        if (this.getSpecies().is(PixelmonSpecies.RAYQUAZA)) {
            return this.pokemon.getMoveset().hasAttack(AttackRegistry.DRAGON_ASCENT);
        }
        return PixelmonWrapper.canMegaEvolve(this.getHeldItem(), this.getSpecies(), this.pokemon.getForm().getName());
    }

    public boolean canUltraBurst() {
        return PixelmonWrapper.canUltraBurst(this.getSpecies(), this.getHeldItem(), this.getForm());
    }

    public boolean canDynamax() {
        return PixelmonWrapper.canDynamax(this.getForm(), this.getHeldItem());
    }

    public boolean canGigantamax() {
        return PixelmonWrapper.canGigantamax(this.hasGigantamaxFactor(), this.getSpecies(), this.getForm());
    }

    public static boolean canMegaEvolve(ItemStack heldItem, Species pokemon, String form) {
        return PixelmonWrapper.canMegaEvolve(HeldItem.getItemHeld(heldItem), pokemon, form);
    }

    public static boolean canUseZMove(ItemStack heldItem) {
        return heldItem.m_41720_() instanceof ZCrystalItem;
    }

    public static boolean canMegaEvolve(HeldItem heldItem, Species species, String form) {
        return PixelmonWrapper.hasCompatibleMegaStone(heldItem, species.getForm(form));
    }

    public static boolean canUltraBurst(Species species, HeldItem heldItem, Stats form) {
        return species.is(PixelmonSpecies.NECROZMA) && form.isForm("dawn", "dusk") && heldItem == PixelmonItems.ultranecrozium_z;
    }

    public static boolean canDynamax(Stats form, HeldItem item) {
        if (form.getParentSpecies().is(PixelmonSpecies.KYOGRE) && item == PixelmonItems.blue_orb || form.getParentSpecies().is(PixelmonSpecies.GROUDON) && item == PixelmonItems.red_orb) {
            return false;
        }
        return !form.getTags().hasTag("cannot_dynamax");
    }

    public static boolean canGigantamax(boolean gigantamaxFactor, Species species, Stats form) {
        return gigantamaxFactor && PixelmonWrapper.canDynamax(form, null) && form.hasGigantamaxForm();
    }

    public boolean hasCompatibleMegaStone() {
        return PixelmonWrapper.hasCompatibleMegaStone(this.getHeldItem(), this.getForm());
    }

    public static boolean hasCompatibleMegaStone(HeldItem heldItem, Stats form) {
        return form != null && form.getMegaForm(heldItem).isPresent();
    }

    public boolean isItemRemovable(PixelmonWrapper user) {
        if (this.getBattleAbility(user).preventsItemRemoval(user, this)) {
            return false;
        }
        if (user.isWildPokemon() && this.participant instanceof PlayerParticipant) {
            return false;
        }
        if (this.hasStatus(StatusType.Substitute)) {
            return false;
        }
        if (this.hasSpecialItem(user)) {
            return false;
        }
        HeldItem heldItem = this.getHeldItem();
        if (heldItem instanceof BlankTechnicalMachineItem) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.mail) {
            return false;
        }
        if (PixelmonWrapper.hasCompatibleMegaStone(heldItem, user.getForm()) || this.hasCompatibleMegaStone()) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.megaStone && (this.isMega || user.isMega)) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.zCrystal) {
            return false;
        }
        if (heldItem == PixelmonItems.griseous_orb && (this.getSpecies().is(PixelmonSpecies.GIRATINA) || user.getSpecies().is(PixelmonSpecies.GIRATINA))) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.drive && (this.getSpecies().is(PixelmonSpecies.GENESECT) || user.getSpecies().is(PixelmonSpecies.GENESECT))) {
            return false;
        }
        if ((this.getSpecies().is(PixelmonSpecies.KYOGRE) && heldItem == PixelmonItems.blue_orb || this.getSpecies().is(PixelmonSpecies.GROUDON) && heldItem == PixelmonItems.red_orb) && !this.getForm().isForm("primal")) {
            return false;
        }
        if ((user.getSpecies().is(PixelmonSpecies.KYOGRE) && user.getHeldItem() == PixelmonItems.blue_orb || user.getSpecies().is(PixelmonSpecies.GROUDON) && user.getHeldItem() == PixelmonItems.red_orb) && !this.getForm().isForm("primal")) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.memory && (user.getSpecies().is(PixelmonSpecies.SILVALLY) || this.getSpecies().is(PixelmonSpecies.SILVALLY))) {
            return false;
        }
        if (heldItem instanceof PlateItem && this.getSpecies().is(PixelmonSpecies.ARCEUS)) {
            return false;
        }
        if ((heldItem == PixelmonItems.rusted_sword || heldItem == PixelmonItems.rusted_shield) && (user.getSpecies().is(PixelmonSpecies.ZACIAN) || user.getSpecies().is(PixelmonSpecies.ZAMAZENTA) || this.getSpecies().is(PixelmonSpecies.ZACIAN) || this.getSpecies().is(PixelmonSpecies.ZAMAZENTA))) {
            return false;
        }
        return heldItem != PixelmonItems.booster_energy || !(this.getAbility() instanceof ParadoxBoostAbility);
    }

    public boolean isItemGivable(HeldItem item) {
        if (item == PixelmonItems.griseous_orb && this.getSpecies().is(PixelmonSpecies.GIRATINA)) {
            return false;
        }
        if (item.getHeldItemType() == EnumHeldItems.drive && this.getSpecies().is(PixelmonSpecies.GENESECT)) {
            return false;
        }
        if (item instanceof PlateItem && this.getSpecies().is(PixelmonSpecies.ARCEUS)) {
            return false;
        }
        if (item instanceof MemoryItem && this.getSpecies().is(PixelmonSpecies.SILVALLY)) {
            return false;
        }
        if (item != Items.f_41852_ && PixelmonWrapper.hasCompatibleMegaStone(item, this.getForm())) {
            return false;
        }
        if (item instanceof OrbItem) {
            OrbItem orb = (OrbItem)item;
            if (orb.shard == EnumOrbShard.BLUE && this.getSpecies().is(PixelmonSpecies.KYOGRE)) {
                return false;
            }
            if (orb.shard == EnumOrbShard.RED && this.getSpecies().is(PixelmonSpecies.GROUDON)) {
                return false;
            }
        }
        return item != PixelmonItems.booster_energy || !(this.getAbility() instanceof ParadoxBoostAbility);
    }

    public boolean hasSpecialItem(PixelmonWrapper user) {
        HeldItem item = this.getHeldItem();
        if (item == null) {
            return false;
        }
        if ((this.getSpecies().is(PixelmonSpecies.KYOGRE) || user.getSpecies().is(PixelmonSpecies.KYOGRE)) && item == PixelmonItems.blue_orb) {
            return true;
        }
        if ((this.getSpecies().is(PixelmonSpecies.GROUDON) || user.getSpecies().is(PixelmonSpecies.GROUDON)) && item == PixelmonItems.red_orb) {
            return true;
        }
        if (item instanceof PlateItem && this.getBattleAbility() instanceof Multitype) {
            return true;
        }
        if (item instanceof MemoryItem && this.getBattleAbility() instanceof RKSSystem) {
            return true;
        }
        if (item instanceof ZCrystalItem) {
            return true;
        }
        if ((this.getSpecies().is(PixelmonSpecies.GIRATINA) || user.getSpecies().is(PixelmonSpecies.GIRATINA)) && item == PixelmonItems.griseous_orb) {
            return true;
        }
        if ((this.getSpecies().is(PixelmonSpecies.GENESECT) || user.getSpecies().is(PixelmonSpecies.GENESECT)) && item.getHeldItemType() == EnumHeldItems.drive) {
            return true;
        }
        if (this.hasCompatibleMegaStone() || PixelmonWrapper.hasCompatibleMegaStone(item, user.getForm())) {
            return true;
        }
        return item == PixelmonItems.booster_energy && this.getAbility() instanceof ParadoxBoostAbility;
    }

    @Deprecated
    public String getNickname() {
        Ability battleAbility = this.getBattleAbility();
        if (battleAbility instanceof Illusion) {
            Illusion illusion = (Illusion)battleAbility;
            if (illusion.disguisedPokemon != null) {
                if (!illusion.disguisedNickname.isEmpty()) {
                    return illusion.disguisedNickname;
                }
                return illusion.disguisedPokemon.getLocalizedName();
            }
        }
        return this.getRealNickname();
    }

    public Component getFormattedNickname() {
        Ability battleAbility = this.getBattleAbility();
        if (battleAbility instanceof Illusion) {
            Illusion illusion = (Illusion)battleAbility;
            if (illusion.disguisedPokemon != null) {
                if (!illusion.disguisedNickname.isEmpty()) {
                    return Component.m_237115_((String)illusion.disguisedNickname);
                }
                return illusion.disguisedPokemon.getTranslatedName();
            }
        }
        return this.getRealFormattedNickname();
    }

    @Deprecated
    public String getRealNickname() {
        return this.pokemon.getDisplayName();
    }

    public Component getRealFormattedNickname() {
        return this.pokemon.getFormattedDisplayName();
    }

    public Gender getGender() {
        return this.pokemon.getGender();
    }

    public int getHealth(boolean ignoreDynamax) {
        int hp = this.pokemon.getHealth();
        if (this.isDynamax > 0 && ignoreDynamax) {
            hp = (int)Math.ceil((double)hp / (1.0 + this.getDynamaxHealthMod()));
        }
        return hp;
    }

    public int getHealth() {
        return this.getHealth(false);
    }

    public int getMaxHealth(boolean ignoreDynamax) {
        int maxHP = this.pokemon.getStat(BattleStatsType.HP);
        if (this.isDynamax > 0 && !ignoreDynamax) {
            double percent = this.getDynamaxHealthMod();
            maxHP += (int)Math.ceil((double)maxHP * percent);
        }
        return maxHP;
    }

    public int getMaxHealth() {
        return this.getMaxHealth(false);
    }

    public double getDynamaxHealthMod() {
        return 0.5 + (double)this.pokemon.getDynamaxLevel() * 0.05;
    }

    public float getHealthPercent() {
        return this.getHealthPercent(this.getHealth());
    }

    public float getHealthPercent(float amount) {
        return amount / (float)this.getMaxHealth() * 100.0f;
    }

    public float getHealPercent(float amount) {
        return this.getHealthPercent(Math.min(amount, (float)this.getHealthDeficit()));
    }

    public int getHealthDeficit() {
        return this.getMaxHealth() - this.getHealth();
    }

    public boolean hasFullHealth(boolean ignoreAbility) {
        return this.getHealth() >= this.getMaxHealth() && (ignoreAbility || !this.getBattleAbility().alwaysConsideredDamaged(this));
    }

    public boolean hasFullHealth() {
        return this.hasFullHealth(false);
    }

    public int getPercentMaxHealth(float percent, boolean ignoreDynamax) {
        int maxHP = this.getMaxHealth();
        if (ignoreDynamax) {
            maxHP = (int)Math.ceil((double)maxHP / (1.0 + this.getDynamaxHealthMod()));
        }
        return Math.max(1, (int)((float)maxHP * percent / 100.0f));
    }

    public int getPercentMaxHealth(float percent) {
        return this.getPercentMaxHealth(percent, false);
    }

    public int healByPercent(float percent) {
        return this.healEntityBy(this.getPercentMaxHealth(percent));
    }

    public int healEntityBy(int i) {
        i = this.getBattleAbility().onHealed(this, i);
        if (i + this.getHealth() > this.getMaxHealth()) {
            i = this.getMaxHealth() - this.getHealth();
        }
        if (i != 0 && !this.bc.simulateMode) {
            if (this.animateHP) {
                this.bc.sendHealPacket(this, i);
            }
            int health = this.getHealth();
            this.setHealth(this.getHealth() + i);
            this.bc.battleLog.logEvent(new HealPokemonAction(this.bc.battleTurn, this, i, health, this.getHealth()));
        }
        return i;
    }

    public void setHealth(int newHP) {
        this.pokemon.setHealth(newHP);
    }

    public void setAttackFailed() {
        if (this.attack != null && this.attack.moveResult != null) {
            this.attack.moveResult.result = AttackResult.failed;
        }
    }

    public boolean doesLevel() {
        return this.pokemon.doesLevel();
    }

    public UUID getPokemonUUID() {
        return this.pokemon.getUUID();
    }

    public void update(EnumUpdateType ... types) {
        PartyStorage storage = this.participant.getStorage();
        if (storage != null) {
            this.pokemon.markDirty(types);
        }
    }

    public Stats getForm() {
        return this.pokemon.getForm();
    }

    public void setForm(String form) {
        if (this.getSpecies().getForm(form) == null) {
            return;
        }
        this.setForm(this.getSpecies().getForm(form));
        this.bc.updateFormChange(this);
    }

    public void setForm(Stats form) {
        if (this.bc != null && this.bc.simulateMode) {
            return;
        }
        float healthPercent = this.pokemon.getHealthPercentage();
        float dynScale = this.entity != null ? this.entity.getPixelmonScale() : 1.0f;
        this.pokemon.setForm(form);
        if (this.entity != null) {
            this.entity.setPixelmonScale(dynScale);
        }
        this.getBattleStats().setBattleStatsForCurrentForm();
        this.type = this.getForm().getTypes();
        this.initialType = this.type;
        if (this.tempLevel && !this.bc.battleEnded) {
            this.pokemon.getStats().setLevelStats(this.getNature(), this.getForm(), this.temporaryPokemonLevel.getPokemonLevel());
            this.setHealth(Math.round(healthPercent / 100.0f * (float)this.getMaxHealth()));
        }
        this.updateHPIncrease();
    }

    public Stats getPrevForm() {
        return this.prevForm;
    }

    public void setPrevForm(String form) {
        this.setPrevForm(this.getSpecies().getForm(form));
    }

    public void setPrevForm(Stats form) {
        this.prevForm = form;
    }

    public void setPalette(String paletteName) {
        this.pokemon.setPalette(paletteName);
    }

    public void setPrevPaletteName(String paletteName) {
        this.prevPaletteName = paletteName;
    }

    public boolean hasGigantamaxFactor() {
        return this.pokemon.hasGigantamaxFactor();
    }

    public void resetBattleEvolution() {
        if (this.isWildPokemon() && this.entity != null && this.entity.isBossPokemon()) {
            return;
        }
        if (this.getForm().isTemporary()) {
            this.setForm(this.initialCopyOfPokemon.getForm());
            this.pokemon.setPalette(this.initialCopyOfPokemon.getPalette());
            this.getStats().recalculateStats();
            if (this.evolution != null) {
                this.evolution.battleEvolutionConcluded = true;
            }
        }
        if (this.getForm().isTemporary()) {
            if (this.pokemon.getPersistentData().m_128441_("SrcForm")) {
                this.setForm(this.pokemon.getPersistentData().m_128461_("SrcForm"));
            } else {
                this.setForm(this.getSpecies().getDefaultForm());
            }
        }
    }

    public BlockPos getWorldPosition() {
        PixelmonEntity entity = this.entity;
        if (entity == null && (entity = this.getParticipant().getEntity()) == null) {
            Pixelmon.LOGGER.error("==Attempted to get world position of null entity " + this + " on " + this.getParticipant() + "==");
            return null;
        }
        return entity.m_20183_();
    }

    public Level getWorld() {
        return this.getParticipant().getEntity().f_19853_;
    }

    public ServerPlayer getPlayerOwner() {
        BattleParticipant participant = this.getParticipant();
        if (participant instanceof PlayerParticipant) {
            PlayerParticipant player = (PlayerParticipant)participant;
            return player.player;
        }
        return null;
    }

    public NPCTrainer getTrainerOwner() {
        BattleParticipant participant = this.getParticipant();
        if (participant instanceof TrainerParticipant) {
            TrainerParticipant trainer = (TrainerParticipant)participant;
            return trainer.trainer;
        }
        return null;
    }

    public String getOwnerName() {
        if (this.getPlayerOwner() != null) {
            return this.getPlayerOwner().m_7755_().getString();
        }
        if (this.getTrainerOwner() != null) {
            return this.getTrainerOwner().m_7755_().getString();
        }
        return this.getNickname();
    }

    public boolean isWildPokemon() {
        BattleParticipant participant = this.getParticipant();
        return participant.getType() == ParticipantType.WildPokemon;
    }

    public boolean isRaidPokemon() {
        return this.getParticipant().getType() == ParticipantType.RaidPokemon;
    }

    public boolean isSingleType() {
        return this.type.size() == 1;
    }

    public boolean isSingleType(Element type) {
        return this.isSingleType() && this.hasType(type);
    }

    public void addAttackers() {
        ArrayList<PixelmonWrapper> opponents = this.getOpponentPokemon();
        this.attackers.addAll(opponents);
        for (PixelmonWrapper opponent : opponents) {
            opponent.attackers.add(this);
        }
    }

    public String getOriginalTrainer() {
        return this.pokemon.getOriginalTrainer();
    }

    public String getPokemonName() {
        return this.getSpecies().getName();
    }

    public Species getSpecies() {
        return this.pokemon.getSpecies();
    }

    public Nature getNature() {
        return this.pokemon.getNature();
    }

    public Nature getBaseNature() {
        return this.pokemon.getBaseNature();
    }

    public PokemonLevel getPokemonLevel() {
        if (this.tempLevel) {
            return this.temporaryPokemonLevel;
        }
        return this.pokemon.getPokemonLevelContainer();
    }

    public int getPokemonLevelNum() {
        if (this.tempLevel) {
            return this.temporaryPokemonLevel.getPokemonLevel();
        }
        return this.pokemon.getPokemonLevel();
    }

    public int getExp() {
        if (this.tempLevel) {
            return this.temporaryPokemonLevel.getExp();
        }
        return this.pokemon.getExperience();
    }

    public void setLevelNum(int level) {
        if (this.tempLevel) {
            this.temporaryPokemonLevel.setLevel(level);
        } else {
            this.pokemon.setLevelNum(level);
        }
    }

    public void setExp(int experience) {
        this.pokemon.setExperience(experience);
    }

    public void setTempLevel(int level) {
        this.tempLevel = true;
        this.temporaryPokemonLevel = new TempBattlePokemonLevel(new DelegateLink(this.pokemon), level);
    }

    public Pokemon getInnerLink() {
        return this.pokemon;
    }

    public int getPartyPosition() {
        return this.partyPosition;
    }

    public void enableReturnHeldItem() {
        this.returnHeldItem = true;
    }

    public boolean shouldReturnHeldItem() {
        return this.returnHeldItem;
    }

    public void writeToNBT() {
        if (this.pokemon == null || this.bc == null) {
            return;
        }
        if (!this.tempLevel && this.entity != null) {
            this.entity.m_21051_(Attributes.f_22276_).m_22100_((double)this.pokemon.getMaxHealth());
        }
        if (this.tempLevel) {
            float heath = this.pokemon.getHealthPercentage();
            this.pokemon.getStats().setLevelStats(this.pokemon.getNature(), this.pokemon.getForm(), this.pokemon.getPokemonLevel());
            this.setHealth(Math.round(heath / 100.0f * (float)this.pokemon.getMaxHealth()));
            this.update(EnumUpdateType.Stats);
        }
        if (this.bc.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL).booleanValue()) {
            this.pokemon.setHealth(this.startHealth);
        } else {
            this.pokemon.setStatus(this.getPrimaryStatus());
        }
        if (!this.tempLevel) {
            // empty if block
        }
        if (this.getHeldItem() != this.initialCopyOfPokemon.getHeldItemAsItemHeld() && this.returnHeldItem) {
            this.pokemon.setHeldItem(this.initialCopyOfPokemon.getHeldItem());
        }
        this.pokemon.markDirty(new EnumUpdateType[0]);
    }

    public void updateHPIncrease() {
        if (this.bc != null) {
            this.bc.sendToPlayers(new HPIncreaseTask(this.getPokemonUUID(), this.getPokemonLevelNum(), this.getHealth(), this.getMaxHealth()));
        }
    }

    public boolean isDynamax() {
        return this.isDynamax > 0;
    }

    public boolean isGigantamax() {
        return this.isDynamax == 2;
    }

    public void setRaidShields(int shields) {
        this.maxShields = shields;
        this.shields = shields;
        if (this.bc != null) {
            this.bc.sendToPlayers(new RaidShieldsTask(this.getPokemonUUID(), this.shields, this.maxShields));
        }
    }

    public void updateRaidShields(int shields) {
        this.shields = shields;
        if (this.bc != null) {
            this.bc.sendToPlayers(new RaidShieldsTask(this.getPokemonUUID(), this.shields, this.maxShields));
        }
    }

    public void addGlobalStatus(GlobalStatusBase g) {
        this.bc.globalStatusController.addGlobalStatus(this, g);
        this.getHeldItem().onGlobalStatusAdded(this, g);
    }

    public PixelmonWrapper copy() {
        return new PixelmonWrapper(this);
    }

    public int getBeginingOfTurnHP() {
        return this.beginingOfTurnHP;
    }
}

