/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.events.battles.SetBattleAIEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.RunAway;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.comm.data.PixelmonPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public abstract class BattleParticipant {
    public boolean startedBattle = false;
    public BattleController bc;
    public int team = 0;
    public boolean wait = false;
    public List<PixelmonWrapper> controlledPokemon;
    public PixelmonWrapper[] allPokemon;
    public boolean isDefeated = false;
    protected long lastMoveTime;
    public int numControlledPokemon;
    protected int lastFaintedTurn = -2;
    protected int totalFainted = 0;
    public PokeBall lastFailedCapture;
    public List<UUID> switchingIn = new ArrayList<UUID>(2);
    public List<PixelmonWrapper> switchingOut = Lists.newCopyOnWriteArrayList();
    private BattleAIBase battleAI;
    public UUID evolution = null;
    public UUID ultraBurst = null;
    public UUID ashNinja = null;
    public UUID dynamax = null;
    public boolean usedZ = false;

    public Long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public void resetMoveTimer() {
        this.lastMoveTime = this.getCurrentTime();
    }

    public long getTurnTimeSeconds() {
        if (this.lastMoveTime == -1L) {
            this.resetMoveTimer();
            return 0L;
        }
        return (this.getCurrentTime() - this.lastMoveTime) / 1000L;
    }

    public BattleParticipant(int numControlledPokemon) {
        this.setNumControlledPokemon(numControlledPokemon);
        this.lastMoveTime = this.getCurrentTime();
    }

    public void setNumControlledPokemon(int numControlledPokemon) {
        this.numControlledPokemon = numControlledPokemon;
        this.controlledPokemon = new ArrayList<PixelmonWrapper>(numControlledPokemon);
    }

    public boolean hasMorePokemon() {
        return this.countAblePokemon() > 0;
    }

    public abstract boolean hasMorePokemonReserve();

    public abstract boolean canGainXP();

    public void startBattle() {
        for (PixelmonWrapper p : this.allPokemon) {
            p.bc = this.bc;
            int levelCap = this.bc.rules.getOrDefault(BattleRuleRegistry.LEVEL_CAP) + (this instanceof TrainerParticipant ? ((TrainerParticipant)this).trainer.getBossTier().getExtraLevels() : 0);
            p.startHealth = p.getHealth();
            if ((levelCap < PixelmonServerConfig.maxLevel || this.bc.rules.getOrDefault(BattleRuleRegistry.RAISE_TO_CAP).booleanValue()) && (p.getPokemonLevelNum() > levelCap || this.bc.rules.getOrDefault(BattleRuleRegistry.RAISE_TO_CAP).booleanValue())) {
                float healthPercent = p.getHealthPercent();
                p.setTempLevel(levelCap);
                p.animateHP = false;
                p.healByPercent(Math.max(0.0f, healthPercent - p.getHealthPercent()));
                p.animateHP = true;
            }
            int maxHealth = p.getMaxHealth();
            int startHealth = p.getHealth();
            if (startHealth > maxHealth) {
                p.setHealth(maxHealth);
            }
            if (!this.bc.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL).booleanValue()) continue;
            p.setHealth(maxHealth);
            p.clearStatus();
            for (Attack attack : p.getMoveset()) {
                if (attack == null) continue;
                attack.pp = attack.getMaxPP();
            }
        }
        for (PixelmonWrapper p : this.controlledPokemon) {
            if (p.entity == null && p.pokemon.getPixelmonEntity().isPresent()) {
                p.entity = p.pokemon.getPixelmonEntity().get();
            }
            if (p.entity != null) {
                p.entity.battleController = this.bc;
            }
            p.bc = this.bc;
        }
    }

    public abstract void endBattle(BattleEndCause var1);

    public abstract Component getName();

    public abstract MoveChoice getMove(PixelmonWrapper var1);

    public abstract PixelmonWrapper switchPokemon(PixelmonWrapper var1, UUID var2);

    public abstract boolean checkPokemon();

    public abstract void updatePokemon(PixelmonWrapper var1);

    public abstract LivingEntity getEntity();

    public abstract void updateOtherPokemon();

    public abstract ParticipantType getType();

    public abstract void getNextPokemon(int var1);

    public abstract UUID getNextPokemonUUID();

    public int countTeam() {
        return this.allPokemon.length;
    }

    public int countAblePokemon() {
        int i = 0;
        for (PixelmonWrapper pw : this.allPokemon) {
            if (!pw.isAlive()) continue;
            ++i;
        }
        return i;
    }

    public float countHealthPercent() {
        float percent = 0.0f;
        float teamCount = 0.0f;
        for (PixelmonWrapper pw : this.allPokemon) {
            if (!pw.isAlive()) continue;
            teamCount += 1.0f;
            percent += pw.getHealthPercent();
        }
        if (teamCount != 0.0f) {
            return percent / 100.0f / teamCount;
        }
        return 0.0f;
    }

    public void tick() {
    }

    public void clearTurnVariables() {
        for (PixelmonWrapper p : this.controlledPokemon) {
            p.clearTurnVariables();
        }
    }

    public void selectAction() {
        for (PixelmonWrapper p : this.controlledPokemon) {
            p.selectAIAction();
        }
    }

    public boolean getWait() {
        if (this.wait) {
            return true;
        }
        for (PixelmonWrapper p : this.controlledPokemon) {
            if (!p.wait || !p.isAlive() && !p.isSwitching) continue;
            return true;
        }
        return false;
    }

    public PixelmonWrapper getFaintedPokemon() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.isFainted()) continue;
            return pw;
        }
        return null;
    }

    public boolean hasRemainingPokemon() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.isAlive()) continue;
            return true;
        }
        return false;
    }

    public boolean faintedLastTurn() {
        return this.bc.battleTurn - this.lastFaintedTurn <= 1;
    }

    public void updateLastFaintedTurn() {
        this.lastFaintedTurn = this.bc.battleTurn;
    }

    public int getTotalFainted() {
        return this.totalFainted;
    }

    public void incrementFaintCount() {
        ++this.totalFainted;
    }

    public void sendDamagePacket(PixelmonWrapper target, int damage) {
    }

    public void sendHealPacket(PixelmonWrapper target, int amount) {
    }

    public String getDisplayName() {
        return "";
    }

    public static boolean[] canSwitch(PixelmonWrapper p) {
        boolean canSwitch = true;
        boolean canFlee = true;
        for (int i = 0; i < p.getStatusSize(); ++i) {
            StatusBase statusBase = p.getStatus(i);
            if (!statusBase.stopsSwitching()) continue;
            canSwitch = false;
            canFlee = false;
        }
        for (StatusBase statusBase : p.bc.globalStatusController.getGlobalStatuses()) {
            if (!statusBase.stopsSwitching()) continue;
            canSwitch = false;
            canFlee = false;
        }
        ArrayList<PixelmonWrapper> opponents = p.bc.getOpponentPokemon(p.getParticipant());
        for (PixelmonWrapper pw : opponents) {
            if (!pw.getBattleAbility().stopsSwitching(pw, p)) continue;
            canSwitch = false;
            canFlee = false;
        }
        if (!p.stopsForcedSwitches(p)) {
            if (p.hasType(Element.GHOST)) {
                canSwitch = true;
                canFlee = true;
            }
            if (!canSwitch && p.getHeldItem().getHeldItemType() == EnumHeldItems.shedShell) {
                canSwitch = true;
            }
            if (!canFlee && (p.getHeldItem().getHeldItemType() == EnumHeldItems.smokeBall || p.getBattleAbility() instanceof RunAway)) {
                canFlee = true;
            }
        }
        return new boolean[]{canSwitch, canFlee};
    }

    public PartyStorage getStorage() {
        return null;
    }

    public List<BattleParticipant> getOpponents() {
        return this.bc.getOpponents(this);
    }

    public List<BattleParticipant> getAllies() {
        return this.bc.getTeam(this);
    }

    public List<PixelmonWrapper> getOpponentPokemon() {
        return this.bc.getOpponentPokemon(this);
    }

    public List<PixelmonWrapper> getTeamPokemon() {
        return this.bc.getTeamPokemon(this);
    }

    public List<PixelmonWrapper> getActiveUnfaintedPokemon() {
        ArrayList<PixelmonWrapper> unfaintedPokemon = new ArrayList<PixelmonWrapper>(this.controlledPokemon.size());
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.isFainted()) continue;
            unfaintedPokemon.add(pw);
        }
        return unfaintedPokemon;
    }

    public PixelmonWrapper getPokemonFromUUID(UUID uuid) {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!uuid.equals(pw.getPokemonUUID())) continue;
            return pw;
        }
        return null;
    }

    public PixelmonWrapper getPartyPokemonFromUUID(UUID uuid) {
        for (PixelmonWrapper pw : this.allPokemon) {
            if (!uuid.equals(pw.getPokemonUUID())) continue;
            return pw;
        }
        return null;
    }

    public int getPartyPosition(PixelmonWrapper pokemon) {
        for (int i = 0; i < this.allPokemon.length; ++i) {
            if (pokemon != this.allPokemon[i]) continue;
            return i;
        }
        return -1;
    }

    protected void loadParty(PartyStorage party) {
        List<Pokemon> team = party.getTeam();
        this.loadParty(team);
    }

    protected void loadParty(List<Pokemon> party) {
        this.allPokemon = new PixelmonWrapper[party.size()];
        for (int i = 0; i < this.allPokemon.length; ++i) {
            this.allPokemon[i] = new PixelmonWrapper(this, party.get(i), i);
        }
    }

    protected void loadSingle(Pokemon pokemon) {
        this.allPokemon = new PixelmonWrapper[]{new PixelmonWrapper(this, pokemon, 0)};
    }

    public PixelmonWrapper getPokemonFromParty(UUID uuid) {
        for (PixelmonWrapper pw : this.allPokemon) {
            if (!pw.getPokemonUUID().equals(uuid)) continue;
            return pw;
        }
        return null;
    }

    protected PixelmonWrapper getPokemonFromParty(PixelmonEntity entity) {
        PixelmonWrapper pw = this.getPokemonFromParty(entity.m_20148_());
        if (entity.getForm().isTemporary()) {
            entity.setForm(entity.getForm().getDefaultBaseForm());
        }
        if (pw == null) {
            return new PixelmonWrapper(this, entity, 0);
        }
        pw.entity = entity;
        return pw;
    }

    public Level getWorld() {
        return this.getEntity().m_9236_();
    }

    public boolean addSwitchingOut(PixelmonWrapper pw) {
        if (this.hasMorePokemonReserve()) {
            this.switchingOut.add(pw);
            return true;
        }
        return false;
    }

    public void switchAllFainted() {
        for (PixelmonWrapper pw : this.switchingOut) {
            pw.doSwitch();
        }
        this.switchingOut.clear();
        this.switchingIn.clear();
    }

    public PixelmonWrapper getRandomPartyPokemon() {
        PixelmonWrapper pokemon = RandomHelper.getRandomElementExcluding(this.allPokemon, this.controlledPokemon.toArray(new PixelmonWrapper[0]));
        if (pokemon == null) {
            return null;
        }
        while (pokemon.isFainted()) {
            pokemon = RandomHelper.getRandomElementExcluding(this.allPokemon, this.controlledPokemon.toArray(new PixelmonWrapper[0]));
        }
        return pokemon;
    }

    public boolean canMegaEvolve() {
        return true;
    }

    public boolean canDynamax() {
        return true;
    }

    public BattleAIBase getBattleAI() {
        return this.battleAI;
    }

    public void setBattleAI(BattleAIBase ai) {
        SetBattleAIEvent event = new SetBattleAIEvent(this.bc, this, ai);
        Pixelmon.EVENT_BUS.post((Event)event);
        this.battleAI = event.getAI();
    }

    public void sendMessage(PixelmonPacket message) {
    }

    public void onEndTurn(BattleController bc) {
    }

    public boolean onTakeTurn(BattleController bc, PixelmonWrapper pw) {
        return false;
    }

    public boolean onUseAttack(BattleController bc, PixelmonWrapper pw) {
        return false;
    }

    public void onUseAttackPost(BattleController bc, PixelmonWrapper pw) {
    }

    public boolean onAddStatus(BattleController bc, PixelmonWrapper user, PixelmonWrapper target, StatusBase status) {
        return false;
    }

    public float onHit(PixelmonWrapper source, float damage, DamageTypeEnum damageType) {
        return damage;
    }

    public void onOpponentKO(BattleController bc, PixelmonWrapper pw) {
    }

    public boolean onTargeted(PixelmonWrapper user, Attack attack) {
        return false;
    }

    public boolean onUseAttackOther(BattleController bc, Attack attack, BattleParticipant bp, PixelmonWrapper user) {
        return false;
    }

    public void onSwitchIn(BattleController bc, PixelmonWrapper pw) {
    }

    public void retrieveEntityDuringBattleUnlessRiding(PixelmonWrapper pw) {
        if (pw.entity != null && (!pw.entity.hasOwner() || pw.entity.hasOwner() && pw.entity.m_269323_() != null && !pw.entity.m_20363_((Entity)pw.entity.m_269323_()) || pw.isFainted())) {
            pw.entity.m_6089_();
            pw.entity.retrieve("EndOfBattle");
        }
    }
}

