/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.battles.controller.SpeedComparator;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.MoveOrderModifier;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class SpeedPriorityComparator
extends SpeedComparator {
    @Override
    protected boolean doesGoFirst(PixelmonWrapper p, PixelmonWrapper foe) {
        if (p.hasMoved() != foe.hasMoved()) {
            return p.hasMoved();
        }
        if (p.hasStatus(StatusType.MoveOrderModifier) || foe.hasStatus(StatusType.MoveOrderModifier)) {
            return this.doesModifiedOrderGoFirst(p, foe);
        }
        if (p.priority != foe.priority) {
            return p.priority > foe.priority;
        }
        return super.doesGoFirst(p, foe);
    }

    protected boolean doesModifiedOrderGoFirst(PixelmonWrapper p, PixelmonWrapper foe) {
        StatusBase statusBase = p.getStatus(StatusType.MoveOrderModifier);
        if (statusBase instanceof MoveOrderModifier) {
            MoveOrderModifier pMod = (MoveOrderModifier)statusBase;
            return pMod.participantMovesFirst(p, foe);
        }
        statusBase = foe.getStatus(StatusType.MoveOrderModifier);
        if (statusBase instanceof MoveOrderModifier) {
            MoveOrderModifier foeMod = (MoveOrderModifier)statusBase;
            return !foeMod.movesFirst;
        }
        return super.doesGoFirst(p, foe);
    }
}

