/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.SpeedAbilityComparator;
import com.pixelmonmod.pixelmon.battles.controller.SpeedComparator;
import com.pixelmonmod.pixelmon.battles.controller.SpeedPriorityComparator;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.tools.MutableBoolean;
import java.util.ArrayList;
import java.util.List;

public class BattlePriorityHelper {
    public static final SpeedPriorityComparator SPEED_PRIORITY_COMPARATOR = new SpeedPriorityComparator();
    public static final SpeedAbilityComparator SPEED_ABILITY_COMPARATOR = new SpeedAbilityComparator();
    public static final SpeedComparator SPEED_COMPARATOR = new SpeedComparator();

    public static void checkMoveSpeed(BattleController bc) {
        ArrayList<PixelmonWrapper> fullParticipants = new ArrayList<PixelmonWrapper>(6);
        for (BattleParticipant p : bc.participants) {
            fullParticipants.addAll(p.controlledPokemon);
        }
        ArrayList<PixelmonWrapper> filteredParticipants = new ArrayList<PixelmonWrapper>(fullParticipants.size());
        for (PixelmonWrapper fullParticipant : fullParticipants) {
            if (!fullParticipant.isAlive()) continue;
            filteredParticipants.add(fullParticipant);
        }
        BattlePriorityHelper.sortByMoveSpeed(bc, filteredParticipants);
        bc.turnList = filteredParticipants;
    }

    private static void sortByMoveSpeed(BattleController bc, List<PixelmonWrapper> participants) {
        for (PixelmonWrapper participant : participants) {
            if (bc.simulateMode) continue;
            participant.priority = BattlePriorityHelper.calculatePriority(participant);
        }
        participants.sort(SPEED_PRIORITY_COMPARATOR);
        if (!bc.simulateMode) {
            for (PixelmonWrapper participant : participants) {
                if (participant.attack == null) continue;
                for (EffectBase e : participant.attack.getMove().effects) {
                    if (e == null) continue;
                    e.applyEarlyEffect(participant);
                }
            }
        }
    }

    public static void recalculateMoveSpeed(BattleController bc, int turn) {
        ArrayList<PixelmonWrapper> toMove = new ArrayList<PixelmonWrapper>();
        while (bc.turnList.size() > turn) {
            toMove.add(bc.turnList.remove(turn));
        }
        BattlePriorityHelper.sortByMoveSpeed(bc, toMove);
        for (PixelmonWrapper pixelmonWrapper : toMove) {
            if (!pixelmonWrapper.isAlive()) continue;
            bc.turnList.add(pixelmonWrapper);
        }
    }

    static List<PixelmonWrapper> getDefaultTurnOrder(BattleController bc) {
        ArrayList<PixelmonWrapper> turnOrder = new ArrayList<PixelmonWrapper>(6);
        for (BattleParticipant p : bc.participants) {
            turnOrder.addAll(p.controlledPokemon);
        }
        turnOrder.sort(SPEED_COMPARATOR);
        return turnOrder;
    }

    public static List<PixelmonWrapper> getTurnOrder(List<PixelmonWrapper> pokemon) {
        ArrayList<PixelmonWrapper> turnOrder = new ArrayList<PixelmonWrapper>(6);
        turnOrder.addAll(pokemon);
        turnOrder.sort(SPEED_COMPARATOR);
        return turnOrder;
    }

    public static List<PixelmonWrapper> getRedirectOrder(List<PixelmonWrapper> pokemon) {
        ArrayList<PixelmonWrapper> turnOrder = new ArrayList<PixelmonWrapper>(6);
        turnOrder.addAll(pokemon);
        turnOrder.sort(SPEED_ABILITY_COMPARATOR);
        return turnOrder;
    }

    public static float calculatePriority(PixelmonWrapper p) {
        float priority = 0.0f;
        if (p.willTryFlee && p.getParticipant().getType() != ParticipantType.WildPokemon) {
            priority = 8.0f;
        } else if (p.willUseItemInStack != null || p.isSwitching) {
            priority = 6.0f;
        } else if (p.attack != null) {
            if (!p.usingZ || p.attack.getMove().getAttackCategory() == AttackCategory.STATUS) {
                priority = p.isDynamax == 1 ? (float)MaxMoveConverter.getMaxMoveFromAttack(p.attack, p).getMove().getPriority(p) : (p.isDynamax == 2 ? (float)MaxMoveConverter.getGMaxMoveFromAttack(p.attack, p, p.getSpecies(), p.getForm().getName().contains("gmax") ? p.getPrevForm() : p.getForm()).getMove().getPriority(p) : (float)p.attack.getMove().getPriority(p));
            }
            MutableBoolean triggered = new MutableBoolean(false);
            priority = p.getBattleAbility().modifyPriority(p, priority, triggered);
            priority = p.getUsableHeldItem().modifyPriority(p, priority, triggered);
            if (p.attack.isAttack(AttackRegistry.PURSUIT) && !p.usingZ) {
                for (PixelmonWrapper target : p.targets) {
                    if (!target.isSwitching || !target.isAlive()) continue;
                    priority = 7.0f;
                    break;
                }
            }
        }
        return priority;
    }
}

