/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimation;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleResults;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.ForceBattleEndResult;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.LostToWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.SpawnPixelmonEntityForBattleEvent;
import com.pixelmonmod.pixelmon.api.events.battles.ApplyBonusStatsEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.SpectateEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Pickup;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.RunAway;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BonusStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.BattlePriorityHelper;
import com.pixelmonmod.pixelmon.battles.controller.BattleStage;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.FutureBattleTask;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleLog;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.BattleEndAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.BattleMessageAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.FleeAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.TurnBeginAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.TurnEndAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.Hail;
import com.pixelmonmod.pixelmon.battles.status.Rainy;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.battles.tasks.FailedSwitchFleeTask;
import com.pixelmonmod.pixelmon.battles.tasks.SwitchOutTask;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.PixelmonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SwitchCameraPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.DynamaxMegaRulePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EndSpectatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.FormBattleUpdatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UpdateTurnPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.init.registry.PixelmonBiomeTags;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.tools.Quadstate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.eventbus.api.Event;

public class BattleController {
    public List<BattleParticipant> participants = new ArrayList<BattleParticipant>();
    public GlobalStatusController globalStatusController = new GlobalStatusController(this);
    public List<Spectator> spectators = new ArrayList<Spectator>();
    protected int battleTicks = 0;
    public int battleTurn = -1;
    public int playerNumber = 0;
    public boolean battleEnded = false;
    public int battleIndex;
    public BattleLog battleLog;
    public Attack lastAttack;
    public Attack lastSimulatedAttack;
    public Attack lastTempAttack;
    public Attack lastSimulatedTempAttack;
    public int numFainted;
    public BattleRules rules;
    public boolean simulateMode = false;
    public boolean simulateStats = false;
    public boolean sendMessages = true;
    public boolean wasFishing = false;
    public Quadstate oldGen = Quadstate.BOTH;
    private boolean isSwitchTurn = false;
    private HashMap<PixelmonWrapper, PixelmonWrapper> switchedIn = new HashMap();
    private boolean haveSwitched = false;
    private boolean haveEvolved = false;
    private List<PixelmonWrapper> switchingOut = new ArrayList<PixelmonWrapper>();
    private List<PixelmonWrapper> abilityGainOrder = new ArrayList<PixelmonWrapper>();
    private static final int TICK_TOP = 20;
    private boolean hasAppliedRepeatedEffects = false;
    public static ArrayList<AttackAnimation> currentAnimations;
    public Set<Pokemon> checkedPokemon = Sets.newHashSet();
    protected boolean frozen = false;
    protected boolean forceChance = false;
    protected final List<FutureBattleTask<?, ?>> futureTasks = Lists.newCopyOnWriteArrayList();
    private boolean init = false;
    private BattleStage stage = BattleStage.PICKACTION;
    public int actionIndex = 0;
    public List<PixelmonWrapper> turnList = new ArrayList<PixelmonWrapper>();
    private int doLaterTicks = 0;
    private Runnable doLaterAction = null;
    boolean paused = false;

    public BattleController(BattleParticipant[] team1, BattleParticipant[] team2, BattleRules rules) {
        this.setupTeam(team1, 0);
        this.setupTeam(team2, 1);
        this.rules = rules;
        this.battleLog = new BattleLog(this);
        this.battleLog.logEvent(new TurnBeginAction(0, this.globalStatusController.getTerrain(), this.globalStatusController.getWeather(), this.getActivePokemon()));
    }

    private void setupTeam(BattleParticipant[] team, int teamId) {
        int battlePositionId = 0;
        for (BattleParticipant battleParticipant : team) {
            if (battleParticipant.controlledPokemon.isEmpty()) {
                for (PixelmonWrapper pw : battleParticipant.allPokemon) {
                    if (!pw.isAlive()) continue;
                    battleParticipant.controlledPokemon.add(pw);
                    break;
                }
            }
            for (PixelmonWrapper pixelmonWrapper : battleParticipant.controlledPokemon) {
                pixelmonWrapper.battlePosition = battlePositionId++;
                pixelmonWrapper.onBattlefield = true;
                pixelmonWrapper.bc = this;
            }
            battleParticipant.team = teamId;
            battleParticipant.bc = this;
            this.participants.add(battleParticipant);
        }
    }

    protected void initBattle() throws IllegalStateException {
        for (BattleParticipant p : this.participants) {
            if (p.checkPokemon()) continue;
            throw new IllegalStateException("Battle could not start!");
        }
        this.setGenerationSettings();
        for (BattleParticipant p : this.participants) {
            p.startBattle();
        }
        this.modifyStats();
        List<PixelmonWrapper> turnOrder = this.getDefaultTurnOrder();
        for (PixelmonWrapper pw : turnOrder) {
            pw.getBattleAbility().beforeSwitch(pw);
        }
        block3: for (BattleParticipant p : this.participants) {
            p.updateOtherPokemon();
            for (PixelmonWrapper pokemon : p.allPokemon) {
                if (pokemon == null) continue;
                if (pokemon.getSpecies().is(PixelmonSpecies.XERNEAS) && pokemon.getForm().isForm("neutral")) {
                    pokemon.setForm("active");
                }
                pokemon.getHeldItem().onStartOfBattle(pokemon);
                pokemon.pokemon.lastBattleCrits = 0;
            }
            for (PixelmonWrapper pw : p.controlledPokemon) {
                BonusStats bonusStats;
                pw.addAttackers();
                ApplyBonusStatsEvent.Pre applyBonusStatsEventPre = new ApplyBonusStatsEvent.Pre(this, pw.pokemon, pw.pokemon.getBonusStats());
                Pixelmon.EVENT_BUS.post((Event)applyBonusStatsEventPre);
                if (!applyBonusStatsEventPre.isCanceled() && (bonusStats = applyBonusStatsEventPre.getBonusStats()).modifyPokemon(pw)) {
                    BattleStatsType stat = bonusStats.getStatModified();
                    this.sendToAll("pixelmon.battletext.aura", pw.getNickname());
                    int rank = Math.min(3, bonusStats.getStatModificationRank());
                    this.sendToAll((stat != null ? "pixelmon.battletext.statsrosespecific" : "pixelmon.battletext.statsrose") + rank, stat != null ? stat.getTranslatedName() : "");
                    ApplyBonusStatsEvent.Post applyBonusStatsEventPost = new ApplyBonusStatsEvent.Post(this, pw.pokemon, bonusStats);
                    Pixelmon.EVENT_BUS.post((Event)applyBonusStatsEventPost);
                }
                pw.getBattleStats().setLoweredThisTurn(false);
                pw.getBattleStats().setRaisedThisTurn(false);
            }
            for (PixelmonWrapper apw : p.allPokemon) {
                if (apw == null) continue;
                for (BattleParticipant o : p.getOpponents()) {
                    for (PixelmonWrapper opw : o.controlledPokemon) {
                        apw.getBattleAbility().applyStartOfBattleHeadOfPartyEffect(apw, opw);
                    }
                }
                continue block3;
            }
        }
        for (BattleParticipant p : this.participants) {
            if (!(p instanceof PlayerParticipant)) continue;
            PlayerParticipant player = (PlayerParticipant)p;
            player.openGui();
            if (player.getEntity() instanceof ServerPlayer) {
                NetworkHelper.sendPacket(new DynamaxMegaRulePacket(this.oldGen), (ServerPlayer)player.getEntity());
            }
            ++this.playerNumber;
        }
        this.setOverworldWeatherAsBattleWeather();
        this.battleTurn = 0;
        this.doLater(() -> {
            String loc;
            for (BattleParticipant participant : this.participants) {
                for (PixelmonWrapper pw : participant.allPokemon) {
                    pw.getBattleAbility().applyStartOfBattleEffect(pw);
                }
            }
            for (PixelmonWrapper pw : turnOrder) {
                pw.afterSwitch();
            }
            for (PixelmonWrapper pw : turnOrder) {
                pw.getBattleAbility().applyPostSwitchEffect(pw);
                pw.getUsableHeldItem().applyPostSwitchEffect(pw);
            }
            PlayerParticipant playerParticipant = null;
            TrainerParticipant trainerParticipant = null;
            for (BattleParticipant bp : this.participants) {
                if (bp instanceof PlayerParticipant) {
                    playerParticipant = (PlayerParticipant)bp;
                } else if (bp instanceof TrainerParticipant) {
                    trainerParticipant = (TrainerParticipant)bp;
                }
                for (PixelmonWrapper pw : bp.allPokemon) {
                    this.updateFormChange(pw);
                }
            }
            if (playerParticipant != null && trainerParticipant != null && trainerParticipant.trainer.getGreeting(loc = ((ServerPlayer)playerParticipant.getEntity()).getLanguage()) != null) {
                ChatHandler.sendBattleMessage((Entity)playerParticipant.player, trainerParticipant.trainer.getName(loc) + ": " + trainerParticipant.trainer.getGreeting(loc), new Object[0]);
            }
            this.sendToPlayers(new UpdateTurnPacket(this.battleTurn));
        }, 10);
        this.init = true;
    }

    private void setGenerationSettings() {
        switch (this.rules.getOrDefault(BattleRuleRegistry.GEN_MODE)) {
            case None: {
                this.oldGen = Quadstate.NONE;
                break;
            }
            case Both: {
                this.oldGen = Quadstate.BOTH;
                break;
            }
            case Mega: {
                this.oldGen = Quadstate.YES;
                break;
            }
            case Dynamax: {
                this.oldGen = Quadstate.NO;
                break;
            }
            case World: {
                ResourceKey dim = this.participants.get((int)0).getEntity().f_19853_.m_46472_();
                boolean oldGenDimension = PixelmonConfigProxy.getGeneral().getOldGenDimensions().contains(dim.toString());
                boolean bothGenDimension = PixelmonConfigProxy.getGeneral().getBothGenDimensions().contains(dim.toString());
                boolean relaxedRules = PixelmonConfigProxy.getBattle().isRelaxedBattleGimmickRules();
                if (this.isPvP()) {
                    int megaRings = 0;
                    int dynaBands = 0;
                    for (BattleParticipant p : this.participants) {
                        if (!(p instanceof PlayerParticipant)) continue;
                        PlayerParticipant pp = (PlayerParticipant)p;
                        if (pp.party.getMegaItem().canMega()) {
                            ++megaRings;
                        }
                        if (!pp.party.getMegaItem().canDynamax()) continue;
                        ++dynaBands;
                    }
                    if (bothGenDimension || relaxedRules) {
                        this.oldGen = Quadstate.BOTH;
                        break;
                    }
                    if (oldGenDimension && megaRings == 0 && dynaBands > 0) {
                        this.oldGen = Quadstate.NO;
                        break;
                    }
                    if (!oldGenDimension && dynaBands == 0 && megaRings > 0) {
                        this.oldGen = Quadstate.YES;
                        break;
                    }
                    this.oldGen = Quadstate.valueOf(oldGenDimension);
                    break;
                }
                boolean npcOverride = false;
                block14: for (BattleParticipant p : this.participants) {
                    if (!(p instanceof TrainerParticipant) || !(p.getEntity() instanceof NPCTrainer)) continue;
                    TrainerParticipant t = (TrainerParticipant)p;
                    NPCTrainer npc = (NPCTrainer)t.getEntity();
                    npcOverride = true;
                    switch (npc.getOldGen()) {
                        case None: {
                            this.oldGen = Quadstate.NONE;
                            continue block14;
                        }
                        case Both: {
                            this.oldGen = Quadstate.BOTH;
                            continue block14;
                        }
                        case Mega: {
                            this.oldGen = Quadstate.YES;
                            continue block14;
                        }
                        case Dynamax: {
                            this.oldGen = Quadstate.NO;
                            continue block14;
                        }
                    }
                    npcOverride = false;
                }
                if (npcOverride) break;
                this.oldGen = bothGenDimension || relaxedRules ? Quadstate.BOTH : Quadstate.valueOf(oldGenDimension);
            }
        }
    }

    public void doLater(Runnable runnable, int ticks) {
        this.doLaterTicks = ticks;
        this.doLaterAction = runnable;
    }

    public void update() {
        block10: {
            if (this.battleEnded) {
                BattleRegistry.deRegisterBattle(this);
                return;
            }
            Pixelmon.EVENT_BUS.post((Event)new BattleTickEvent.Pre(this));
            try {
                boolean hasAnimationsPlaying;
                if (!this.init) {
                    try {
                        this.initBattle();
                    }
                    catch (Exception e) {
                        BattleRegistry.deRegisterBattle(this);
                        e.printStackTrace();
                        this.init = false;
                        this.endBattle(BattleEndCause.FORCE);
                        return;
                    }
                }
                this.onUpdate();
                if (this.isFrozen()) {
                    return;
                }
                boolean bl = hasAnimationsPlaying = CollectionHelper.find(currentAnimations, animation -> animation.bc == this) != null;
                if (hasAnimationsPlaying || this.isEvolving() || this.isWaiting() || this.paused || this.simulateMode || this.participants.size() < 2) {
                    return;
                }
                if (this.battleTicks++ > 20) {
                    this.doTurnLogic();
                    this.battleTicks = 0;
                }
            }
            catch (Exception e) {
                if (this.battleLog != null) {
                    this.battleLog.onCrash(e, "Caught error in battle. Continuing...");
                }
                if (!PixelmonConfigProxy.getGeneral().getDebug().isPrintErrors()) break block10;
                Pixelmon.LOGGER.info("Caught error in battle. Continuing...");
                e.printStackTrace();
            }
        }
        Pixelmon.EVENT_BUS.post((Event)new BattleTickEvent.Post(this));
    }

    public void takeFullTurn() {
        this.takeFullTurn(null);
    }

    public void advanceToMoves() {
        if (this.stage == BattleStage.PICKACTION) {
            this.doTurnLogic();
        }
        if (this.stage == BattleStage.DOACTION && this.actionIndex == -1) {
            this.doTurnLogic();
        }
    }

    public void takeFullTurn(Runnable moveSelection) {
        if (moveSelection != null) {
            moveSelection.run();
        }
        this.doTurnLogic();
        this.doTurnLogic();
        while (this.stage != BattleStage.PICKACTION) {
            this.doTurnLogic();
        }
    }

    public void doTurnLogic() {
        if (this.stage == BattleStage.PICKACTION) {
            for (BattleParticipant p : this.participants) {
                p.clearTurnVariables();
                p.selectAction();
            }
            this.stage = BattleStage.DOACTION;
            this.actionIndex = -1;
        } else if (this.stage == BattleStage.DOACTION) {
            this.modifyStats();
            this.calculateTurnOrder();
            if (this.actionIndex == -1) {
                this.updateTurnZero();
            } else {
                this.refreshControlledPokemonEntities();
                this.actionIndex = -1;
                for (int i = 0; i < this.turnList.size(); ++i) {
                    if (this.turnList.get(i).hasMoved()) continue;
                    this.actionIndex = i;
                    break;
                }
                if (this.actionIndex == -1) {
                    this.stage = BattleStage.ENDTURN;
                } else {
                    this.participants.stream().filter(bp -> bp.getType() == ParticipantType.Player).forEach(bp -> {
                        bp.wait = true;
                    });
                    PixelmonWrapper currentPokemon = this.turnList.get(this.actionIndex);
                    this.modifyStatsCancellable(currentPokemon);
                    this.takeTurn(currentPokemon);
                    this.checkPokemon();
                }
            }
        }
        if (this.stage == BattleStage.ENDTURN) {
            if (!this.hasAppliedRepeatedEffects) {
                this.applyRepeatedEffects();
                this.hasAppliedRepeatedEffects = true;
            }
            this.checkPokemon();
            this.checkFaint();
            if (!this.isWaiting()) {
                this.endTurn();
            }
        }
    }

    public void updateTurnZero() {
        if (!this.simulateMode) {
            if (!this.haveSwitched) {
                try {
                    this.haveSwitched = true;
                    this.setupForSyncronizedSwitches();
                    for (PixelmonWrapper nextFastestPokemon : Lists.newArrayList(this.turnList)) {
                        if (!this.switchThisTurn(nextFastestPokemon)) continue;
                        nextFastestPokemon.setMoved(true);
                    }
                    this.handlePostSynchronizedSwitches();
                }
                catch (Exception exc) {
                    this.battleLog.onCrash(exc, "Problem switching out a Pok\u00e9mon.");
                }
            }
            if (!this.haveEvolved) {
                try {
                    this.haveEvolved = true;
                    for (PixelmonWrapper currentPokemon : this.getActivePokemon()) {
                        boolean hasEvolved = false;
                        for (PixelmonWrapper pw : this.getDefaultTurnOrder()) {
                            if (!pw.willEvolve || !pw.canEvolve()) continue;
                            hasEvolved = pw.megaEvolve() || hasEvolved;
                        }
                        if (!hasEvolved) continue;
                        return;
                    }
                }
                catch (Exception exc) {
                    this.battleLog.onCrash(exc, "Problem Mega Evolving or Dynamaxing.");
                }
            }
            this.actionIndex = 0;
        }
    }

    private void refreshControlledPokemonEntities() {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper poke : p.controlledPokemon) {
                if (poke.entity == null || poke.entity.isLoaded(true)) continue;
                poke.entity.retrieve("Forced");
                if (this.getPlayers().isEmpty()) {
                    this.endBattle(BattleEndCause.FORCE);
                    return;
                }
                poke.entity.m_142687_(Entity.RemovalReason.DISCARDED);
                poke.entity.releaseFromPokeball();
                poke.entity.f_19802_ = 0;
            }
        }
    }

    private void setupForSyncronizedSwitches() {
        this.isSwitchTurn = true;
        this.switchedIn.clear();
    }

    private void handlePostSynchronizedSwitches() {
        this.isSwitchTurn = false;
        ArrayList<PixelmonWrapper> switches = new ArrayList<PixelmonWrapper>(this.switchedIn.keySet());
        for (PixelmonWrapper newPokemon : BattlePriorityHelper.getTurnOrder(switches)) {
            newPokemon.afterSwitch(this.switchedIn.get(newPokemon));
        }
        this.checkPostAllSwitchEffects();
    }

    private void checkPostAllSwitchEffects() {
        List<PixelmonWrapper> liveSwitchedPokemon = new ArrayList<PixelmonWrapper>();
        for (PixelmonWrapper pw : this.getActiveUnfaintedPokemon()) {
            if (!pw.switchedThisTurn) continue;
            liveSwitchedPokemon.add(pw);
        }
        liveSwitchedPokemon = BattlePriorityHelper.getTurnOrder(liveSwitchedPokemon);
        for (PixelmonWrapper pw : liveSwitchedPokemon) {
            pw.getBattleAbility().applyPostSwitchEffect(pw);
            pw.getUsableHeldItem().applyPostSwitchEffect(pw);
        }
    }

    private void calculateTurnOrder() {
        try {
            BattlePriorityHelper.checkMoveSpeed(this);
        }
        catch (Exception exc) {
            this.battleLog.onCrash(exc, "Problem checking move speed.");
        }
    }

    private boolean isEvolving() {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.evolution == null) continue;
                if (pw.evolution.isEnded()) {
                    pw.evolution = null;
                    if (!pw.nextSwitchIsMove) {
                        p.wait = false;
                        pw.wait = false;
                    }
                    String path = "";
                    if (pw.pokemon.getSpecies().is(PixelmonSpecies.GRENINJA)) {
                        path = "ashgreninja.evolve";
                    } else if (pw.pokemon.getSpecies().is(PixelmonSpecies.NECROZMA)) {
                        path = "ultraburst";
                    } else if (pw.pokemon.getUUID().equals(p.evolution)) {
                        path = "megaevolve";
                    } else if (pw.pokemon.getUUID().equals(p.dynamax)) {
                        path = pw.canGigantamax() ? "gigantamax" : "dynamax";
                    }
                    if (path.isEmpty()) continue;
                    this.sendToAll("pixelmon.battletext." + path, pw.getNickname(), pw.pokemon.getLocalizedName());
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public void modifyStats() {
        for (BattleParticipant p : this.participants) {
            p.controlledPokemon.forEach(this::modifyStats);
        }
    }

    public void modifyStats(PixelmonWrapper pw) {
        int[] stats = pw.getBattleStats().getBaseBattleStats();
        for (int i = 0; i < pw.getStatusSize(); ++i) {
            stats = pw.getStatus(i).modifyStats(pw, stats);
        }
        stats = pw.getBattleAbility().modifyStats(pw, stats);
        for (PixelmonWrapper teammate : this.getTeamPokemon(pw)) {
            stats = teammate.getBattleAbility().modifyStatsTeammate(pw, stats);
        }
        for (PixelmonWrapper other : this.getActivePokemon()) {
            if (pw == other) continue;
            stats = other.getBattleAbility().modifyStatsOther(pw, stats);
        }
        stats = pw.getUsableHeldItem().modifyStats(pw, stats);
        for (GlobalStatusBase gsb : this.globalStatusController.getGlobalStatuses()) {
            stats = gsb.modifyStats(pw, stats);
        }
        pw.getBattleStats().setStatsForTurn(stats);
    }

    public void modifyStats(PixelmonWrapper pw, int[] stats) {
        for (int i = 0; i < pw.getStatusSize(); ++i) {
            stats = pw.getStatus(i).modifyStats(pw, stats);
        }
        stats = pw.getBattleAbility().modifyStats(pw, stats);
        for (PixelmonWrapper teammate : this.getTeamPokemon(pw)) {
            stats = teammate.getBattleAbility().modifyStatsTeammate(pw, stats);
        }
        stats = pw.getUsableHeldItem().modifyStats(pw, stats);
        for (GlobalStatusBase gsb : this.globalStatusController.getGlobalStatuses()) {
            stats = gsb.modifyStats(pw, stats);
        }
        pw.getBattleStats().setStatsForTurn(stats);
    }

    public void modifyStatsCancellable(PixelmonWrapper attacker) {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                StatusBase status;
                int i;
                int[] stats = pw.getBattleStats().getBattleStats();
                if (!AbilityRegistry.ignoreAbility(attacker, pw) || !attacker.targets.contains(pw)) {
                    stats = pw.getBattleAbility().modifyStatsCancellable(pw, stats);
                    for (PixelmonWrapper teammate : this.getTeamPokemon(pw)) {
                        stats = teammate.getBattleAbility().modifyStatsCancellableTeammate(pw, stats);
                    }
                    for (PixelmonWrapper other : this.getActivePokemon()) {
                        if (pw == other) continue;
                        stats = other.getBattleAbility().modifyStatsCancellableOther(other, pw, stats);
                    }
                }
                for (i = 0; i < pw.getStatusSize(); ++i) {
                    status = pw.getStatus(i);
                    if (status.ignoreStatus(attacker, pw)) continue;
                    stats = status.modifyStatsCancellable(pw, stats);
                }
                for (i = 0; i < pw.bc.globalStatusController.getGlobalStatusSize(); ++i) {
                    status = pw.bc.globalStatusController.getGlobalStatus(i);
                    if (status.ignoreStatus(attacker, pw)) continue;
                    stats = status.modifyStatsCancellable(pw, stats);
                }
                pw.getBattleStats().setStatsForTurn(stats);
            }
        }
    }

    public void participantReady(PlayerParticipant p) {
        p.wait = false;
    }

    public void setAllReady() {
        for (PlayerParticipant player : this.getPlayers()) {
            this.participantReady(player);
        }
    }

    private void applyRepeatedEffects() {
        boolean teamAble = false;
        boolean opponentAble = false;
        BattleParticipant participant = this.participants.get(0);
        for (PixelmonWrapper pw : this.getTeamPokemon(participant)) {
            if (!pw.isAlive()) continue;
            teamAble = true;
            break;
        }
        if (!teamAble) {
            for (BattleParticipant p : this.getTeam(this.participants.get(0))) {
                if (p.countAblePokemon() <= 0) continue;
                teamAble = true;
                break;
            }
        }
        for (PixelmonWrapper pw : this.getOpponentPokemon(participant)) {
            if (!pw.isAlive()) continue;
            opponentAble = true;
            break;
        }
        if (!opponentAble) {
            for (BattleParticipant p : this.getOpponents(this.participants.get(0))) {
                if (p.countAblePokemon() <= 0) continue;
                opponentAble = true;
                break;
            }
        }
        this.setOverworldWeatherAsBattleWeatherDuringBattle();
        if (teamAble && opponentAble) {
            for (GlobalStatusBase gsb : this.globalStatusController.getGlobalStatuses()) {
                gsb.applyRepeatedEffect(this.globalStatusController);
            }
            for (PixelmonWrapper pw : this.getDefaultTurnOrder()) {
                pw.turnTick();
            }
            for (PixelmonWrapper pw : this.getDefaultTurnOrder()) {
                if (pw.attack == null || pw.attack.getMove().effects == null) continue;
                for (EffectBase effectBase : pw.attack.getMove().effects) {
                    effectBase.applyEffectAfterStatus(pw);
                }
            }
        }
    }

    public void endTurn() {
        this.battleLog.logEvent(new TurnEndAction(this.battleTurn, this.globalStatusController.getTerrain(), this.globalStatusController.getWeather(), this.getActivePokemon()));
        for (PixelmonWrapper pw2 : this.getDefaultTurnOrder()) {
            pw2.endTurn();
        }
        this.stage = BattleStage.PICKACTION;
        for (BattleParticipant p : this.participants) {
            p.onEndTurn(this);
            for (PixelmonWrapper pw3 : p.controlledPokemon) {
                if (pw3.isDynamax <= 0) continue;
                --pw3.dynamaxTurns;
                if (pw3.dynamaxTurns > 0) continue;
                pw3.dynamax(true, pw3.getHealthPercent());
            }
            for (PixelmonWrapper pw4 : p.allPokemon) {
                pw4.setMoved(false);
            }
        }
        this.getActivePokemon().forEach(pw -> {
            pw.getBattleStats().setLoweredThisTurn(false);
            pw.getBattleStats().setRaisedThisTurn(false);
        });
        this.haveSwitched = false;
        this.haveEvolved = false;
        this.hasAppliedRepeatedEffects = false;
        int turnNumber = this.battleTurn++;
        this.battleLog.turnTick(this.battleTurn);
        this.battleLog.logEvent(new TurnBeginAction(this.battleTurn, this.globalStatusController.getTerrain(), this.globalStatusController.getWeather(), this.getActivePokemon()));
        this.sendToPlayers(new UpdateTurnPacket(this.battleTurn));
        Pixelmon.EVENT_BUS.post((Event)new TurnEndEvent(this, turnNumber));
    }

    public void checkReviveSendOut(BattleParticipant p) {
        if (!this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).areSlotsLocked() && this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon() > 1 && p != null && p.getType() == ParticipantType.Player && this.getTeam(p).size() == 1 && p.controlledPokemon.size() < this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon() && p.countAblePokemon() > p.controlledPokemon.size()) {
            PlayerParticipant player = (PlayerParticipant)p;
            ArrayList<StatusBase> wholeTeamStatuses = new ArrayList<StatusBase>();
            Iterator<PixelmonWrapper> iterator = p.controlledPokemon.iterator();
            if (iterator.hasNext()) {
                PixelmonWrapper pw = iterator.next();
                wholeTeamStatuses = new ArrayList();
                for (StatusBase status : pw.getStatuses()) {
                    if (!status.isWholeTeamStatus()) continue;
                    wholeTeamStatuses.add(status.copy());
                }
            }
            int oldPosition = 0;
            int newPosition = 0;
            do {
                oldPosition = newPosition;
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    if (newPosition != pw.battlePosition) continue;
                    ++newPosition;
                }
            } while (oldPosition != newPosition);
        }
    }

    public void reviveAfterDefeat(BattleParticipant p) {
        if (p != null) {
            ArrayList<StatusBase> wholeTeamStatuses = new ArrayList<StatusBase>();
            Iterator<PixelmonWrapper> iterator = p.controlledPokemon.iterator();
            if (iterator.hasNext()) {
                PixelmonWrapper pw = iterator.next();
                wholeTeamStatuses = new ArrayList();
                for (StatusBase statusBase : pw.getStatuses()) {
                    if (!statusBase.isWholeTeamStatus()) continue;
                    wholeTeamStatuses.add(statusBase.copy());
                }
            }
            int oldPosition = 0;
            int newPosition = 0;
            do {
                oldPosition = newPosition;
                for (PixelmonWrapper pixelmonWrapper : p.controlledPokemon) {
                    if (newPosition != pixelmonWrapper.battlePosition) continue;
                    ++newPosition;
                }
            } while (oldPosition != newPosition);
            PixelmonWrapper revived = null;
            for (PixelmonWrapper pw : p.allPokemon) {
                if (!pw.isAlive() || pw.entity != null) continue;
                revived = pw;
                if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(p.getStorage().find(pw.getPokemonUUID())))) break;
                PixelmonEntity revivedPokemon = p.getStorage().find(pw.getPokemonUUID()).getOrSpawnPixelmon((Entity)p.getEntity());
                revivedPokemon.m_21153_(pw.getHealth());
                pw.update(EnumUpdateType.HP);
                revivedPokemon.battleController = this;
                revived.entity = revivedPokemon;
                revivedPokemon.setPixelmonToFlyForBattle();
                Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(p.getStorage().find(pw.getPokemonUUID()), revivedPokemon));
                break;
            }
            if (revived == null) {
                return;
            }
            revived.battlePosition = newPosition;
            revived.onBattlefield = true;
            for (StatusBase status : wholeTeamStatuses) {
                revived.addStatus(status, revived);
            }
            p.controlledPokemon.add(newPosition, revived);
            revived.bc = p.bc;
            PartyStorage partyStorage = p.getStorage();
            if (partyStorage == null) {
                this.endBattle(BattleEndCause.FORCE);
                return;
            }
            if (!AbilityRegistry.ignoreAbility(revived, this)) {
                revived.getBattleAbility().beforeSwitch(revived);
            }
            ChatHandler.sendBattleMessage((Entity)p.getEntity(), "playerparticipant.go", revived.getNickname());
            this.sendToOthers("battlecontroller.sendout", p, p.getDisplayName(), revived.getNickname());
            for (BattleParticipant p2 : this.participants) {
                p2.updateOtherPokemon();
            }
            revived.afterSwitch();
            revived.addAttackers();
            this.sendSwitchPacket(null, revived);
        }
    }

    void checkFaint() {
        ArrayList<PixelmonWrapper> fainted = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : this.participants) {
            ArrayList<PixelmonWrapper> toRemove = new ArrayList<PixelmonWrapper>();
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (!pw.isFainted() || pw.isSwitching) continue;
                if (pw.removePrimaryStatus() != null) {
                    pw.sendStatusPacket(-1);
                }
                pw.update(EnumUpdateType.Status);
                p.updatePokemon(pw);
                if (p.addSwitchingOut(pw)) {
                    fainted.add(pw);
                    continue;
                }
                toRemove.add(pw);
            }
            for (PixelmonWrapper pw : toRemove) {
                pw.isSwitching = false;
                pw.wait = false;
                p.controlledPokemon.remove(pw);
                this.updateRemovedPokemon(pw);
            }
        }
        this.switchingOut.addAll(fainted);
        for (PixelmonWrapper pw : fainted) {
            if (pw.entity != null) {
                pw.entity.setEvoStage(null);
            }
            pw.wait = false;
            BattleParticipant p = pw.getParticipant();
            p.updateLastFaintedTurn();
            pw.willTryFlee = false;
            p.wait = true;
            p.getNextPokemon(pw.battlePosition);
        }
    }

    private void onUpdate() {
        if (this.doLaterTicks > 0) {
            --this.doLaterTicks;
            if (this.doLaterTicks == 0) {
                this.doLaterAction.run();
            }
        }
        for (BattleParticipant participant : this.participants) {
            participant.tick();
            if (!(participant instanceof PlayerParticipant) || participant.getEntity().m_6084_()) continue;
            participant.endBattle(BattleEndCause.FORCE);
        }
    }

    public HashMap<BattleParticipant, BattleResults> endBattle(BattleEndCause cause) {
        return this.endBattle(cause, new HashMap<BattleParticipant, BattleResults>());
    }

    /*
     * Could not resolve type clashes
     */
    public HashMap<BattleParticipant, BattleResults> endBattle(BattleEndCause cause, HashMap<BattleParticipant, BattleResults> results) {
        if (results == null) {
            results = new HashMap();
        }
        this.battleLog.logEvent(new BattleEndAction(this.battleTurn));
        this.spectators.forEach(spectator -> spectator.sendMessage(new EndSpectatePacket()));
        boolean abnormal = false;
        this.battleEnded = true;
        this.globalStatusController.endBattle();
        for (BattleParticipant p : this.participants) {
            PixelmonEntity pixelmonEntity;
            for (PixelmonWrapper pw : p.allPokemon) {
                pw.dynamax(true, pw.getHealthPercent());
            }
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.getBattleAbility() != null) {
                    pw.getBattleAbility().applyEndOfBattleEffect(pw);
                    pw.getHeldItem().onEndOfBattle(pw);
                }
                pw.resetOnSwitch();
                for (StatusBase status : pw.getStatuses()) {
                    status.applyEndOfBattleEffect(pw);
                }
                if (cause == BattleEndCause.FORCE) {
                    pw.setHeldItem(pw.pokemon.getHeldItem());
                }
                if (pw.getHeldItem() == pw.initialCopyOfPokemon.getHeldItemAsItemHeld() || !pw.shouldReturnHeldItem()) continue;
                pw.pokemon.setHeldItem(pw.initialCopyOfPokemon.getHeldItem());
            }
            for (Iterator<BattleParticipant> pokemon : p.allPokemon) {
                if (pokemon == null || p.controlledPokemon.contains(pokemon)) continue;
                ((PixelmonWrapper)((Object)pokemon)).getBattleAbility().applyEndOfBattleEffect((PixelmonWrapper)((Object)pokemon));
                ((PixelmonWrapper)((Object)pokemon)).getHeldItem().onEndOfBattle((PixelmonWrapper)((Object)pokemon));
            }
            if (cause == BattleEndCause.FLEE) {
                results.put(p, BattleResults.FLEE);
            } else if ((cause != BattleEndCause.FORCE || PixelmonConfigProxy.getBattle().getForceEndBattleResult() == ForceBattleEndResult.WINNER) && this.init && cause != BattleEndCause.FORFEIT) {
                Iterator<BattleParticipant> pokemon;
                BattleResults result = BattleResults.DRAW;
                int allyCount = 0;
                int opponentCount = 0;
                for (BattleParticipant teamp : this.getTeam(p)) {
                    allyCount += teamp.countAblePokemon();
                }
                pokemon = this.getOpponents(p).iterator();
                while (pokemon.hasNext()) {
                    BattleParticipant enemyp = pokemon.next();
                    opponentCount += enemyp.countAblePokemon();
                }
                if (allyCount > opponentCount) {
                    result = BattleResults.VICTORY;
                } else if (opponentCount > allyCount) {
                    result = BattleResults.DEFEAT;
                } else {
                    float allyPercent = 0.0f;
                    float opponentPercent = 0.0f;
                    int allyParticipants = 0;
                    int opponentParticipants = 0;
                    for (BattleParticipant teamp : this.getTeam(p)) {
                        allyPercent += teamp.countHealthPercent();
                        ++allyParticipants;
                    }
                    for (BattleParticipant enemyp : this.getOpponents(p)) {
                        opponentPercent += enemyp.countHealthPercent();
                        ++opponentParticipants;
                    }
                    if (allyParticipants == 0) {
                        allyParticipants = 1;
                    }
                    if (opponentParticipants == 0) {
                        opponentParticipants = 1;
                    }
                    result = (allyPercent /= (float)allyParticipants) > (opponentPercent /= (float)opponentParticipants) ? BattleResults.VICTORY : (opponentPercent > allyPercent ? BattleResults.DEFEAT : BattleResults.DRAW);
                }
                results.put(p, result);
            } else if (cause == BattleEndCause.FORCE) {
                if (PixelmonConfigProxy.getBattle().getForceEndBattleResult() == ForceBattleEndResult.DRAW) {
                    results.put(p, BattleResults.DRAW);
                } else {
                    if (PixelmonConfigProxy.getBattle().getForceEndBattleResult() == ForceBattleEndResult.ABNORMAL) {
                        abnormal = true;
                    }
                    results.put(p, BattleResults.DRAW);
                }
            }
            if (p instanceof PlayerParticipant) {
                if (results.get(p) != BattleResults.VICTORY || cause != BattleEndCause.NORMAL) continue;
                Pickup.pickupItem((PlayerParticipant)p);
                continue;
            }
            if (!(p instanceof WildPixelmonParticipant) || (pixelmonEntity = (PixelmonEntity)p.getEntity()) == null) continue;
            if (results.get(p).equals((Object)BattleResults.DEFEAT) || results.get(p).equals((Object)BattleResults.FLEE)) {
                pixelmonEntity.setAggression(Aggression.TIMID);
                continue;
            }
            pixelmonEntity.setAggression(Aggression.PASSIVE);
        }
        BattleRegistry.deRegisterBattle(this);
        if (this.participants.size() == 2) {
            BattleParticipant bp1 = this.participants.get(0);
            BattleParticipant bp2 = this.participants.get(1);
            if (bp1 instanceof PlayerParticipant && bp2 instanceof TrainerParticipant || bp2 instanceof PlayerParticipant && bp1 instanceof TrainerParticipant) {
                NPCEvent.EndBattle npcEndBattleEvent = new NPCEvent.EndBattle(this, cause, abnormal, results);
                Pixelmon.EVENT_BUS.post((Event)npcEndBattleEvent);
            }
        }
        BattleEndEvent event = new BattleEndEvent(this, cause, abnormal, results);
        Pixelmon.EVENT_BUS.post((Event)event);
        for (BattleParticipant p : this.participants) {
            p.endBattle(cause);
        }
        this.checkEvolution();
        for (FutureBattleTask futureTask : this.futureTasks) {
            if (futureTask.isPersistent()) continue;
            futureTask.future.cancel(true);
        }
        return results;
    }

    public void endBattle() {
        this.endBattle(BattleEndCause.NORMAL);
    }

    public void endBattleWithoutXP() {
        this.endBattle(BattleEndCause.FORCE);
    }

    public void timedAbilityStarted(PixelmonWrapper pw) {
        this.abilityGainOrder.remove(pw);
        this.abilityGainOrder.add(pw);
    }

    public ArrayList<PixelmonWrapper> getPokemonOrderedByAbilityGain() {
        return new ArrayList<PixelmonWrapper>(this.abilityGainOrder);
    }

    private void checkEvolution() {
        for (Pokemon pokemon : this.checkedPokemon) {
            pokemon.tryEvolution();
        }
    }

    private void resetAggression(BattleParticipant p) {
        LivingEntity entity;
        if (p.getType() == ParticipantType.WildPokemon && (entity = p.getEntity()) != null && entity.m_6084_()) {
            ((PixelmonEntity)entity).setAggressionTimer(RandomHelper.getRandomNumberBetween(400, 1000));
        }
    }

    public boolean isPvP() {
        for (BattleParticipant p : this.participants) {
            if (p instanceof PlayerParticipant) continue;
            return false;
        }
        return true;
    }

    public void pauseBattle() {
        this.paused = true;
    }

    public boolean isWaiting() {
        for (BattleParticipant p : this.participants) {
            if (!p.getWait()) continue;
            return true;
        }
        return false;
    }

    public void endPause() {
        this.paused = false;
    }

    private boolean switchThisTurn(PixelmonWrapper p) {
        if (this.tryFlee(p)) {
            return true;
        }
        for (BattleParticipant part : this.participants) {
            if (part.bc != null) continue;
            this.endBattle();
            return false;
        }
        if (p.getParticipant() == null || !p.getParticipant().onTakeTurn(this, p)) {
            return p.switchThisTurn();
        }
        return false;
    }

    private void takeTurn(PixelmonWrapper p) {
        if (this.tryFlee(p)) {
            return;
        }
        for (BattleParticipant part : this.participants) {
            if (part.bc != null) continue;
            this.endBattle();
            return;
        }
        if (p.getParticipant() == null || !p.getParticipant().onTakeTurn(this, p)) {
            p.takeTurn();
        }
    }

    public boolean tryFlee(PixelmonWrapper p) {
        return this.tryFlee(p, false);
    }

    public boolean tryFlee(PixelmonWrapper p, boolean turnEnd) {
        if (!turnEnd) {
            for (int i = 1; i < this.actionIndex; ++i) {
                PixelmonWrapper current = this.turnList.get(i - 1);
                if (!current.willTryFlee || current.getParticipant() != p.getParticipant()) continue;
                return false;
            }
        }
        if (p.willTryFlee) {
            this.forfeitOrFlee(p);
            p.priority = 6.0f;
            return true;
        }
        return false;
    }

    private void forfeitOrFlee(PixelmonWrapper p) {
        boolean isForfeit = false;
        for (BattleParticipant participant : this.getOpponents(p.getParticipant())) {
            if (participant.getType() == ParticipantType.WildPokemon) continue;
            isForfeit = true;
            break;
        }
        if (isForfeit) {
            this.forfeitBattle(p);
        } else {
            this.calculateEscape(p);
        }
    }

    private void calculateEscape(PixelmonWrapper pw) {
        PixelmonWrapper opponentPixelmon = pw.bc.getOpponentPokemon(pw.getParticipant()).get(0);
        double fleeingSpeed = pw.getStats().getSpeed();
        double opponentSpeed = opponentPixelmon.getStats().getSpeed();
        double escapeAttempts = ++pw.escapeAttempts;
        double calculatedFleeValue = fleeingSpeed * 128.0 / opponentSpeed + 30.0 * escapeAttempts;
        int random = RandomHelper.getRandomNumberBetween(1, 255);
        if (!pw.isFainted() && !BattleParticipant.canSwitch(pw)[1]) {
            calculatedFleeValue = 0.0;
            random = 1;
        }
        if (pw.getBattleAbility() instanceof RunAway) {
            this.sendToAll("pixelmon.abilities.runaway", pw.getNickname());
            this.endBattle(BattleEndCause.FLEE);
        } else if (pw.getHeldItem().getHeldItemType() == EnumHeldItems.smokeBall || pw.hasType(Element.GHOST)) {
            this.sendToAll("battlecontroller.escaped", pw.getNickname());
            this.endBattle(BattleEndCause.FLEE);
        } else if (calculatedFleeValue > 255.0 || (double)random < calculatedFleeValue) {
            this.sendToAll("battlecontroller.escaped", pw.getNickname());
            BattleParticipant fleeingParticipant = pw.getParticipant();
            if (fleeingParticipant != null) {
                for (PixelmonWrapper pw2 : fleeingParticipant.controlledPokemon) {
                    pw.bc.battleLog.logEvent(new FleeAction(pw.bc.battleTurn, pw));
                }
            }
            this.endBattle(BattleEndCause.FLEE);
        } else {
            pw.setMoved(true);
            this.sendToAll("battlecontroller.!escaped", pw.isFainted() ? pw.pokemon.getOwnerName() : pw.getNickname());
            BattleParticipant fleeingParticipant = pw.getParticipant();
            for (PixelmonWrapper pw2 : fleeingParticipant.controlledPokemon) {
                pw.bc.battleLog.logEvent(new FleeAction(pw.bc.battleTurn, pw2));
            }
        }
    }

    private void forfeitBattle(PixelmonWrapper pw) {
        if (this.rules.hasClause(BattleClauseRegistry.FORFEIT_CLAUSE)) {
            return;
        }
        BattleParticipant forfeitParticipant = pw.getParticipant();
        boolean tie = false;
        ArrayList<BattleParticipant> opponents = this.getOpponents(forfeitParticipant);
        block0: for (BattleParticipant opponent : opponents) {
            for (PixelmonWrapper opponentPokemon : opponent.controlledPokemon) {
                if (!opponentPokemon.willTryFlee) continue;
                tie = true;
                continue block0;
            }
        }
        if (tie) {
            this.sendToAll("battlecontroller.draw", new Object[0]);
        } else if (forfeitParticipant.getType() == ParticipantType.Player) {
            PlayerParticipant forfeitPlayer = (PlayerParticipant)forfeitParticipant;
            ChatHandler.sendBattleMessage((Entity)forfeitPlayer.player, "battlecontroller.forfeitself", new Object[0]);
            this.sendToOthers("battlecontroller.forfeit", forfeitPlayer, forfeitPlayer.getDisplayName());
        }
        HashMap<BattleParticipant, BattleResults> results = new HashMap<BattleParticipant, BattleResults>();
        for (BattleParticipant participant : this.participants) {
            BattleResults result = tie ? BattleResults.DRAW : (opponents.contains(participant) ? BattleResults.VICTORY : BattleResults.DEFEAT);
            results.put(participant, result);
        }
        this.endBattle(BattleEndCause.FORFEIT, results);
    }

    private void checkPokemon() {
        boolean cameraSwitched = false;
        for (BattleParticipant p : this.participants) {
            p.resetMoveTimer();
            if (this.battleEnded || p.isDefeated) continue;
            this.checkReviveSendOut(p);
            ArrayList<PixelmonWrapper> faintedPokemon = new ArrayList<PixelmonWrapper>();
            for (PixelmonWrapper poke : p.controlledPokemon) {
                if (!poke.isFainted()) continue;
                if (p.getType() == ParticipantType.Player) {
                    NetworkHelper.sendPacket(new SwitchCameraPacket(), (ServerPlayer)p.getEntity());
                    cameraSwitched = true;
                }
                if (poke.newPokemonUUID == null) {
                    this.turnList.remove(poke);
                }
                if (!poke.hasAwardedExp) {
                    Experience.awardExp(this.participants, p, poke);
                    poke.hasAwardedExp = true;
                    if (p instanceof WildPixelmonParticipant && this.participants.size() == 2) {
                        this.participants.stream().filter(part -> part != p && part instanceof PlayerParticipant).forEach(part -> {
                            StorageProxy.getPartyNow((ServerPlayer)((PlayerParticipant)part).player).stats.addKill();
                            Pixelmon.EVENT_BUS.post((Event)new BeatWildPixelmonEvent(((PlayerParticipant)part).player, (WildPixelmonParticipant)p));
                            ((PlayerParticipant)part).checkPlayerItems();
                        });
                    }
                }
                if (poke.entity != null) {
                    poke.entity.m_21153_(0.0f);
                    p.retrieveEntityDuringBattleUnlessRiding(poke);
                }
                p.updatePokemon(poke);
                if (p.hasMorePokemonReserve()) continue;
                faintedPokemon.add(poke);
                this.updateRemovedPokemon(poke);
            }
            for (PixelmonWrapper pw : faintedPokemon) {
                if (!this.battleEnded) {
                    this.checkDefeated(p, pw);
                }
                if (this.battleEnded) continue;
                p.controlledPokemon.remove(pw);
            }
        }
        if (cameraSwitched) {
            this.spectators.forEach(spectator -> spectator.sendMessage(new SwitchCameraPacket()));
        }
    }

    public void updateRemovedPokemon(PixelmonWrapper poke) {
        UUID uuid = poke.getPokemonUUID();
        this.participants.stream().filter(p2 -> p2 instanceof PlayerParticipant).forEach(p2 -> NetworkHelper.sendPacket(new SwitchOutTask(uuid), ((PlayerParticipant)p2).player));
        this.spectators.forEach(spectator -> spectator.sendMessage(new SwitchOutTask(uuid)));
    }

    public boolean isOneAlive(List<PixelmonWrapper> teamPokemon) {
        for (PixelmonWrapper pw : teamPokemon) {
            if (!pw.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void checkDefeated(BattleParticipant p, PixelmonWrapper poke) {
        if (this.isOneAlive(p.controlledPokemon)) {
            p.isDefeated = false;
        } else if (p.countAblePokemon() == 0 && !p.isDefeated) {
            p.isDefeated = true;
            ChatHandler.sendBattleMessage((Entity)p.getEntity(), "battlecontroller.outofpokemon", new Object[0]);
            if (!this.isTeamDefeated(p)) {
                return;
            }
            this.participants.stream().filter(p2 -> this.getOpponents(p).contains(p2)).forEach(p2 -> {
                ChatHandler.sendBattleMessage((Entity)p2.getEntity(), "battlecontroller.win", new Object[0]);
                if (p2 instanceof WildPixelmonParticipant && p.getEntity() instanceof ServerPlayer) {
                    Pixelmon.EVENT_BUS.post((Event)new LostToWildPixelmonEvent((ServerPlayer)p.getEntity(), (WildPixelmonParticipant)p2));
                }
            });
            if (p.getType().equals((Object)ParticipantType.Player)) {
                ((PlayerParticipant)p).resetPayDay();
            }
            this.endBattle();
        }
    }

    public void sendToAll(String string, Object ... data) {
        if (this.canSendMessages()) {
            ChatHandler.sendBattleMessage(this.participants, string, data);
            this.battleLog.logEvent(new BattleMessageAction(this.battleTurn, Component.m_237110_((String)string, (Object[])data).getString()));
        }
    }

    public void sendToAll(Component message) {
        if (this.canSendMessages()) {
            ChatHandler.sendBattleMessage(this.participants, message);
        }
    }

    public void sendToOthers(String string, BattleParticipant battleParticipant, Object ... data) {
        if (this.canSendMessages()) {
            this.participants.stream().filter(p -> p != battleParticipant).forEach(p -> ChatHandler.sendBattleMessage((Entity)p.getEntity(), string, data));
            this.spectators.forEach(spectator -> ChatHandler.sendBattleMessage((Entity)spectator.getEntity(), string, data));
        }
    }

    public void sendToPlayer(Player player, String string, Object ... data) {
        if (player != null && this.canSendMessages()) {
            ChatHandler.sendBattleMessage((Entity)player, string, data);
        }
    }

    public void sendToPlayer(Player player, Component message) {
        if (player != null && this.canSendMessages()) {
            ChatHandler.sendBattleMessage((Entity)player, message);
        }
    }

    private boolean canSendMessages() {
        return !this.simulateMode && this.sendMessages;
    }

    public void sendToPlayers(PixelmonPacket message) {
        this.participants.forEach(par -> par.sendMessage(message));
        this.spectators.forEach(spec -> spec.sendMessage(message));
    }

    public void clearHurtTimer() {
        for (BattleParticipant part : this.participants) {
            for (PixelmonWrapper pokemon : part.controlledPokemon) {
                if (pokemon == null || pokemon.entity == null) continue;
                pokemon.entity.f_20916_ = 0;
            }
        }
    }

    public void setUseItem(UUID pokemonUUID, Player user, ItemStack usedStack, int additionalInfo) {
        BattleParticipant participant = CollectionHelper.find(this.participants, bp -> bp.getType() == ParticipantType.Player && bp.getEntity() == user);
        PixelmonWrapper userWrapper = participant.getPokemonFromUUID(pokemonUUID);
        userWrapper.willUseItemInStack = usedStack;
        userWrapper.willUseItemInStackInfo = additionalInfo;
        userWrapper.wait = false;
        if (usedStack.m_41720_() instanceof PokeBallItem) {
            for (PixelmonWrapper pw : participant.controlledPokemon) {
                if (pw == userWrapper) continue;
                pw.wait = false;
                pw.attack = null;
            }
        }
    }

    public void setUseItem(UUID pokemonUUID, Player player, ItemStack usedStack, UUID targetPokemonUUID) {
        for (BattleParticipant p : this.participants) {
            PixelmonWrapper pw;
            if (p.getType() != ParticipantType.Player || p.getEntity() != player || (pw = p.getPokemonFromUUID(pokemonUUID)) == null) continue;
            pw.willUseItemInStack = usedStack;
            pw.willUseItemPokemon = targetPokemonUUID;
            pw.willUseItemInStackInfo = -1;
            pw.wait = false;
        }
    }

    public void switchPokemon(UUID switchingPokemonUUID, UUID newPokemonUUID, boolean switchInstantly) {
        PixelmonWrapper pw = this.getPokemonFromUUID(switchingPokemonUUID);
        if (pw == null) {
            return;
        }
        BattleParticipant p = pw.getParticipant();
        pw.isSwitching = true;
        pw.newPokemonUUID = newPokemonUUID;
        pw.setTemporaryMoveset(null);
        boolean stopWait = true;
        boolean checkFaint = false;
        if (pw.isFainted()) {
            p.switchingIn.add(newPokemonUUID);
            if (!this.switchingOut.isEmpty()) {
                this.switchingOut.remove(pw);
                if (this.switchingOut.isEmpty()) {
                    this.setupForSyncronizedSwitches();
                    for (BattleParticipant participant : this.participants) {
                        participant.switchAllFainted();
                        participant.wait = false;
                    }
                    this.handlePostSynchronizedSwitches();
                    checkFaint = true;
                } else {
                    stopWait = false;
                }
            }
        } else if (switchInstantly) {
            pw.doSwitch();
        }
        if (checkFaint) {
            this.checkPokemon();
            this.checkFaint();
        }
        if (stopWait) {
            pw.wait = false;
            p.wait = false;
        }
    }

    public void storeSwitchInActivation(PixelmonWrapper pw, PixelmonWrapper former) {
        this.switchedIn.put(pw, former);
    }

    public void setFlee(UUID fleeingUUID) {
        for (BattleParticipant p : this.participants) {
            PixelmonWrapper pw = p.getPokemonFromUUID(fleeingUUID);
            if (pw == null) continue;
            if (pw.isFainted() && p.getType() == ParticipantType.Player) {
                this.forfeitOrFlee(pw);
                if (this.battleEnded) continue;
                NetworkHelper.sendPacket(new FailedSwitchFleeTask(), ((PlayerParticipant)p).player);
                continue;
            }
            p.wait = false;
            for (PixelmonWrapper pw2 : p.controlledPokemon) {
                pw2.willTryFlee = true;
                pw2.wait = false;
            }
        }
    }

    public ParticipantType[][] getBattleType(BattleParticipant teammate) {
        int i;
        ParticipantType[][] type = new ParticipantType[2][];
        ArrayList<ParticipantType> team1 = new ArrayList<ParticipantType>();
        ArrayList<ParticipantType> team2 = new ArrayList<ParticipantType>();
        for (BattleParticipant p : this.participants) {
            if (p.team == teammate.team) {
                team1.add(p.getType());
                continue;
            }
            team2.add(p.getType());
        }
        type[0] = new ParticipantType[team1.size()];
        for (i = 0; i < team1.size(); ++i) {
            type[0][i] = (ParticipantType)((Object)team1.get(i));
        }
        type[1] = new ParticipantType[team2.size()];
        for (i = 0; i < team2.size(); ++i) {
            type[1][i] = (ParticipantType)((Object)team2.get(i));
        }
        return type;
    }

    public void updatePokemonHealth() {
        if (this.init) {
            for (BattleParticipant participant : this.participants) {
                if (!(participant instanceof PlayerParticipant)) continue;
                ((PlayerParticipant)participant).updatePokemonHealth();
            }
        }
    }

    public ArrayList<BattleParticipant> getOpponents(BattleParticipant participant) {
        return (ArrayList)this.participants.stream().filter(p -> p.team != participant.team).collect(Collectors.toList());
    }

    public ArrayList<BattleParticipant> getTeam(BattleParticipant participant) {
        if (participant == null) {
            return new ArrayList<BattleParticipant>();
        }
        return (ArrayList)this.participants.stream().filter(p -> p.team == participant.team).collect(Collectors.toList());
    }

    public ArrayList<PixelmonWrapper> getActivePokemon() {
        ArrayList<PixelmonWrapper> activePokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : this.participants) {
            activePokemon.addAll(p.controlledPokemon);
        }
        return activePokemon;
    }

    public ArrayList<PixelmonWrapper> getActiveUnfaintedPokemon() {
        return (ArrayList)this.getActivePokemon().stream().filter(pw -> !pw.isFainted()).collect(Collectors.toList());
    }

    public ArrayList<PixelmonWrapper> getActiveFaintedPokemon() {
        return (ArrayList)this.getActivePokemon().stream().filter(PixelmonWrapper::isFainted).collect(Collectors.toList());
    }

    public ArrayList<PixelmonWrapper> getAdjacentPokemon(PixelmonWrapper pokemon) {
        return (ArrayList)this.getActiveUnfaintedPokemon().stream().filter(pw -> this.arePokemonAdjacent((PixelmonWrapper)pw, pokemon)).collect(Collectors.toList());
    }

    public boolean arePokemonAdjacent(PixelmonWrapper pw, PixelmonWrapper other) {
        if (pw == other || !pw.onBattlefield || !other.onBattlefield || pw.isFainted() || other.isFainted()) {
            return false;
        }
        return Math.abs(pw.battlePosition - other.battlePosition) <= 1;
    }

    public ArrayList<PixelmonWrapper> getAdjacentPokemonAndSelf(PixelmonWrapper pokemon) {
        if (pokemon == null) {
            return new ArrayList<PixelmonWrapper>();
        }
        ArrayList<PixelmonWrapper> targets = this.getAdjacentPokemon(pokemon);
        targets.add(pokemon);
        return targets;
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon(BattleParticipant participant) {
        ArrayList<BattleParticipant> team = this.getTeam(participant);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw == null) continue;
                teamPokemon.add(pw);
            }
        }
        return teamPokemon;
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon(PixelmonWrapper pokemon) {
        return this.getTeamPokemon(pokemon.getParticipant());
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon(PixelmonEntity pokemon) {
        return this.getTeamPokemon(pokemon.getParticipant());
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonExcludeSelf(PixelmonWrapper pokemon) {
        ArrayList<PixelmonWrapper> teamPokemon = this.getTeamPokemon(pokemon);
        teamPokemon.remove(pokemon);
        return teamPokemon;
    }

    public ArrayList<PixelmonWrapper> getOpponentPokemon(BattleParticipant participant) {
        ArrayList<BattleParticipant> opponents = this.getOpponents(participant);
        ArrayList<PixelmonWrapper> opponentPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : opponents) {
            opponentPokemon.addAll(p.controlledPokemon);
        }
        return opponentPokemon;
    }

    public ArrayList<PixelmonWrapper> getOpponentPokemon(PixelmonWrapper pw) {
        return this.getOpponentPokemon(pw.getParticipant());
    }

    public boolean isInBattle(PixelmonWrapper pokemon) {
        for (PixelmonWrapper pw : this.getActivePokemon()) {
            if (pw != pokemon) continue;
            return true;
        }
        return false;
    }

    public BattleParticipant getParticipantForEntity(LivingEntity entity) {
        for (BattleParticipant p : this.participants) {
            if (p.getEntity() != entity) continue;
            return p;
        }
        return null;
    }

    public void sendDamagePacket(PixelmonWrapper target, int damage) {
        for (BattleParticipant p : this.participants) {
            p.sendDamagePacket(target, damage);
        }
        this.spectators.forEach(spectator -> spectator.sendDamagePacket(target, damage));
    }

    public void sendHealPacket(PixelmonWrapper target, int amount) {
        for (BattleParticipant p : this.participants) {
            p.sendHealPacket(target, amount);
        }
        this.spectators.forEach(spectator -> spectator.sendHealPacket(target, amount));
    }

    @Nullable
    public PixelmonWrapper getOppositePokemon(PixelmonWrapper pw) {
        if (pw == null || pw.bc == null || pw.getParticipant() == null) {
            return null;
        }
        ArrayList<PixelmonWrapper> oppPokemon = pw.bc.getOpponentPokemon(pw.getParticipant());
        ArrayList<PixelmonWrapper> teamPokemon = pw.bc.getTeamPokemon(pw.getParticipant());
        int index = teamPokemon.indexOf(pw);
        if (index >= oppPokemon.size()) {
            index = oppPokemon.size() - 1;
        }
        if (index == -1) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        return oppPokemon.get(index);
    }

    public PixelmonWrapper getPokemonAtPosition(int position) {
        ArrayList<PixelmonWrapper> arr = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant bp : this.participants) {
            arr.addAll(bp.controlledPokemon);
        }
        if (position >= arr.size()) {
            return null;
        }
        return (PixelmonWrapper)arr.get(position);
    }

    public int getPositionOfPokemon(PixelmonWrapper poke) {
        ArrayList<PixelmonWrapper> arr = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant bp : this.participants) {
            arr.addAll(bp.controlledPokemon);
        }
        return arr.indexOf(poke);
    }

    public int getPositionOfPokemon(PixelmonWrapper poke, BattleParticipant bp) {
        return bp.controlledPokemon.indexOf(poke);
    }

    public BattleStage getStage() {
        return this.stage;
    }

    public void enableReturnHeldItems(PixelmonWrapper attacker, PixelmonWrapper target) {
        BattleParticipant targetParticipant = target.getParticipant();
        if (!this.simulateMode && !(targetParticipant instanceof WildPixelmonParticipant)) {
            target.enableReturnHeldItem();
            attacker.enableReturnHeldItem();
        }
    }

    public boolean checkValid() {
        if (this.battleEnded) {
            return false;
        }
        ArrayList<PixelmonWrapper> pokemon = new ArrayList<PixelmonWrapper>();
        ArrayList<PixelmonWrapper> activePokemon = this.getActivePokemon();
        if (activePokemon.size() <= 1) {
            return false;
        }
        for (PixelmonWrapper pw : activePokemon) {
            if (pokemon.contains(pw)) {
                this.endBattle(BattleEndCause.FORCE);
                return false;
            }
            pokemon.add(pw);
        }
        return true;
    }

    public PlayerParticipant getPlayer(String name) {
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player) continue;
            PlayerParticipant player = (PlayerParticipant)p;
            if (!player.player.m_5446_().getString().equals(name)) continue;
            return player;
        }
        return null;
    }

    public PlayerParticipant getPlayer(Player player) {
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player) continue;
            PlayerParticipant currentPlayer = (PlayerParticipant)p;
            if (player != currentPlayer.player) continue;
            return currentPlayer;
        }
        return null;
    }

    public List<PlayerParticipant> getPlayers() {
        ArrayList players = Lists.newArrayList();
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player) continue;
            players.add((PlayerParticipant)p);
        }
        return players;
    }

    public List<ServerPlayer> getPlayerEntities() {
        ArrayList players = Lists.newArrayList();
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player) continue;
            players.add(((PlayerParticipant)p).player);
        }
        return players;
    }

    public boolean isTeamDefeated(BattleParticipant participant) {
        for (BattleParticipant p2 : this.getTeam(participant)) {
            if (p2.isDefeated) continue;
            return false;
        }
        return true;
    }

    public int getTurnForPokemon(PixelmonWrapper pokemon) {
        for (int i = 0; i < this.turnList.size(); ++i) {
            if (this.turnList.get(i) != pokemon) continue;
            return i;
        }
        return -1;
    }

    public BattleParticipant otherParticipant(BattleParticipant participant) {
        for (BattleParticipant p : this.participants) {
            if (p == participant) continue;
            return p;
        }
        return null;
    }

    public PixelmonWrapper getFirstMover(PixelmonWrapper ... pokemonList) {
        for (PixelmonWrapper turnPokemon : this.turnList) {
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public PixelmonWrapper getFirstMover(ArrayList<PixelmonWrapper> pokemonList) {
        for (PixelmonWrapper turnPokemon : this.turnList) {
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public PixelmonWrapper getLastMover(PixelmonWrapper ... pokemonList) {
        for (int i = this.turnList.size() - 1; i >= 0; --i) {
            PixelmonWrapper turnPokemon = this.turnList.get(i);
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public PixelmonWrapper getLastMover(ArrayList<PixelmonWrapper> pokemonList) {
        for (int i = this.turnList.size() - 1; i >= 0; --i) {
            PixelmonWrapper turnPokemon = this.turnList.get(i);
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public Optional<Ability> getAbilityIfPresent(Class<? extends AbstractAbility> abilityClass) {
        for (PixelmonWrapper pw : this.getActivePokemon()) {
            Ability ability;
            if (pw == null || (ability = pw.getBattleAbility(false)) == null || !ability.isAbility((Class<? extends Ability>)abilityClass)) continue;
            return Optional.of(pw.getBattleAbility(false));
        }
        return Optional.empty();
    }

    public void sendSwitchPacket(UUID oldUUID, PixelmonWrapper newPokemon) {
        for (BattleParticipant participant : this.participants) {
            if (!(participant instanceof PlayerParticipant)) continue;
            NetworkHelper.sendPacket(new SwitchOutTask(oldUUID, newPokemon), ((PlayerParticipant)participant).player);
            ServerPlayer player = (ServerPlayer)participant.getEntity();
            PlayerPartyStorage storage = StorageProxy.getPartyNow(player.m_20148_());
            PokedexEvent.Pre preEvent = new PokedexEvent.Pre(player.m_20148_(), newPokemon.pokemon, PokedexRegistrationStatus.SEEN, "battles");
            if (Pixelmon.EVENT_BUS.post((Event)preEvent)) continue;
            storage.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
            storage.playerPokedex.update();
            if (player != null) {
                storage.playerPokedex.update();
            }
            Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(player.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
        }
        this.spectators.forEach(spectator -> {
            spectator.sendMessage(new SwitchOutTask(oldUUID, newPokemon));
            ServerPlayer player = spectator.getEntity();
            PlayerPartyStorage storage = StorageProxy.getPartyNow(player.m_20148_());
            PokedexEvent.Pre preEvent = new PokedexEvent.Pre(player.m_20148_(), newPokemon.pokemon, PokedexRegistrationStatus.SEEN, "battles");
            if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
                storage.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                storage.playerPokedex.update();
                if (player != null) {
                    storage.playerPokedex.update();
                }
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(player.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
        });
    }

    public void addSpectator(Spectator spectator) {
        this.spectators.add(spectator);
        BattleRegistry.registerSpectator(spectator, this);
    }

    public void removeSpectator(Spectator spectator) {
        this.spectators.remove(spectator);
        BattleRegistry.unregisterSpectator(spectator);
        Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StopSpectate(spectator.getEntity(), this));
    }

    public boolean hasSpectator(Player player) {
        for (Spectator spectator : this.spectators) {
            if (spectator.getEntity() != player) continue;
            return true;
        }
        return false;
    }

    public boolean removeSpectator(ServerPlayer player) {
        return this.spectators.removeIf(spectator -> {
            if (!Objects.equals(spectator.getEntity(), player)) {
                return false;
            }
            BattleRegistry.unregisterSpectator(spectator);
            Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StopSpectate(player, this));
            return true;
        });
    }

    public ArrayList<Spectator> getPlayerSpectators(PlayerParticipant player) {
        ArrayList<Spectator> playerSpectators = new ArrayList<Spectator>(this.spectators.size());
        String playerName = player.player.m_5446_().getString();
        playerSpectators.addAll(this.spectators.stream().filter(spectator -> spectator.watchedName.equals(playerName)).collect(Collectors.toList()));
        return playerSpectators;
    }

    public PixelmonWrapper getPokemonFromUUID(UUID uuid) {
        for (BattleParticipant p : this.participants) {
            PixelmonWrapper pw = p.getPokemonFromUUID(uuid);
            if (pw == null) continue;
            return pw;
        }
        return null;
    }

    public List<PixelmonWrapper> getDefaultTurnOrder() {
        return BattlePriorityHelper.getDefaultTurnOrder(this);
    }

    public void removeFromTurnList(PixelmonWrapper pw) {
        if (!pw.hasMoved()) {
            this.turnList.remove(pw);
        }
    }

    public int getTurn(PixelmonWrapper pixelmonWrapper) {
        return this.turnList.indexOf(pixelmonWrapper);
    }

    public boolean isLastMover() {
        return this.actionIndex >= this.turnList.size() - 1;
    }

    public boolean duringSwitchAction() {
        return this.isSwitchTurn;
    }

    public boolean containsParticipantType(Class<? extends BattleParticipant> participantType) {
        for (BattleParticipant bp : this.participants) {
            if (bp.getClass() != participantType) continue;
            return true;
        }
        return false;
    }

    public void updateFormChange(PixelmonEntity pokemon) {
        this.sendToPlayers(new FormBattleUpdatePacket(pokemon.getPokemon().getUUID(), pokemon.getFormIncludeTransformed()));
    }

    public void updateFormChange(PixelmonWrapper pokemon) {
        this.sendToPlayers(new FormBattleUpdatePacket(pokemon.getPokemonUUID(), pokemon.getForm()));
    }

    public boolean isLevelingDisabled() {
        if (!PixelmonConfigProxy.getBattle().isAllowPVPExperience()) {
            boolean allPlayers = true;
            for (BattleParticipant p : this.participants) {
                if (p.getType() == ParticipantType.Player) continue;
                allPlayers = false;
            }
            if (allPlayers) {
                return true;
            }
        }
        if (!PixelmonConfigProxy.getBattle().isAllowTrainerExperience()) {
            for (BattleParticipant p : this.participants) {
                if (p.getType() != ParticipantType.Trainer) continue;
                return true;
            }
        }
        return this.rules.getOrDefault(BattleRuleRegistry.RAISE_TO_CAP);
    }

    public boolean isRaid() {
        for (BattleParticipant bp : this.participants) {
            if (!(bp instanceof RaidPixelmonParticipant)) continue;
            return true;
        }
        return this.rules != null && this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID;
    }

    public boolean isSimulation() {
        return this.simulateMode;
    }

    public Attack getLastAttack() {
        if (this.isSimulation()) {
            return this.lastSimulatedAttack;
        }
        return this.lastAttack;
    }

    public Attack getLastTempAttack() {
        if (this.isSimulation()) {
            return this.lastSimulatedTempAttack;
        }
        return this.lastTempAttack;
    }

    private boolean setOverworldWeatherAsBattleWeather() {
        for (BattleParticipant participant : this.participants) {
            if (participant instanceof WildPixelmonParticipant && !PixelmonConfigProxy.getBattle().isOverworldWeatherAffectsWildBattleWeather()) {
                return false;
            }
            if (participant instanceof TrainerParticipant && !PixelmonConfigProxy.getBattle().isOverworldWeatherAffectsTrainerBattleWeather()) {
                return false;
            }
            if (participant instanceof PlayerParticipant && !PixelmonConfigProxy.getBattle().isOverworldWeatherAffectsPvPBattleWeather() && participant.getOpponents().stream().anyMatch(p -> p.getType() == ParticipantType.Player)) {
                return false;
            }
            if (!(participant instanceof RaidPixelmonParticipant) || PixelmonConfigProxy.getBattle().isOverworldWeatherAffectsRaidBattleWeather()) continue;
            return false;
        }
        if (this.setOverworldPrecipitationAsBattleWeather()) {
            return true;
        }
        if (this.setOverworldSandstormAsBattleWeather()) {
            return true;
        }
        if (this.setOverworldFogAsBattleWeather()) {
            return true;
        }
        return this.setOverworldSunnyDayAsBattleWeather();
    }

    private boolean setOverworldPrecipitationAsBattleWeather() {
        int[] affectedBySnowOrRain = this.calculateEntitiesAffectedByPrecipitation();
        Weather currentWeather = this.globalStatusController.getWeather();
        if (affectedBySnowOrRain[0] > 0 && affectedBySnowOrRain[1] > 0 && !(currentWeather instanceof Hail)) {
            Hail hail = new Hail(-1, true);
            this.globalStatusController.addGlobalStatus(null, hail);
            this.globalStatusController.bc.sendToAll(hail.getLangContinue(), new Object[0]);
            return true;
        }
        if (affectedBySnowOrRain[0] > 0 && affectedBySnowOrRain[1] == 0) {
            return true;
        }
        if (affectedBySnowOrRain[0] == 0 && affectedBySnowOrRain[1] > 0 && !(currentWeather instanceof Rainy)) {
            Rainy rainy = new Rainy(-1, true);
            this.globalStatusController.addGlobalStatus(null, rainy);
            this.globalStatusController.bc.sendToAll(rainy.getLangContinue(), new Object[0]);
            return true;
        }
        return false;
    }

    private int[] calculateEntitiesAffectedByPrecipitation() {
        int affectedBySnow = 0;
        int affectedByRain = 0;
        for (BattleParticipant p : this.participants) {
            LivingEntity pokemonTrainer;
            boolean entitiesExist = true;
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.entity != null && pw.entity.f_19853_ != null) {
                    Biome biome;
                    if (!pw.entity.f_19853_.m_45527_(pw.entity.m_20183_()) || !pw.entity.f_19853_.m_46471_() || (biome = (Biome)pw.entity.f_19853_.m_204166_(pw.entity.m_20183_()).get()).m_264600_(pw.entity.m_20183_()) == Biome.Precipitation.NONE) continue;
                    float biomeTemperature = biome.m_47505_(pw.entity.m_20183_());
                    if ((double)biomeTemperature >= 0.15) {
                        ++affectedByRain;
                        continue;
                    }
                    ++affectedBySnow;
                    continue;
                }
                entitiesExist = false;
            }
            if (entitiesExist || (pokemonTrainer = p.getEntity()) == null || !pokemonTrainer.f_19853_.m_45527_(pokemonTrainer.m_20183_())) continue;
            Biome biome = (Biome)pokemonTrainer.f_19853_.m_204166_(pokemonTrainer.m_20183_()).get();
            if (biome.m_264600_(pokemonTrainer.m_20183_()) == Biome.Precipitation.SNOW) {
                ++affectedBySnow;
                continue;
            }
            if (biome.m_264600_(pokemonTrainer.m_20183_()) != Biome.Precipitation.RAIN) continue;
            ++affectedByRain;
        }
        int[] affectedBySnowOrRain = new int[]{affectedBySnow, affectedByRain};
        return affectedBySnowOrRain;
    }

    private boolean setOverworldSandstormAsBattleWeather() {
        return false;
    }

    private boolean setOverworldFogAsBattleWeather() {
        return false;
    }

    private boolean setOverworldSunnyDayAsBattleWeather() {
        boolean setToSunnyWeather = this.calculateEntitiesAffectedByHarshSunlight();
        Weather currentWeather = this.globalStatusController.getWeather();
        if (setToSunnyWeather && !(currentWeather instanceof Sunny)) {
            Sunny sunny = new Sunny(-1);
            this.globalStatusController.addGlobalStatus(null, sunny);
            this.globalStatusController.bc.sendToAll(sunny.getLangContinue(), new Object[0]);
            return true;
        }
        return false;
    }

    private boolean calculateEntitiesAffectedByHarshSunlight() {
        for (BattleParticipant p : this.participants) {
            if (p.getEntity() == null || p.getEntity().f_19853_ == null || !p.getEntity().f_19853_.m_45527_(p.getEntity().m_20183_()) || p.getEntity().f_19853_.m_46470_()) {
                return false;
            }
            long dayTime = p.getEntity().f_19853_.m_46468_();
            Holder biome = p.getEntity().f_19853_.m_204166_(p.getEntity().m_20183_());
            if (biome.m_203656_(PixelmonBiomeTags.ONE_HOUR_HARSH_SUNLIGHT) && dayTime >= 5500L && dayTime < 6500L) {
                return true;
            }
            if (biome.m_203656_(PixelmonBiomeTags.TWO_HOURS_HARSH_SUNLIGHT) && dayTime >= 5000L && dayTime < 7000L) {
                return true;
            }
            if (biome.m_203656_(PixelmonBiomeTags.FOUR_HOURS_HARSH_SUNLIGHT) && dayTime >= 4000L && dayTime < 8000L) {
                return true;
            }
            if (biome.m_203656_(PixelmonBiomeTags.SIX_HOURS_HARSH_SUNLIGHT) && dayTime >= 3000L && dayTime < 9000L) {
                return true;
            }
            if (!biome.m_203656_(PixelmonBiomeTags.EIGHT_HOURS_HARSH_SUNLIGHT) || dayTime < 2000L || dayTime >= 10000L) continue;
            return true;
        }
        return false;
    }

    public boolean setOverworldWeatherAsBattleWeatherDuringBattle() {
        Weather weather;
        if (PixelmonConfigProxy.getBattle().isOverworldWeatherCanChangeBattleWeatherDuringBattle() && ((weather = this.globalStatusController.getWeather()) == null || weather.getIsOverworldWeather())) {
            return this.setOverworldWeatherAsBattleWeather();
        }
        return false;
    }

    public <E extends BattleEvent, A> CompletableFuture<A> addFunctionAtEvent(Class<E> eventClass, BiFunction<E, BattleController, A> task) {
        CompletableFuture future = new CompletableFuture();
        this.futureTasks.add(new FutureBattleTask<E, A>(eventClass, task, future, false));
        return future;
    }

    public <E extends BattleEvent> CompletableFuture<Void> addTaskAtEvent(Class<E> eventClass, BiConsumer<E, BattleController> task) {
        return this.addFunctionAtEvent(eventClass, (e, controller) -> {
            task.accept((Object)e, (BattleController)controller);
            return null;
        });
    }

    public <E extends BattleEvent> void addPersistentTaskAtEvent(Class<E> eventClass, BiConsumer<E, BattleController> task) {
        this.futureTasks.add(new FutureBattleTask<BattleEvent, Object>(eventClass, (e, controller) -> {
            task.accept((Object)e, (BattleController)controller);
            return null;
        }, null, true));
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        this.frozen = true;
    }

    public void forceChance() {
        this.forceChance = true;
    }

    public boolean shouldForceChance() {
        return this.forceChance;
    }

    public boolean getRandomChance(int chance) {
        if (this.shouldForceChance()) {
            return true;
        }
        return RandomHelper.getRandomChance(chance);
    }

    public boolean getRandomChance(float chance) {
        if (this.shouldForceChance()) {
            return true;
        }
        return RandomHelper.getRandomChance(chance);
    }

    public void unfreeze() {
        this.frozen = false;
    }

    static {
        Pixelmon.EVENT_BUS.addListener(event -> {
            if (!(event instanceof BattleEvent)) {
                return;
            }
            BattleEvent battleEvent = (BattleEvent)((Object)event);
            if (battleEvent.getBattleController() == null) {
                return;
            }
            List<FutureBattleTask<?, ?>> tasks = battleEvent.getBattleController().futureTasks;
            for (FutureBattleTask<?, ?> futureTask : tasks) {
                if (!Objects.equals(futureTask.getEventClass(), event.getClass())) continue;
                futureTask.complete((Object)battleEvent);
                if (futureTask.isPersistent()) continue;
                battleEvent.getBattleController().futureTasks.remove(futureTask);
            }
        });
        currentAnimations = new ArrayList();
    }
}

