/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.SkyDropped;
import com.pixelmonmod.pixelmon.battles.status.SkyDropping;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class SkyDrop
extends MultiTurnSpecialAttackBase {
    @Override
    public void modifyTargets(List<PixelmonWrapper> targets, Attack attack, PixelmonWrapper user) {
        SkyDropping dropping = (SkyDropping)user.getStatus(StatusType.SkyDropping);
        if (dropping != null) {
            targets.clear();
            targets.add(dropping.getTarget());
        }
    }

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper pw, PixelmonWrapper target) {
        pw.attack.getMove().setMakesContact(false);
        return AttackResult.proceed;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.Substitute) || user.bc.globalStatusController.hasStatus(StatusType.Gravity) || target.isAlly(user) || target.getForm().getWeight() >= 200.0f || target.isFainted()) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (!this.doesPersist(user)) {
            this.setPersists(user, true);
            this.setTurnCount(user, 2);
        }
        this.decrementTurnCount(user);
        if (this.getTurnCount(user) == 1) {
            user.bc.sendToAll("pixelmon.effect.skydrop", user.getNickname(), target.getNickname());
            user.addStatus(new SkyDropping(target), user);
            target.addStatus(new SkyDropped(user), user);
            target.removeStatus(StatusType.FollowMe);
            return AttackResult.charging;
        }
        user.attack.getMove().setMakesContact(true);
        boolean succeeded = user.removeStatus(StatusType.SkyDropping);
        target.removeStatus(StatusType.SkyDropped);
        this.setPersists(user, false);
        user.bc.sendToAll("pixelmon.effect.skydropfreed", target.getNickname());
        return succeeded || user.bc.simulateMode ? AttackResult.proceed : AttackResult.failed;
    }

    @Override
    public void removeEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.hasStatus(StatusType.SkyDropping)) {
            user.removeStatus(StatusType.SkyDropping);
            target.removeStatus(StatusType.SkyDropped);
        }
        this.setPersists(user, false);
    }

    @Override
    public int modifyDamage(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (target.hasType(Element.FLYING)) {
            return 0;
        }
        return damage;
    }

    @Override
    public void applyEffectAfterStatus(PixelmonWrapper user) {
        SkyDropping dropping = (SkyDropping)user.getStatus(StatusType.SkyDropping);
        if (dropping != null && dropping.getTarget().isFainted()) {
            user.removeStatus(StatusType.SkyDropping);
            user.removeStatus(StatusType.MultiTurn);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.powerHerb) {
            return;
        }
        userChoice.weight *= 0.9f;
        if (pw.hasStatus(StatusType.Confusion, StatusType.Infatuated, StatusType.Paralysis)) {
            userChoice.weight /= 2.0f;
        }
    }

    @Override
    public boolean shouldNotLosePP(PixelmonWrapper user) {
        return this.doesPersist(user);
    }
}

