/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.List;

public class VenomDrench
extends SpecialAttackBase {
    private static final transient BattleStatsType[] lowerStats = new BattleStatsType[]{BattleStatsType.ATTACK, BattleStatsType.SPECIAL_ATTACK, BattleStatsType.SPEED};

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0) {
            boolean hit = false;
            for (PixelmonWrapper pw : user.targets) {
                if (!pw.hasStatus(StatusType.Poison, StatusType.PoisonBadly)) continue;
                hit = true;
                pw.getBattleStats().modifyStat(-1, lowerStats, user);
            }
            if (hit) {
                return AttackResult.succeeded;
            }
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        return AttackResult.succeeded;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        StatsEffect[] statsEffects = new StatsEffect[lowerStats.length];
        for (int i = 0; i < lowerStats.length; ++i) {
            statsEffects[i] = new StatsEffect(lowerStats[i], -1, false);
        }
        block1: for (List<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
            for (MoveChoice choice : choices) {
                if (!choice.isAttack() || !choice.attack.getMove().getMakesContact()) continue;
                List<PixelmonWrapper> saveTargets = userChoice.targets;
                ArrayList<PixelmonWrapper> newTargets = new ArrayList<PixelmonWrapper>();
                newTargets.add(choice.user);
                userChoice.targets = newTargets;
                for (StatsEffect statsEffect : statsEffects) {
                    statsEffect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
                }
                userChoice.targets = saveTargets;
                continue block1;
            }
        }
    }
}

