/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Illusion;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Transformed;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import net.minecraft.world.entity.Entity;

public class Transform
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        Ability targetAbility = target.getBattleAbility();
        if (!target.getBattleAbility().canBeCopied()) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (targetAbility instanceof Illusion && ((Illusion)targetAbility).disguisedPokemon != null || target.hasStatus(StatusType.Substitute, StatusType.Transformed)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (!user.bc.simulateMode) {
            if (user.removeStatus(StatusType.Transformed) && user.entity != null) {
                PixelmonEntity.SYNC_TRANSFORMATION.set((Entity)user.entity, (Object)0);
            }
            user.bc.sendToAll("pixelmon.status.transform", user.getNickname(), target.getNickname());
            if (user.entity != null) {
                PixelmonEntity.SYNC_TRANSFORMATION.set((Entity)user.entity, (Object)-1);
            }
            user.addStatus(new Transformed(user, target), target);
            Moveset tempMoveset = new Moveset().withPokemon(user.pokemon);
            for (Attack a : target.getMoveset()) {
                if (a == null) continue;
                Attack copy = a.copy();
                copy.pp = 5;
                copy.overridePPMax(5);
                tempMoveset.add(copy);
            }
            user.setTemporaryMoveset(tempMoveset);
            Transformed transformedStatus = (Transformed)user.getStatus(StatusType.Transformed);
            if (transformedStatus != null) {
                transformedStatus.changeTransformedSprite(user, target);
            }
        }
        return AttackResult.succeeded;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        userChoice.raiseWeight(40.0f);
    }
}

