/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.NetherrackBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.PowderSnowCauldronBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;

public class TerrainExamine {
    public static TerrainType getTerrain(PixelmonWrapper user) {
        List blockTagKey;
        BlockState blockState;
        Block block;
        if (user == null || user.bc == null) {
            return TerrainType.Default;
        }
        Terrain terrain = user.bc.globalStatusController.getTerrain();
        switch (terrain.type) {
            case ElectricTerrain: {
                return TerrainType.Electric;
            }
            case GrassyTerrain: {
                return TerrainType.Grass;
            }
            case MistyTerrain: {
                return TerrainType.Misty;
            }
            case PsychicTerrain: {
                return TerrainType.Psychic;
            }
        }
        BlockPos userPosition = user.getWorldPosition();
        if (userPosition == null) {
            return TerrainType.Default;
        }
        Level world = user.getWorld();
        int numBelow = 0;
        do {
            blockState = world.m_8055_(userPosition.m_6625_(numBelow));
            block = blockState.m_60734_();
            blockTagKey = blockState.m_204343_().collect(Collectors.toList());
        } while (block instanceof AirBlock && ++numBelow < 5);
        String blockName = block.m_7705_();
        if (blockName.contains("ultra") || blockName.contains("end") || blockName.contains("purpur") || blockName.contains("deep_sea") || block instanceof DragonEggBlock) {
            return TerrainType.UltraSpace;
        }
        if (block instanceof IPlantable && !(block instanceof WaterlilyBlock) || block instanceof BonemealableBlock && !(block instanceof NetherrackBlock) && !(block instanceof SeagrassBlock) && !(block instanceof SeaPickleBlock) && !(block instanceof DirtPathBlock) && block != Blocks.f_152481_ && block != Blocks.f_50546_ || block instanceof SporeBlossomBlock || blockName.contains("grass")) {
            return TerrainType.Grass;
        }
        if (block == Blocks.f_49990_ || block == Blocks.f_152476_ || blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || block instanceof SpongeBlock || block instanceof WetSpongeBlock || block instanceof CoralBlock || block instanceof BaseCoralPlantTypeBlock || block instanceof SeagrassBlock || block instanceof SeaPickleBlock || block instanceof WaterlilyBlock) {
            return TerrainType.Water;
        }
        if (block instanceof IceBlock || block instanceof SnowLayerBlock || block == Blocks.f_50127_ || block instanceof PowderSnowBlock || block instanceof PowderSnowCauldronBlock || blockName.contains("ice")) {
            return TerrainType.SnowIce;
        }
        if (block instanceof SandBlock || block == Blocks.f_50493_ || block == Blocks.f_50129_ || block instanceof MudBlock || blockName.contains("sand") || blockName.contains("dirt") || blockName.contains("clay") || blockName.contains("gravel")) {
            return TerrainType.Sand;
        }
        if (blockName.contains("nether") || block instanceof BaseFireBlock || block instanceof MagmaBlock || block instanceof LavaCauldronBlock || blockTagKey.contains(BlockTags.f_13062_) || blockTagKey.contains(BlockTags.f_13087_)) {
            return TerrainType.Volcano;
        }
        if (block == Blocks.f_50330_) {
            return TerrainType.Electric;
        }
        if (blockTagKey.contains(BlockTags.f_13061_) || block == Blocks.f_50752_ || blockName.contains("ore") || blockName.contains("cave")) {
            return TerrainType.Cave;
        }
        return TerrainType.Default;
    }

    public static enum TerrainType {
        Default,
        Cave,
        Sand,
        Water,
        SnowIce,
        Volcano,
        UltraSpace,
        Grass,
        Misty,
        Electric,
        Psychic;

    }
}

