/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.status.InPursuit;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import java.util.ArrayList;
import java.util.List;

public class SwitchOut
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper) {
        if (userWrapper.bc.simulateMode) {
            return userWrapper.attack.moveResult.result;
        }
        if (userWrapper == targetWrapper) {
            this.applyEffect(userWrapper, targetWrapper);
            if (!userWrapper.nextSwitchIsMove) {
                if (userWrapper.attack.moveResult.result == AttackResult.failed) {
                    userWrapper.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                }
            } else {
                userWrapper.attack.moveResult.result = AttackResult.proceed;
            }
        }
        return userWrapper.attack.moveResult.result;
    }

    @Override
    public void applyEffect(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper) {
        if (userWrapper.bc.simulateMode || userWrapper.inParentalBond && targetWrapper.isAlive()) {
            return;
        }
        if (this.shouldSwitch(userWrapper, targetWrapper)) {
            SwitchOut.handleSwitch(userWrapper);
        } else {
            userWrapper.nextSwitchIsMove = false;
        }
    }

    private boolean shouldSwitch(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper) {
        if (userWrapper.stopsForcedSwitches(userWrapper)) {
            return false;
        }
        ArrayList<PixelmonWrapper> activePokemon = userWrapper.bc.getActivePokemon();
        if (!activePokemon.contains(userWrapper) || !activePokemon.contains(targetWrapper)) {
            return false;
        }
        BattleParticipant userParticipant = userWrapper.getParticipant();
        if (!userParticipant.hasMorePokemonReserve()) {
            return false;
        }
        if (targetWrapper.isFainted()) {
            for (BattleParticipant part : targetWrapper.bc.getTeam(targetWrapper.getParticipant())) {
                if (!part.hasMorePokemon()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void handleSwitch(PixelmonWrapper userWrapper) {
        userWrapper.nextSwitchIsMove = true;
        BattleParticipant userParticipant = userWrapper.getParticipant();
        if (SwitchOut.handlePursuers(userWrapper)) {
            if (userParticipant instanceof PlayerParticipant) {
                userWrapper.wait = true;
                NetworkHelper.sendPacket(new EnforcedSwitchTask(userWrapper.bc.getPositionOfPokemon(userWrapper, userWrapper.getParticipant()), userWrapper.nextSwitchIsMove), userWrapper.getPlayerOwner());
            } else {
                userWrapper.bc.switchPokemon(userWrapper.getPokemonUUID(), userWrapper.getBattleAI().getNextSwitch(userWrapper), true);
            }
        }
    }

    private static boolean handlePursuers(PixelmonWrapper userWrapper) {
        for (PixelmonWrapper pw : userWrapper.bc.turnList) {
            if (!userWrapper.isAlive()) {
                return false;
            }
            if (pw.hasMoved() || pw.isAlly(userWrapper) || pw.attack == null || !pw.attack.isAttack(AttackRegistry.PURSUIT) || !pw.attack.canReachTarget(pw, userWrapper)) continue;
            pw.targets.clear();
            pw.targets.add(userWrapper);
            pw.addStatus(new InPursuit(), pw);
            pw.takeTurn();
        }
        return userWrapper.isAlive();
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, userChoice.createList())) {
            userChoice.raiseWeight(30.0f);
        }
    }
}

