/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MegaLauncher;
import com.pixelmonmod.pixelmon.battles.attacks.Value;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Recover
extends SpecialAttackBase {
    private int increment = 0;

    public Recover(Value ... values) {
        this.increment = values[0].value;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.HealBlock)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (target.hasFullHealth()) {
            user.bc.sendToAll("pixelmon.effect.healfailed", target.getNickname());
            return AttackResult.failed;
        }
        float healAmount = this.getHealAmount(user, target);
        if (target.healEntityBy((int)healAmount) > 0) {
            if (user == target) {
                user.bc.sendToAll("pixelmon.effect.washealed", target.getNickname());
            } else {
                user.bc.sendToAll("pixelmon.effect.healother", user.getNickname(), target.getNickname());
            }
        }
        return AttackResult.succeeded;
    }

    private float getHealAmount(PixelmonWrapper user, PixelmonWrapper target) {
        float healPercent = this.increment;
        if (user.attack.getMove().getFlags().pulse && user.getBattleAbility() instanceof MegaLauncher) {
            healPercent = (float)((double)healPercent * 1.5);
        }
        return target.getPercentMaxHealth(healPercent);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            float healAmount = this.getHealAmount(pw, target);
            if (!pw.getTeamPokemon().contains(target)) continue;
            userChoice.raiseWeight(target.getHealthPercent(healAmount));
        }
    }
}

