/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SkillLink;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;

public class PopulationBomb
extends SpecialAttackBase {
    private transient int count = 0;
    private transient int maxHits = 10;

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        boolean hasSubstitute = false;
        if (this.count != 0) {
            return AttackResult.proceed;
        }
        boolean missed = false;
        user.inMultipleHit = true;
        while (this.count < this.maxHits && user.isAlive() && target.isAlive() && !missed) {
            boolean hasLoadedDice;
            MoveResults[] results;
            ++this.count;
            hasSubstitute = target.hasStatus(StatusType.Substitute);
            for (MoveResults result : results = user.useAttackOnly()) {
                if (result.result == AttackResult.failed || result.result == AttackResult.missed) {
                    --this.count;
                    missed = true;
                }
                user.attack.moveResult.damage += result.damage;
                user.attack.moveResult.fullDamage += result.fullDamage;
                user.attack.moveResult.accuracy = result.accuracy;
            }
            boolean bl = hasLoadedDice = user.hasHeldItem() && user.getUsableHeldItem().getHeldItemType() == EnumHeldItems.loadedDice;
            if (user.getBattleAbility() instanceof SkillLink || hasLoadedDice) {
                user.attack.setMoveAccuracy(-1);
            }
            if (!hasLoadedDice) continue;
            this.maxHits = RandomHelper.getRandomNumberBetween(4, 10);
        }
        user.inMultipleHit = false;
        user.attack.playAnimation(user, target);
        if (this.count > 0) {
            user.attack.sendEffectiveChat(user, target);
            user.bc.sendToAll("multiplehit.times", user.getNickname(), this.count);
        }
        this.count = 0;
        Attack.postProcessAttackAllHits(user, target, user.attack, user.attack.moveResult.damage, DamageTypeEnum.ATTACK, hasSubstitute);
        if (!hasSubstitute) {
            Attack.applyContactLate(user, target);
        }
        return AttackResult.hit;
    }

    public int getCount() {
        return this.count;
    }
}

