/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Contrary;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.FlowerVeil;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PreventStatDrop;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SwitchOut;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;

public class PartingShot
extends SpecialAttackBase {
    boolean shouldSwitch = true;

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        this.shouldSwitch = this.shouldSwitch(user, target);
        return AttackResult.proceed;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.simulateMode) {
            return;
        }
        if (this.shouldSwitch) {
            SwitchOut.handleSwitch(user);
        }
    }

    public boolean shouldSwitch(PixelmonWrapper user, PixelmonWrapper target) {
        boolean flowerVeil = false;
        ArrayList<PixelmonWrapper> enemyTeam = target.getTeamPokemon();
        for (PixelmonWrapper pokemon : enemyTeam) {
            if (!(pokemon.getBattleAbility(user) instanceof FlowerVeil)) continue;
            flowerVeil = true;
        }
        if (!user.getParticipant().hasMorePokemonReserve() || user.stopsForcedSwitches(user)) {
            return false;
        }
        if (target.getBattleAbility(user) instanceof PreventStatDrop || target.hasType(Element.GRASS) && flowerVeil) {
            return false;
        }
        if (target.getBattleAbility(user) instanceof Contrary) {
            return target.getBattleStats().statCanBeRaised(BattleStatsType.ATTACK) || target.getBattleStats().statCanBeRaised(BattleStatsType.SPECIAL_ATTACK);
        }
        return target.getBattleStats().statCanBeLowered(BattleStatsType.ATTACK) || target.getBattleStats().statCanBeLowered(BattleStatsType.SPECIAL_ATTACK);
    }
}

