/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.HiddenPowerCalculateEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.Arrays;
import net.minecraftforge.eventbus.api.Event;

public class HiddenPower
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        user.attack.overrideType(HiddenPower.getHiddenPowerType(user.pokemon, user.getStats().getIVs(), "Battle"));
        return AttackResult.proceed;
    }

    public static Element getHiddenPowerType(Pokemon pokemon, IVStore ivs, String reason) {
        Element element = HiddenPower.getHiddenPowerType(ivs);
        HiddenPowerCalculateEvent event = new HiddenPowerCalculateEvent(reason, pokemon, element);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.getCalculatedValue();
    }

    public static Element getHiddenPowerType(IVStore ivs) {
        return HiddenPower.getHiddenPowerType(ivs.getArray());
    }

    public static Element getHiddenPowerType(int ... ivs) {
        return HiddenPower.getHiddenPowerType((double)HiddenPower.calculateFedbca(ivs));
    }

    public static int calculateFedbca(int[] ivs) {
        int a = ivs[0] % 2;
        int b = ivs[1] % 2;
        int c = ivs[2] % 2;
        int d = ivs[5] % 2;
        int e = ivs[3] % 2;
        int f = ivs[4] % 2;
        return 32 * f + 16 * e + 8 * d + 4 * c + 2 * b + a;
    }

    private static Element getHiddenPowerType(double fedbca) {
        int type = (int)Math.floor(fedbca * 15.0 / 63.0);
        Element element = null;
        element = type == 0 ? Element.FIGHTING : (type == 1 ? Element.FLYING : (type == 2 ? Element.POISON : (type == 3 ? Element.GROUND : (type == 4 ? Element.ROCK : (type == 5 ? Element.BUG : (type == 6 ? Element.GHOST : (type == 7 ? Element.STEEL : (type == 8 ? Element.FIRE : (type == 9 ? Element.WATER : (type == 10 ? Element.GRASS : (type == 11 ? Element.ELECTRIC : (type == 12 ? Element.PSYCHIC : (type == 13 ? Element.ICE : (type == 14 ? Element.DRAGON : Element.DARK))))))))))))));
        return element;
    }

    public static IVStore getOptimalIVs(Element type) {
        int[] arr = new int[]{31, 31, 31, 31, 31, 31};
        switch (type) {
            case BUG: {
                arr[1] = 30;
                arr[2] = 30;
                arr[4] = 30;
                break;
            }
            case DARK: {
                break;
            }
            case DRAGON: {
                arr[1] = 30;
                break;
            }
            case ELECTRIC: {
                arr[3] = 30;
                break;
            }
            case FIGHTING: {
                arr[2] = 30;
                arr[3] = 30;
                arr[4] = 30;
                arr[5] = 30;
                break;
            }
            case FIRE: {
                arr[1] = 30;
                arr[3] = 30;
                arr[5] = 30;
                break;
            }
            case FLYING: {
                arr[0] = 30;
                arr[1] = 30;
                arr[2] = 30;
                arr[3] = 30;
                arr[4] = 30;
                break;
            }
            case GHOST: {
                arr[1] = 30;
                arr[4] = 30;
                break;
            }
            case GRASS: {
                arr[1] = 30;
                arr[3] = 30;
                break;
            }
            case GROUND: {
                arr[3] = 30;
                arr[4] = 30;
                break;
            }
            case ICE: {
                arr[1] = 30;
                arr[2] = 30;
                break;
            }
            case POISON: {
                arr[2] = 30;
                arr[3] = 30;
                arr[4] = 30;
                break;
            }
            case PSYCHIC: {
                arr[1] = 30;
                arr[5] = 30;
                break;
            }
            case ROCK: {
                arr[2] = 30;
                arr[4] = 30;
                arr[5] = 30;
                break;
            }
            case STEEL: {
                arr[4] = 30;
                break;
            }
            case WATER: {
                arr[1] = 30;
                arr[2] = 30;
                arr[3] = 30;
                break;
            }
        }
        return new IVStore(arr);
    }

    public static void main(String[] args) {
        System.out.println(HiddenPower.calculateOptimalIVs(Element.GHOST, new int[]{31, 31, 31, 31, 31, 31}, new boolean[]{true, true, true, true, true, true}));
        System.out.println(Arrays.toString(HiddenPower.calculateOptimalIVs(Element.GHOST, new int[]{31, 31, 31, 31, 31, 31}, new boolean[]{false, false, false, false, false, false})));
        System.out.println(Arrays.toString(HiddenPower.calculateOptimalIVs(Element.GHOST, new int[]{31, 0, 31, 31, 31, 31}, new boolean[]{false, true, false, false, false, false})));
        System.out.println(Arrays.toString(HiddenPower.calculateOptimalIVs(Element.PSYCHIC, new int[]{31, 0, 31, 31, 31, 31}, new boolean[]{false, true, false, false, false, false})));
    }

    public static int[] calculateOptimalIVs(Element type, int[] initialIVs, boolean[] requiredIVs) {
        for (int hp = 1; hp >= 0; --hp) {
            if (requiredIVs[0] && initialIVs[0] % 2 != hp) continue;
            for (int atk = 1; atk >= 0; --atk) {
                if (requiredIVs[1] && initialIVs[1] % 2 != atk) continue;
                for (int def = 1; def >= 0; --def) {
                    if (requiredIVs[2] && initialIVs[2] % 2 != def) continue;
                    for (int spatk = 1; spatk >= 0; --spatk) {
                        if (requiredIVs[3] && initialIVs[3] % 2 != spatk) continue;
                        for (int spdef = 1; spdef >= 0; --spdef) {
                            if (requiredIVs[4] && initialIVs[4] % 2 != spdef) continue;
                            for (int speed = 1; speed >= 0; --speed) {
                                if (requiredIVs[5] && initialIVs[5] % 2 != speed) continue;
                                int[][] entries = new int[][]{{hp, atk, def, spatk, spdef, speed}, {0, 1, 2, 4, 5, 3}};
                                int[] newIVs = new int[6];
                                double total = 0.0;
                                for (int idx = 0; idx < 6; ++idx) {
                                    total += (double)(entries[0][idx] << entries[1][idx]);
                                    newIVs[idx] = requiredIVs[idx] ? initialIVs[idx] : (entries[0][idx] == 0 ? 30 : 31);
                                }
                                Element newType = HiddenPower.getHiddenPowerType(total);
                                if (type != newType) continue;
                                return newIVs;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }
}

