/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.List;

public class HealBell
extends SpecialAttackBase {
    @Override
    public void modifyTargets(List<PixelmonWrapper> targets, Attack attack, PixelmonWrapper pw) {
        targets.clear();
        targets.add(pw);
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack.isAttack(AttackRegistry.HEAL_BELL)) {
            user.bc.sendToAll("pixelmon.effect.healbellstart", new Object[0]);
        } else if (user.attack.isAttack(AttackRegistry.AROMATHERAPY)) {
            user.bc.sendToAll("pixelmon.effect.aromatherapy", new Object[0]);
        }
        boolean healedSomething = false;
        for (BattleParticipant p : user.bc.getTeam(user.getParticipant())) {
            for (PixelmonWrapper pw : p.allPokemon) {
                if (user != pw && (pw.hasAnyStatusPreventingAttack(user) || pw.onBattlefield && !pw.getBattleAbility(user).allowsIncomingAttack(pw, user, user.attack)) || pw.removePrimaryStatus() == null) continue;
                healedSomething = true;
            }
        }
        if (!healedSomething) {
            return AttackResult.failed;
        }
        return AttackResult.succeeded;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        int numStatus = 0;
        for (PixelmonWrapper other : pw.getParticipant().allPokemon) {
            if (!other.hasNonVolatileStatus(false)) continue;
            ++numStatus;
        }
        userChoice.raiseWeight(numStatus * 30);
    }
}

