/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public class FoulPlay
extends SpecialAttackBase {
    private transient boolean inProgress = false;

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        MoveResults[] results;
        if (this.inProgress) {
            this.inProgress = false;
            return AttackResult.proceed;
        }
        this.inProgress = true;
        double oldAttackModifier = user.getBattleStats().getAttackModifier();
        int oldAttack = user.getBattleStats().attackStat;
        if (user.attack.isAttack(AttackRegistry.FOUL_PLAY)) {
            user.getBattleStats().changeStat(BattleStatsType.ATTACK, (int)target.getBattleStats().getAttackModifier());
            int[] targetStats = target.getBattleStats().getBaseBattleStats();
            user.getBattleStats().attackStat = targetStats[BattleStatsType.ATTACK.getStatIndex()];
        } else if (user.attack.isAttack(AttackRegistry.BODY_PRESS)) {
            user.getBattleStats().changeStat(BattleStatsType.ATTACK, user.getBattleStats().getDefenseModifier());
            int[] userBaseStats = user.getBattleStats().getBaseBattleStats();
            user.getBattleStats().attackStat = userBaseStats[BattleStatsType.DEFENSE.getStatIndex()];
        }
        int[] userStats = user.getBattleStats().getBattleStats();
        user.bc.modifyStats(user, userStats);
        for (MoveResults result : results = user.useAttackOnly()) {
            user.attack.moveResult.damage += result.damage;
            user.attack.moveResult.fullDamage += result.fullDamage;
            user.attack.moveResult.accuracy = result.accuracy;
        }
        this.inProgress = false;
        user.getBattleStats().changeStat(BattleStatsType.ATTACK, (int)oldAttackModifier);
        user.getBattleStats().attackStat = oldAttack;
        return AttackResult.hit;
    }
}

