/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Flinch;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumTypeEnhancingItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import com.pixelmonmod.pixelmon.items.heldItems.EVAdjusting;
import com.pixelmonmod.pixelmon.items.heldItems.MentalHerbItem;
import com.pixelmonmod.pixelmon.items.heldItems.TypeEnhancingItems;
import com.pixelmonmod.pixelmon.items.heldItems.WhiteHerbItem;
import java.util.List;

public class Fling
extends SpecialAttackBase {
    private transient HeldItem heldItem;

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        user.attack.setOverridePower(0);
        HeldItem item = user.getUsableHeldItem();
        if (user.hasHeldItem() && user.isItemRemovable(user)) {
            block0 : switch (item.getHeldItemType()) {
                case ironBall: {
                    user.attack.setOverridePower(130);
                    break;
                }
                case typeEnhancer: {
                    switch (((TypeEnhancingItems)item).enhanceType) {
                        case hardStone: {
                            user.attack.setOverridePower(100);
                            break block0;
                        }
                        case plate: {
                            user.attack.setOverridePower(90);
                            break block0;
                        }
                        case poisonBarb: 
                        case dragonFang: {
                            user.attack.setOverridePower(70);
                            break block0;
                        }
                        case sharpBeak: {
                            user.attack.setOverridePower(50);
                            break block0;
                        }
                        case blackBelt: 
                        case blackGlasses: 
                        case charcoal: 
                        case magnet: 
                        case miracleSeed: 
                        case mysticWater: 
                        case neverMeltIce: 
                        case spellTag: 
                        case twistedSpoon: 
                        case fairyWand: {
                            user.attack.setOverridePower(30);
                            break block0;
                        }
                    }
                    user.attack.setOverridePower(10);
                    break;
                }
                case deepSeaTooth: 
                case gripClaw: 
                case thickClub: {
                    user.attack.setOverridePower(90);
                    break;
                }
                case assaultVest: 
                case electirizer: 
                case magmarizer: 
                case protector: 
                case quickClaw: 
                case razorClaw: 
                case stickyBarb: {
                    user.attack.setOverridePower(80);
                    break;
                }
                case evAdjusting: {
                    user.attack.setOverridePower(((EVAdjusting)item).type == PixelmonItems.macho_brace.type ? 60 : 70);
                    break;
                }
                case dampRock: 
                case heatRock: 
                case rockyHelmet: 
                case leek: {
                    user.attack.setOverridePower(60);
                    break;
                }
                case dubiousDisc: {
                    user.attack.setOverridePower(50);
                    break;
                }
                case eviolite: 
                case icyRock: 
                case luckyPunch: {
                    user.attack.setOverridePower(40);
                    break;
                }
                case absorbbulb: 
                case berryJuice: 
                case bindingBand: 
                case blackSludge: 
                case cellbattery: 
                case deepSeaScale: 
                case dragonScale: 
                case ejectButton: 
                case throatSpray: 
                case everStone: 
                case expShare: 
                case flameOrb: 
                case floatStone: 
                case kingsRock: 
                case lifeorb: 
                case lightBall: 
                case lightClay: 
                case luckyEgg: 
                case metalCoat: 
                case metalPowder: 
                case metronome: 
                case mirrorHerb: 
                case prismScale: 
                case quickPowder: 
                case razorFang: 
                case scopeLens: 
                case shellBell: 
                case smokeBall: 
                case soulDew: 
                case toxicOrb: 
                case upGrade: {
                    user.attack.setOverridePower(30);
                    break;
                }
                case gems: 
                case mail: 
                case other: {
                    user.attack.setOverridePower(0);
                    break;
                }
                default: {
                    user.attack.setOverridePower(10);
                }
            }
        }
        if (user.attack.getOverridePower() == 0) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            this.heldItem = PixelmonItems.no_item;
            return AttackResult.failed;
        }
        user.bc.sendToAll("pixelmon.effect.fling", user.getNickname(), item.getLocalizedName());
        this.heldItem = user.getHeldItem();
        user.consumeItem();
        return AttackResult.proceed;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.isAlive() && this.heldItem != PixelmonItems.no_item && this.checkChance(user.bc)) {
            EnumHeldItems type = this.heldItem.getHeldItemType();
            if (type == EnumHeldItems.kingsRock || type == EnumHeldItems.razorFang) {
                Flinch.flinch(user, target);
            } else if (type == EnumHeldItems.lightBall) {
                Paralysis.paralyze(user, target, user.attack, true);
            } else if (type == EnumHeldItems.flameOrb) {
                Burn.burn(user, target, user.attack, true);
            } else if (type == EnumHeldItems.toxicOrb) {
                PoisonBadly.poisonBadly(user, target, user.attack, true);
            } else if (type == EnumHeldItems.typeEnhancer && ((TypeEnhancingItems)this.heldItem).enhanceType == EnumTypeEnhancingItems.poisonBarb) {
                Poison.poison(user, target, user.attack, true);
            } else if (this.heldItem.isBerry() && BerryItem.canEatBerry(target)) {
                HeldItem tempItem = target.getHeldItem();
                HeldItem tempConsumedItem = target.getConsumedItem();
                target.setHeldItem(this.heldItem);
                target.forceEatingBerry = true;
                target.getHeldItem().eatBerry(target);
                target.forceEatingBerry = false;
                target.setHeldItem(tempItem);
                target.setConsumedItem(tempConsumedItem);
            } else if (type == EnumHeldItems.whiteHerb) {
                WhiteHerbItem.healStats(target);
            } else if (type == EnumHeldItems.mentalHerb) {
                ((MentalHerbItem)this.heldItem).healStatus(target);
            }
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (int i = 0; i < userChoice.targets.size(); ++i) {
            if (userChoice.tier >= 3) continue;
            HeldItem item = pw.getHeldItem();
            EnumHeldItems type = item.getHeldItemType();
            if (type == EnumHeldItems.kingsRock || type == EnumHeldItems.razorFang) {
                Flinch flinch = new Flinch();
                flinch.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
                continue;
            }
            if (type == EnumHeldItems.lightBall) {
                Paralysis paralysis = new Paralysis();
                paralysis.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
                continue;
            }
            if (type == EnumHeldItems.flameOrb) {
                Burn burn = new Burn();
                burn.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
                continue;
            }
            if (type == EnumHeldItems.toxicOrb) {
                PoisonBadly poisonBadly = new PoisonBadly();
                poisonBadly.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
                continue;
            }
            if (type != EnumHeldItems.typeEnhancer || ((TypeEnhancingItems)item).enhanceType != EnumTypeEnhancingItems.poisonBarb) continue;
            Poison poison = new Poison();
            poison.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        }
    }
}

