/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SuctionCups;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;
import java.util.stream.Collectors;

public class Flee
extends SpecialAttackBase {
    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        boolean doesDamage;
        if (user.inParentalBond) {
            return;
        }
        if (user.attack == null) {
            results = new MoveResults(target);
            doesDamage = false;
        } else {
            results = user.attack.moveResult;
            boolean bl = doesDamage = user.attack.getMove().getBasePower() > 0;
        }
        if (target.isDynamax()) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            results.result = AttackResult.failed;
            return;
        }
        if (doesDamage) {
            if (target.getHealth() == 0 || target.hasStatus(StatusType.Substitute)) {
                return;
            }
            if (target.stopsForcedSwitches(user)) {
                return;
            }
        }
        if (target.getBattleAbility(user) instanceof SuctionCups) {
            target.getBattleAbility(user).stopsForcedSwitches(target, user);
            results.result = AttackResult.failed;
            return;
        }
        if (target.stopsForcedSwitches(user)) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            results.result = AttackResult.failed;
            return;
        }
        BattleParticipant targetParticipant = target.getParticipant();
        if ((targetParticipant.getType() == ParticipantType.WildPokemon || user.getParticipant().getType() == ParticipantType.WildPokemon) && target.getParticipant().allPokemon.length == 1) {
            if (target.getPokemonLevelNum() > user.getPokemonLevelNum()) {
                if (!doesDamage) {
                    target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                    results.result = AttackResult.failed;
                }
            } else if (!user.bc.simulateMode) {
                targetParticipant.isDefeated = true;
                if (!target.bc.isTeamDefeated(targetParticipant)) {
                    target.entity.m_6089_();
                    target.bc.updateRemovedPokemon(target);
                    target.bc.sendDamagePacket(target, target.getHealth());
                    target.entity.m_21153_(0.0f);
                } else {
                    target.bc.sendToAll("pixelmon.effect.flee", target.getNickname());
                    target.bc.endBattle(BattleEndCause.FLEE);
                }
            }
            return;
        }
        PixelmonWrapper randomPokemon = targetParticipant.getRandomPartyPokemon();
        if (randomPokemon != null) {
            if (user.bc.simulateMode) {
                return;
            }
            target.bc.sendToAll("pixelmon.effect.flee", target.getNickname());
            target.forceRandomSwitch(randomPokemon.getPokemonUUID());
        } else if (!doesDamage) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            results.result = AttackResult.failed;
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        BattleParticipant part = pw.getParticipant();
        if (userChoice.hitsAlly() || part instanceof WildPixelmonParticipant) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (pw.attack.getMove().getBasePower() > 0 && (userChoice.tier >= 3 || target.hasStatus(StatusType.Substitute, StatusType.Ingrain) || target.getBattleAbility() instanceof SuctionCups || !part.hasMorePokemonReserve()) || target.isDynamax > 0) {
                return;
            }
            userChoice.raiseWeight(target.getBattleStats().getSumStages() * 20);
            for (EntryHazard hazard2 : target.getEntryHazards().stream().filter(hazard -> hazard.type != StatusType.StickyWeb).collect(Collectors.toList())) {
                userChoice.raiseWeight(hazard2.getAIWeight() * hazard2.getNumLayers());
            }
        }
    }
}

