/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.RolePlay;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.Set;

public class Doodle
extends RolePlay {
    private static final Set<String> INVALID_ABILITIES = Sets.newHashSet((Object[])new String[]{"AsOne", "BattleBond", "Comatose", "Commander", "Disguise", "GulpMissile", "HadronEngine", "IceFace", "Multitype", "OrichalcumPulse", "PowerConstruct", "Protosynthesis", "QuarkDrive", "Revenant", "RKSSystem", "Schooling", "ShieldsDown", "StanceChange", "ZenMode", "ZeroToHero"});
    private static final Set<String> INVALID_TARGET_ABILITES = Sets.newHashSet((Object[])new String[]{"FlowerGift", "Forecast", "HungerSwitch", "Illusion", "Imposter", "NeutralizingGas", "PowerOfAlchemy", "Receiver", "Trace", "WonderGuard"});

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        AttackResult result = AttackResult.failed;
        ArrayList<PixelmonWrapper> team = user.bc.getTeamPokemon(user);
        Ability targetAbility = target.getBattleAbility(false);
        if (INVALID_ABILITIES.contains(targetAbility.getName()) || INVALID_TARGET_ABILITES.contains(targetAbility.getName()) || !targetAbility.canBeCopied()) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return result;
        }
        for (PixelmonWrapper ally : team) {
            Ability allyAbility = ally.getBattleAbility(false);
            if (!this.canOverrideAbility(allyAbility, targetAbility)) continue;
            result = AttackResult.succeeded;
            user.bc.sendToAll("pixelmon.effect.entrainment", ally.getNickname(), allyAbility.getTranslatedName(), targetAbility.getTranslatedName());
            ally.setTempAbility(targetAbility);
        }
        if (!result.isSuccess()) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
        return result;
    }

    private boolean canOverrideAbility(Ability teamAbility, Ability targetAbility) {
        return teamAbility.getClass() != targetAbility.getClass() && !INVALID_ABILITIES.contains(teamAbility.getName()) && teamAbility.canBeDisabled();
    }
}

