/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.status.Autotomize;
import com.pixelmonmod.pixelmon.battles.status.DefenseCurl;
import com.pixelmonmod.pixelmon.battles.status.GuardSplit;
import com.pixelmonmod.pixelmon.battles.status.Infatuated;
import com.pixelmonmod.pixelmon.battles.status.PowerSplit;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Substitute;
import com.pixelmonmod.pixelmon.battles.status.Transformed;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import java.util.List;
import java.util.UUID;

public class BatonPass
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        BattleParticipant userParticipant = user.getParticipant();
        if (!userParticipant.hasMorePokemonReserve() || user.stopsForcedSwitches(user)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (user.bc.simulateMode) {
            return AttackResult.succeeded;
        }
        user.bc.sendToAll("batonpass.pass", user.getNickname());
        BatonPass.switchPokemon(user);
        return AttackResult.succeeded;
    }

    public static void switchPokemon(PixelmonWrapper user) {
        user.nextSwitchIsMove = true;
        if (user.getParticipant() instanceof PlayerParticipant) {
            if (!user.bc.simulateMode) {
                user.wait = true;
                NetworkHelper.sendPacket(new EnforcedSwitchTask(user.bc.getPositionOfPokemon(user, user.getParticipant()), user.nextSwitchIsMove), user.getPlayerOwner());
            }
        } else {
            UUID switchTarget = user.getBattleAI().getNextSwitch(user);
            if (switchTarget == null) {
                user.nextSwitchIsMove = false;
            } else {
                user.bc.switchPokemon(user.getPokemonUUID(), switchTarget, true);
            }
        }
    }

    public static boolean isBatonPassable(StatusBase s) {
        return !(s instanceof StatusPersist) && !(s instanceof Autotomize) && !(s instanceof DefenseCurl) && !(s instanceof Infatuated) && !(s instanceof Transformed) && !(s instanceof GuardSplit) && !(s instanceof PowerSplit);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (pw.hasStatus(StatusType.Perish)) {
            return;
        }
        int stageMods = pw.getBattleStats().getSumStages();
        if (stageMods >= 0) {
            float weightIncrease = 0.0f;
            Substitute substitute = (Substitute)pw.getStatus(StatusType.Substitute);
            if (substitute != null) {
                weightIncrease += pw.getHealthPercent(substitute.health);
            }
            if ((weightIncrease += (float)(stageMods * 20)) > 0.0f && MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, userChoice.createList())) {
                weightIncrease += 30.0f;
            }
            userChoice.raiseWeightLimited(weightIncrease);
        }
    }
}

