/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.mojang.blaze3d.vertex.Tesselator;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.IAttackEffect;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystem;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackSwarm
extends ParticleSystem
implements IAttackEffect {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, Level w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        int power = (int)args[0];
        int accuracy = (int)args[1];
        Element type = Element.values()[(int)args[2]];
        int category = (int)args[3];
        double endX = args[4];
        double endY = args[5];
        double endZ = args[6];
        int startID = (int)args[7];
        int endID = (int)args[8];
        for (int i = 0; i < power + 5; ++i) {
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
        effect.maxAge = 30 - effect.hiddenUntil;
    }

    @Override
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        Vec3 vec = ParticleMathHelper.generatePointInSphere(0.2, RandomHelper.getRandom());
        particle.setMotion(effect.mX + vec.f_82479_, effect.mY + vec.f_82480_, effect.mZ + vec.f_82481_);
    }

    @Override
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
        Entity start = effect.mc.f_91073_.m_6815_(effect.startID);
        Entity end = effect.mc.f_91073_.m_6815_(effect.endID);
        if (start != null) {
            effect.startX = start.m_20185_() + (start.m_20191_().f_82291_ - start.m_20191_().f_82288_) / 2.0;
            effect.startY = start.m_20186_() + (start.m_20191_().f_82292_ - start.m_20191_().f_82289_) / 2.0;
            effect.startZ = start.m_20189_() + (start.m_20191_().f_82293_ - start.m_20191_().f_82290_) / 2.0;
        }
        if (end != null) {
            effect.endX = end.m_20185_() + (end.m_20191_().f_82291_ - end.m_20191_().f_82288_) / 2.0;
            effect.endY = end.m_20186_() + (end.m_20191_().f_82292_ - end.m_20191_().f_82289_) / 2.0;
            effect.endZ = end.m_20189_() + (end.m_20191_().f_82293_ - end.m_20191_().f_82290_) / 2.0;
        }
        effect.setHeading();
        particle.m_107264_(effect.startX, effect.startY, effect.startZ);
        particle.setPrevPos(effect.startX, effect.startY, effect.startZ);
        particle.setMotion(effect.mX, effect.mY, effect.mZ);
    }

    @Override
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        double ageLeft = 1.0 - (double)(particle.getAge() / Math.max(particle.m_107273_(), 1));
        double eolRadius = 0.7 * ageLeft;
        Vec3 vec = ParticleMathHelper.generatePointInSphere(eolRadius, RandomHelper.getRandom());
        particle.setMotion(effect.mX + vec.f_82479_, effect.mY + vec.f_82480_, effect.mZ + vec.f_82481_);
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.95f);
    }

    @Override
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
        if (!effect.eol) {
            Vec3 vec = ParticleMathHelper.generatePointInSphere(0.7, RandomHelper.getRandom());
            particle.setMotion(effect.mX + vec.f_82479_, effect.mY + vec.f_82480_, effect.mZ + vec.f_82481_);
        }
    }

    @Override
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    public void onRender(ParticleArcanery particle, Tesselator tesselator, float partialTicks, AttackEffect effect) {
    }
}

