/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.mojang.blaze3d.vertex.Tesselator;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackStatChange
extends AttackSystemBase<StatChangeData> {
    static final int PARTICLES_PER_STAGE = 8;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, Level w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        PixelmonEntity p = (PixelmonEntity)w.m_6815_(this.endID);
        float radius = p == null ? 2.0f : p.m_20205_();
        double randomisation = (double)RandomHelper.getRandom().nextFloat() * Math.PI * 2.0;
        double dTheta = 0.7853981633974483;
        float top = this.endPos[1] + 4.0f;
        float bot = this.endPos[1] + 0.25f;
        if (((StatChangeData)this.data).stages < 0) {
            float temp = top;
            top = bot;
            bot = temp;
        }
        for (int i = 0; i < Math.abs(((StatChangeData)this.data).stages); ++i) {
            for (int j = 0; j < 8; ++j) {
                float startX = (float)((double)this.endPos[0] + (double)radius * Math.cos(randomisation + dTheta * (double)j));
                float startZ = (float)((double)this.endPos[2] + (double)radius * Math.sin(randomisation + dTheta * (double)j));
                mc.f_91061_.m_107344_((Particle)new ParticleArcanery(startX, bot, startZ, 0.0, 0.0, 0.0, ((StatChangeData)this.data).makeEffect(this).setNoise(0.0).setStartPos(startX, bot, startZ).setEndPos(startX, top, startZ).setHideTicks(i * 8, true)));
            }
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(ParticleArcanery particle, Tesselator tesselator, float partialTicks, AttackEffect effect) {
    }

    public static class StatChangeData
    extends StandardParticleAnimationData {
        public BattleStatsType stat;
        public int stages;

        public StatChangeData() {
        }

        public StatChangeData(BattleStatsType stat, int stages) {
            this.stat = stat;
            this.stages = stages;
        }

        @Override
        public EnumEffectType getEffectEnum() {
            return EnumEffectType.STAT_CHANGE;
        }

        public StatChangeData setStat(BattleStatsType stat) {
            this.stat = stat;
            return this;
        }

        public StatChangeData setStages(int stages) {
            this.stages = stages;
            return this;
        }

        @Override
        public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
            if (this.speed == -1.0f) {
                this.speed = 0.15f;
            }
            if (this.stat == null) {
                this.stat = BattleStatsType.ATTACK;
            }
            if (this.stages == 0) {
                this.stages = 1;
            }
            if (this.scale <= 0.0f) {
                this.scale = 0.16f;
            }
            if (this.rgb == null) {
                switch (this.stat) {
                    case ATTACK: {
                        this.rgb = new int[]{237, 165, 64};
                        break;
                    }
                    case DEFENSE: {
                        this.rgb = new int[]{99, 171, 94};
                        break;
                    }
                    case SPECIAL_ATTACK: {
                        this.rgb = new int[]{228, 32, 48};
                        break;
                    }
                    case SPECIAL_DEFENSE: {
                        this.rgb = new int[]{147, 194, 26};
                        break;
                    }
                    case SPEED: {
                        this.rgb = new int[]{16, 168, 246};
                        break;
                    }
                    case EVASION: {
                        this.rgb = new int[]{206, 84, 236};
                        break;
                    }
                    case ACCURACY: {
                        this.rgb = new int[]{255, 204, 255};
                    }
                }
            }
            if (this.texture == null) {
                this.texture = this.stages < 0 ? AttackEffect.EnumParticleTexture.DOWN_ARROW : AttackEffect.EnumParticleTexture.UP_ARROW;
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeBoolean(this.stat != null);
            if (this.stat != null) {
                buf.writeByte(this.stat.ordinal());
            }
            buf.writeByte(this.stages);
        }

        @Override
        public StatChangeData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            if (buf.readBoolean()) {
                this.stat = BattleStatsType.values()[buf.readByte()];
            }
            this.stages = buf.readByte();
            return this;
        }
    }
}

